/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql;

import com.wix.mysql.MysqldExecutable;
import com.wix.mysql.SqlScriptSource;
import com.wix.mysql.config.MysqldConfig;
import com.wix.mysql.exceptions.CommandFailedException;
import com.wix.mysql.utils.Utils;
import de.flapdoodle.embed.process.distribution.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.IOUtils;

class MysqlClient {
    private final MysqldConfig config;
    private final MysqldExecutable executable;
    private final String schemaName;

    public MysqlClient(MysqldConfig config, MysqldExecutable executable, String schemaName) {
        this.config = config;
        this.executable = executable;
        this.schemaName = schemaName;
    }

    void executeScripts(List<SqlScriptSource> sqls) {
        try {
            for (SqlScriptSource sql : sqls) {
                this.execute(sql.read());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void executeCommands(String ... sqls) {
        for (String sql : sqls) {
            this.execute(sql);
        }
    }

    private void execute(String sql) {
        String command = Platform.detect() == Platform.Windows ? String.format("\"%s\"", sql) : sql;
        try {
            Process p = new ProcessBuilder(Paths.get(this.executable.getBaseDir().getAbsolutePath(), "bin", "mysql").toString(), "--protocol=tcp", "--host=localhost", "--password=", String.format("--user=%s", "root"), String.format("--port=%s", this.config.getPort()), this.schemaName).start();
            IOUtils.copy((Reader)new StringReader(sql), (OutputStream)p.getOutputStream(), (Charset)Charset.defaultCharset());
            p.getOutputStream().close();
            if (p.waitFor() != 0) {
                String out = IOUtils.toString((InputStream)p.getInputStream());
                String err = IOUtils.toString((InputStream)p.getErrorStream());
                if (Utils.isNullOrEmpty(out)) {
                    throw new CommandFailedException(command, this.schemaName, p.waitFor(), err);
                }
                throw new CommandFailedException(command, this.schemaName, p.waitFor(), out);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new CommandFailedException(command, this.schemaName, e.getMessage(), e);
        }
    }
}

