/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.yahoo.elide.annotation.ComputedAttribute;
import com.yahoo.elide.annotation.Exclude;
import com.yahoo.elide.annotation.OnCommit;
import com.yahoo.elide.annotation.OnCreate;
import com.yahoo.elide.annotation.OnDelete;
import com.yahoo.elide.annotation.OnUpdate;
import com.yahoo.elide.core.Initializer;
import com.yahoo.elide.core.RelationshipType;
import com.yahoo.elide.core.exceptions.DuplicateMappingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.MultiValueMap;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.Pair;

class EntityBinding {
    private static final List<Method> OBJ_METHODS = Arrays.asList(Object.class.getMethods());
    public final String jsonApi;
    public final ConcurrentLinkedDeque<String> attrsDeque;
    public final List<String> attrs;
    public final ConcurrentLinkedDeque<String> relationshipsDeque;
    public final List<String> relationships;
    public final ConcurrentHashMap<String, RelationshipType> relationshipTypes;
    public final ConcurrentHashMap<String, String> relationshipToInverse;
    public final ConcurrentHashMap<String, AccessibleObject> fieldsToValues;
    public final ConcurrentHashMap<String, Class<?>> fieldsToTypes;
    public final ConcurrentHashMap<String, String> aliasesToFields;
    public final MultiValueMap<Pair<Class, String>, Method> fieldsToTriggers;
    private AccessibleObject idField;
    private Class<?> idType;
    private Initializer initializer;
    public static final EntityBinding EMPTY_BINDING = new EntityBinding();

    private EntityBinding() {
        this.jsonApi = null;
        this.idField = null;
        this.idType = null;
        this.attrsDeque = null;
        this.attrs = null;
        this.relationshipsDeque = null;
        this.relationships = null;
        this.relationshipTypes = null;
        this.relationshipToInverse = null;
        this.fieldsToValues = null;
        this.fieldsToTypes = null;
        this.fieldsToTriggers = new MultiValueMap();
        this.aliasesToFields = null;
    }

    public EntityBinding(Class<?> cls, String type) {
        Collection fieldOrMethodList = CollectionUtils.union(Arrays.asList(cls.getFields()), Arrays.asList(cls.getMethods()));
        this.jsonApi = type;
        this.attrsDeque = new ConcurrentLinkedDeque();
        this.relationshipsDeque = new ConcurrentLinkedDeque();
        this.relationshipTypes = new ConcurrentHashMap();
        this.relationshipToInverse = new ConcurrentHashMap();
        this.fieldsToValues = new ConcurrentHashMap();
        this.fieldsToTypes = new ConcurrentHashMap();
        this.fieldsToTriggers = new MultiValueMap();
        this.aliasesToFields = new ConcurrentHashMap();
        this.bindEntityFields(cls, type, fieldOrMethodList);
        this.attrs = EntityBinding.dequeToList(this.attrsDeque);
        this.relationships = EntityBinding.dequeToList(this.relationshipsDeque);
    }

    private void bindEntityFields(Class<?> cls, String type, Collection<AccessibleObject> fieldOrMethodList) {
        for (AccessibleObject fieldOrMethod : fieldOrMethodList) {
            this.bindTrigger(OnCreate.class, fieldOrMethod);
            this.bindTrigger(OnDelete.class, fieldOrMethod);
            this.bindTrigger(OnUpdate.class, fieldOrMethod);
            this.bindTrigger(OnCommit.class, fieldOrMethod);
            if (fieldOrMethod.isAnnotationPresent(Id.class)) {
                this.bindEntityId(cls, type, fieldOrMethod);
                continue;
            }
            if (fieldOrMethod.isAnnotationPresent(Transient.class) && !fieldOrMethod.isAnnotationPresent(ComputedAttribute.class) || fieldOrMethod.isAnnotationPresent(Exclude.class) || fieldOrMethod instanceof Field && Modifier.isTransient(((Field)fieldOrMethod).getModifiers()) || fieldOrMethod instanceof Method && Modifier.isTransient(((Method)fieldOrMethod).getModifiers()) || fieldOrMethod instanceof Field && !fieldOrMethod.isAnnotationPresent(Column.class) && Modifier.isStatic(((Field)fieldOrMethod).getModifiers())) continue;
            this.bindAttrOrRelation(cls, fieldOrMethod);
        }
    }

    private void bindEntityId(Class<?> cls, String type, AccessibleObject fieldOrMethod) {
        String fieldName = EntityBinding.getFieldName(fieldOrMethod);
        Class<?> fieldType = EntityBinding.getFieldType(fieldOrMethod);
        this.fieldsToTypes.put(fieldName, fieldType);
        this.idField = fieldOrMethod;
        this.idType = fieldType;
        if (this.idField != null && !fieldOrMethod.equals(this.idField)) {
            throw new DuplicateMappingException(type + " " + cls.getName() + ":" + fieldName);
        }
    }

    private static List<String> dequeToList(Deque<String> deque) {
        ArrayList result = new ArrayList();
        deque.stream().forEachOrdered(result::add);
        result.sort(String.CASE_INSENSITIVE_ORDER);
        return Collections.unmodifiableList(result);
    }

    private void bindAttrOrRelation(Class<?> cls, AccessibleObject fieldOrMethod) {
        ConcurrentLinkedDeque<String> fieldList;
        boolean manyToMany = fieldOrMethod.isAnnotationPresent(ManyToMany.class);
        boolean manyToOne = fieldOrMethod.isAnnotationPresent(ManyToOne.class);
        boolean oneToMany = fieldOrMethod.isAnnotationPresent(OneToMany.class);
        boolean oneToOne = fieldOrMethod.isAnnotationPresent(OneToOne.class);
        boolean isRelation = manyToMany || manyToOne || oneToMany || oneToOne;
        String fieldName = EntityBinding.getFieldName(fieldOrMethod);
        if (fieldName == null || fieldName.equals("id") || fieldName.equals("class") || OBJ_METHODS.contains(fieldOrMethod)) {
            return;
        }
        Class<?> fieldType = EntityBinding.getFieldType(fieldOrMethod);
        if (isRelation) {
            String mappedBy;
            RelationshipType type;
            fieldList = this.relationshipsDeque;
            if (oneToMany) {
                type = RelationshipType.ONE_TO_MANY;
                mappedBy = fieldOrMethod.getAnnotation(OneToMany.class).mappedBy();
            } else if (oneToOne) {
                type = RelationshipType.ONE_TO_ONE;
                mappedBy = fieldOrMethod.getAnnotation(OneToOne.class).mappedBy();
            } else if (manyToMany) {
                type = RelationshipType.MANY_TO_MANY;
                mappedBy = fieldOrMethod.getAnnotation(ManyToMany.class).mappedBy();
            } else if (manyToOne) {
                type = RelationshipType.MANY_TO_ONE;
                mappedBy = "";
            } else {
                type = RelationshipType.NONE;
                mappedBy = "";
            }
            this.relationshipTypes.put(fieldName, type);
            this.relationshipToInverse.put(fieldName, mappedBy);
        } else {
            fieldList = this.attrsDeque;
        }
        fieldList.push(fieldName);
        this.fieldsToValues.put(fieldName, fieldOrMethod);
        this.fieldsToTypes.put(fieldName, fieldType);
    }

    private static String getFieldName(AccessibleObject fieldOrMethod) {
        if (fieldOrMethod instanceof Field) {
            return ((Field)fieldOrMethod).getName();
        }
        Method method = (Method)fieldOrMethod;
        String name = method.getName();
        if (name.startsWith("get") && method.getParameterCount() == 0) {
            name = WordUtils.uncapitalize((String)name.substring("get".length()));
        } else if (name.startsWith("is") && method.getParameterCount() == 0) {
            name = WordUtils.uncapitalize((String)name.substring("is".length()));
        } else {
            return null;
        }
        return name;
    }

    private static Class<?> getFieldType(AccessibleObject fieldOrMethod) {
        if (fieldOrMethod instanceof Field) {
            return ((Field)fieldOrMethod).getType();
        }
        return ((Method)fieldOrMethod).getReturnType();
    }

    private <A extends Annotation> void bindTrigger(Class<A> annotationClass, AccessibleObject fieldOrMethod) {
        if (fieldOrMethod instanceof Method && fieldOrMethod.isAnnotationPresent(annotationClass)) {
            String value;
            A onTrigger = fieldOrMethod.getAnnotation(annotationClass);
            try {
                value = (String)annotationClass.getMethod("value", new Class[0]).invoke(onTrigger, new Object[0]);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                value = "";
            }
            this.fieldsToTriggers.put((Object)Pair.of(annotationClass, (Object)value), (Object)fieldOrMethod);
        }
    }

    public <A extends Annotation> Collection<Method> getTriggers(Class<A> annotationClass, String fieldName) {
        Collection methods = this.fieldsToTriggers.getCollection((Object)Pair.of(annotationClass, (Object)fieldName));
        return methods == null ? Collections.emptyList() : methods;
    }

    public AccessibleObject getIdField() {
        return this.idField;
    }

    public Class<?> getIdType() {
        return this.idType;
    }

    public Initializer getInitializer() {
        return this.initializer;
    }

    public void setInitializer(Initializer initializer) {
        this.initializer = initializer;
    }
}

