/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.google.common.base.Preconditions;
import com.yahoo.elide.annotation.CreatePermission;
import com.yahoo.elide.annotation.OnCommit;
import com.yahoo.elide.audit.Logger;
import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.ObjectEntityCache;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.SecurityMode;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.filter.Predicate;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.security.Check;
import com.yahoo.elide.security.User;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;

public class RequestScope {
    private final JsonApiDocument jsonApiDocument;
    private final DataStoreTransaction transaction;
    private final User user;
    private final EntityDictionary dictionary;
    private final JsonApiMapper mapper;
    private final Logger logger;
    private final Optional<MultivaluedMap<String, String>> queryParams;
    private final Map<String, Set<String>> sparseFields;
    private final Map<String, Set<Predicate>> predicates;
    private final ObjectEntityCache objectEntityCache;
    private final SecurityMode securityMode;
    private final Set<PersistentResource> newResources;
    private transient LinkedHashSet<Runnable> deferredChecks = null;
    private final transient LinkedHashSet<Runnable> commitTriggers;
    private boolean notDeferred = false;

    public RequestScope(JsonApiDocument jsonApiDocument, DataStoreTransaction transaction, User user, EntityDictionary dictionary, JsonApiMapper mapper, Logger logger, MultivaluedMap<String, String> queryParams, SecurityMode securityMode) {
        this.jsonApiDocument = jsonApiDocument;
        this.transaction = transaction;
        this.user = user;
        this.dictionary = dictionary;
        this.mapper = mapper;
        this.logger = logger;
        this.queryParams = queryParams == null || queryParams.size() == 0 ? Optional.empty() : Optional.of(queryParams);
        this.objectEntityCache = new ObjectEntityCache();
        this.securityMode = securityMode;
        if (this.queryParams.isPresent()) {
            this.sparseFields = RequestScope.parseSparseFields(this.queryParams.get());
            this.predicates = Predicate.parseQueryParams(this.dictionary, this.queryParams.get());
        } else {
            this.sparseFields = Collections.emptyMap();
            this.predicates = Collections.emptyMap();
        }
        this.newResources = new LinkedHashSet<PersistentResource>();
        this.commitTriggers = new LinkedHashSet();
    }

    public RequestScope(JsonApiDocument jsonApiDocument, DataStoreTransaction transaction, User user, EntityDictionary dictionary, JsonApiMapper mapper, Logger logger, SecurityMode securityMode) {
        this(jsonApiDocument, transaction, user, dictionary, mapper, logger, null, securityMode);
    }

    public RequestScope(JsonApiDocument jsonApiDocument, DataStoreTransaction transaction, User user, EntityDictionary dictionary, JsonApiMapper mapper, Logger logger, MultivaluedMap<String, String> queryParams) {
        this(jsonApiDocument, transaction, user, dictionary, mapper, logger, queryParams, SecurityMode.ACTIVE);
    }

    public RequestScope(JsonApiDocument jsonApiDocument, DataStoreTransaction transaction, User user, EntityDictionary dictionary, JsonApiMapper mapper, Logger logger) {
        this(jsonApiDocument, transaction, user, dictionary, mapper, logger, null, SecurityMode.ACTIVE);
    }

    protected RequestScope(DataStoreTransaction transaction, User user, EntityDictionary dictionary, JsonApiMapper mapper, Logger logger) {
        this(null, transaction, user, dictionary, mapper, logger);
        this.deferredChecks = new LinkedHashSet();
    }

    protected RequestScope(JsonApiDocument jsonApiDocument, RequestScope outerRequestScope) {
        this.jsonApiDocument = jsonApiDocument;
        this.transaction = outerRequestScope.transaction;
        this.user = outerRequestScope.user;
        this.dictionary = outerRequestScope.dictionary;
        this.mapper = outerRequestScope.mapper;
        this.logger = outerRequestScope.logger;
        this.queryParams = Optional.empty();
        this.sparseFields = Collections.emptyMap();
        this.predicates = Collections.emptyMap();
        this.objectEntityCache = outerRequestScope.objectEntityCache;
        this.securityMode = outerRequestScope.securityMode;
        this.deferredChecks = outerRequestScope.deferredChecks;
        this.newResources = outerRequestScope.newResources;
        this.commitTriggers = outerRequestScope.commitTriggers;
    }

    private static Map<String, Set<String>> parseSparseFields(MultivaluedMap<String, String> queryParams) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry kv : queryParams.entrySet()) {
            String key = (String)kv.getKey();
            if (!key.startsWith("fields[") || !key.endsWith("]")) continue;
            String type = key.substring(7, key.length() - 1);
            LinkedHashSet filters = new LinkedHashSet();
            for (String filterParams : (List)kv.getValue()) {
                Collections.addAll(filters, filterParams.split(","));
            }
            if (filters.isEmpty()) continue;
            result.put(type, filters);
        }
        return result;
    }

    public Set<Predicate> getPredicatesOfType(String type) {
        return this.predicates.getOrDefault(type, Collections.emptySet());
    }

    public void runDeferredPermissionChecks() {
        if (this.deferredChecks != null) {
            try {
                new ArrayList<Runnable>(this.deferredChecks).forEach(Runnable::run);
            }
            finally {
                this.deferredChecks = null;
            }
        }
    }

    public void runCommitTriggers() {
        new ArrayList<Runnable>(this.commitTriggers).forEach(Runnable::run);
        this.commitTriggers.clear();
    }

    public void checkPermissions(Class<?> annotationClass, Class<? extends Check>[] checks, boolean isAny, PersistentResource resource) {
        this.checkPermissions(annotationClass, new CheckPermissions(annotationClass, checks, isAny, resource));
    }

    public <A extends Annotation> void checkFieldAwarePermissions(Class<A> annotationClass, PersistentResource resource) {
        this.checkPermissions(annotationClass, new FieldAwareCheck<A>(annotationClass, resource));
    }

    public <A extends Annotation> void checkFieldAwarePermissions(Class<A> annotationClass, PersistentResource resource, String fieldName) {
        this.checkPermissions(annotationClass, new FieldAwareCheck<A>(annotationClass, resource, fieldName));
    }

    public void queueCommitTrigger(PersistentResource resource) {
        this.queueCommitTrigger(resource, "");
    }

    public void queueCommitTrigger(PersistentResource resource, String fieldName) {
        this.commitTriggers.add(() -> resource.runTriggers(OnCommit.class, fieldName));
    }

    private void checkPermissions(Class<?> annotationClass, Runnable task) {
        if (this.deferredChecks == null && CreatePermission.class.equals(annotationClass)) {
            this.deferredChecks = new LinkedHashSet();
        }
        if (this.deferredChecks == null || this.notDeferred) {
            task.run();
        } else {
            this.deferredChecks.add(task);
        }
    }

    public JsonApiDocument getJsonApiDocument() {
        return this.jsonApiDocument;
    }

    public DataStoreTransaction getTransaction() {
        return this.transaction;
    }

    public User getUser() {
        return this.user;
    }

    public EntityDictionary getDictionary() {
        return this.dictionary;
    }

    public JsonApiMapper getMapper() {
        return this.mapper;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Optional<MultivaluedMap<String, String>> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, Set<String>> getSparseFields() {
        return this.sparseFields;
    }

    public Map<String, Set<Predicate>> getPredicates() {
        return this.predicates;
    }

    public ObjectEntityCache getObjectEntityCache() {
        return this.objectEntityCache;
    }

    public SecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public Set<PersistentResource> getNewResources() {
        return this.newResources;
    }

    boolean isNotDeferred() {
        return this.notDeferred;
    }

    void setNotDeferred(boolean notDeferred) {
        this.notDeferred = notDeferred;
    }

    private static class FieldAwareCheck<A extends Annotation>
    implements Runnable {
        final Class<A> annotationClass;
        final PersistentResource resource;
        final String fieldName;

        public FieldAwareCheck(Class<A> annotationClass, PersistentResource resource) {
            this.annotationClass = annotationClass;
            this.resource = resource;
            this.fieldName = null;
        }

        public FieldAwareCheck(Class<A> annotationClass, PersistentResource resource, String fieldName) {
            this.annotationClass = annotationClass;
            this.resource = resource;
            this.fieldName = fieldName;
        }

        @Override
        public void run() {
            boolean save = this.resource.getRequestScope().notDeferred;
            try {
                this.resource.getRequestScope().notDeferred = true;
                if (this.fieldName != null && !this.fieldName.isEmpty()) {
                    this.specificField(this.fieldName);
                } else {
                    this.allFields();
                }
            }
            finally {
                this.resource.getRequestScope().notDeferred = save;
            }
        }

        private void specificField(String theField) {
            assert (this.resource.getRequestScope().isNotDeferred());
            try {
                PersistentResource.checkPermission(this.annotationClass, this.resource);
            }
            catch (ForbiddenAccessException e) {
                PersistentResource.checkFieldPermissionIfExists(this.annotationClass, this.resource, theField);
            }
            PersistentResource.checkFieldPermission(this.annotationClass, this.resource, theField);
        }

        private void allFields() {
            assert (this.resource.getRequestScope().isNotDeferred());
            EntityDictionary dictionary = this.resource.getDictionary();
            try {
                PersistentResource.checkPermission(this.annotationClass, this.resource);
                return;
            }
            catch (ForbiddenAccessException forbiddenAccessException) {
                for (String attr : dictionary.getAttributes(this.resource.getObject().getClass())) {
                    try {
                        this.specificField(attr);
                        return;
                    }
                    catch (ForbiddenAccessException e) {
                    }
                }
                for (String rel : dictionary.getRelationships(this.resource.getObject().getClass())) {
                    try {
                        this.specificField(rel);
                        return;
                    }
                    catch (ForbiddenAccessException e) {
                    }
                }
                throw new ForbiddenAccessException();
            }
        }
    }

    private static class CheckPermissions
    implements Runnable {
        final Class<? extends Check>[] anyChecks;
        final boolean any;
        final PersistentResource resource;

        public CheckPermissions(Class<?> annotationClass, Class<? extends Check>[] checks, boolean isAny, PersistentResource resource) {
            Preconditions.checkArgument((checks.length > 0 ? 1 : 0) != 0);
            this.anyChecks = Arrays.copyOf(checks, checks.length);
            this.any = isAny;
            this.resource = resource;
        }

        @Override
        public void run() {
            PersistentResource.checkPermissions(this.anyChecks, this.any, this.resource);
        }

        public String toString() {
            return "CheckPermissions [anyChecks=" + Arrays.toString(this.anyChecks) + ", any=" + this.any + ", resource=" + this.resource.getId() + ", user=" + this.resource.getRequestScope().getUser() + "]";
        }
    }
}

