/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.exceptions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpStatusException
extends RuntimeException {
    private static final Logger log = LoggerFactory.getLogger(HttpStatusException.class);
    private static final long serialVersionUID = 1L;
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public abstract int getStatus();

    public HttpStatusException() {
        this((String)null);
    }

    public HttpStatusException(String message) {
        this(message, null);
    }

    public HttpStatusException(String message, Throwable cause) {
        super(message, cause, true, log.isTraceEnabled());
    }

    public Pair<Integer, JsonNode> getErrorResponse() {
        Map<String, List<String>> errors = Collections.singletonMap("errors", Collections.singletonList(this.getMessage() == null ? this.toString() : this.getMessage()));
        JsonNode responseBody = (JsonNode)OBJECT_MAPPER.convertValue(errors, JsonNode.class);
        return Pair.of((Object)this.getStatus(), (Object)responseBody);
    }
}

