/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidPredicateException;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.utils.coerce.CoerceUtil;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedMap;
import lombok.NonNull;

public class Predicate {
    @NonNull
    private String field;
    @NonNull
    private Operator operator;
    @NonNull
    private List<Object> values;

    public static Map<String, Set<Predicate>> parseQueryParams(EntityDictionary dictionary, MultivaluedMap<String, String> queryParams) {
        HashMap<String, Set<Predicate>> predicates = new HashMap<String, Set<Predicate>>();
        queryParams.entrySet().forEach(queryParameter -> {
            Matcher matcher = Pattern.compile("filter\\[([^\\]]+)\\](\\[([^\\]]+)\\])?").matcher((CharSequence)queryParameter.getKey());
            if (matcher.find()) {
                String[] keyParts = matcher.group(1).split("\\.");
                if (keyParts.length != 2) {
                    throw new InvalidPredicateException("Invalid filter format: " + (String)queryParameter.getKey());
                }
                String type = keyParts[0];
                String field = keyParts[1];
                Operator operator = matcher.group(3) == null ? Operator.IN : Operator.fromString(matcher.group(3));
                Class<?> entityClass = dictionary.getBinding(type);
                if (entityClass == null) {
                    throw new InvalidPredicateException("Unknown entity in filter: " + type);
                }
                Class<?> fieldType = dictionary.getParameterizedType(entityClass, field);
                if (fieldType == null) {
                    throw new InvalidPredicateException("Unknown field in filter: " + field);
                }
                ArrayList<Object> values = new ArrayList<Object>();
                for (String valueParams : (List)queryParameter.getValue()) {
                    for (String valueParam : valueParams.split(",")) {
                        values.add(CoerceUtil.coerce(valueParam, fieldType));
                    }
                }
                if (!predicates.containsKey(type)) {
                    predicates.put(type, new LinkedHashSet());
                }
                ((Set)predicates.get(type)).add(new Predicate(field, operator, values));
            }
        });
        return predicates;
    }

    @ConstructorProperties(value={"field", "operator", "values"})
    public Predicate(@NonNull String field, @NonNull Operator operator, @NonNull List<Object> values) {
        if (field == null) {
            throw new NullPointerException("field");
        }
        if (operator == null) {
            throw new NullPointerException("operator");
        }
        if (values == null) {
            throw new NullPointerException("values");
        }
        this.field = field;
        this.operator = operator;
        this.values = values;
    }

    public String toString() {
        return "Predicate(field=" + this.getField() + ", operator=" + (Object)((Object)this.getOperator()) + ", values=" + this.getValues() + ")";
    }

    @NonNull
    public String getField() {
        return this.field;
    }

    @NonNull
    public Operator getOperator() {
        return this.operator;
    }

    @NonNull
    public List<Object> getValues() {
        return this.values;
    }
}

