/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.document.processors;

import com.google.common.collect.Ordering;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.jsonapi.document.processors.DocumentProcessor;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.models.Resource;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;

public class SortProcessor
implements DocumentProcessor {
    public static final String SORT_PARAM = "sort";
    public static final char DESCENDING_TOKEN = '-';

    @Override
    public void execute(JsonApiDocument jsonApiDocument, PersistentResource resource, Optional<MultivaluedMap<String, String>> queryParams) {
    }

    @Override
    public void execute(JsonApiDocument jsonApiDocument, Set<PersistentResource> resources, Optional<MultivaluedMap<String, String>> queryParams) {
        queryParams.filter(params -> params.containsKey((Object)SORT_PARAM)).ifPresent(params -> {
            List sortFields = (List)params.get((Object)SORT_PARAM);
            this.sort(jsonApiDocument.getData(), sortFields);
        });
    }

    private void sort(Data<Resource> data, List<String> sortFields) {
        List<Comparator<Resource>> comparisonFunctions = this.buildComparisonFunctions(sortFields);
        data.sort((a, b) -> Ordering.compound((Iterable)comparisonFunctions).compare(a, b));
    }

    private List<Comparator<Resource>> buildComparisonFunctions(List<String> sortFields) {
        return sortFields.stream().map(this::comparisonForField).collect(Collectors.toList());
    }

    private Comparator<Resource> comparisonForField(String field) {
        if (field.charAt(0) == '-') {
            String parsedField = field.substring(1);
            return Ordering.from(this.attributeComparison(parsedField)).nullsFirst().reverse();
        }
        return Ordering.from(this.attributeComparison(field)).nullsFirst();
    }

    private Comparator<Resource> attributeComparison(String field) {
        return (a, b) -> Ordering.from(this::compareObjects).nullsFirst().compare(a.getAttributes().get(field), b.getAttributes().get(field));
    }

    private int compareObjects(Object a, Object b) {
        if (a instanceof Comparable) {
            return ((Comparable)a).compareTo(b);
        }
        return 0;
    }
}

