/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.Meta;
import com.yahoo.elide.jsonapi.models.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class JsonApiDocument {
    private Data<Resource> data = null;
    private Meta meta;
    private final Map<String, String> links = new LinkedHashMap<String, String>();
    private final LinkedHashSet<Resource> includedRecs;
    private final List<Resource> included = new ArrayList<Resource>();

    public JsonApiDocument() {
        this.includedRecs = new LinkedHashSet();
    }

    public void setData(Data<Resource> data) {
        this.data = data;
        this.meta = null;
    }

    public Data<Resource> getData() {
        if (this.data == null) {
            return null;
        }
        return this.data;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Meta getMeta() {
        return this.meta;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, String> getLinks() {
        return this.links.isEmpty() ? null : this.links;
    }

    public void addLink(String key, String val) {
        this.links.put(key, val);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Resource> getIncluded() {
        return this.included.isEmpty() ? null : this.included;
    }

    public void addIncluded(Resource resource) {
        if (!this.includedRecs.contains(resource)) {
            this.included.add(resource);
            this.includedRecs.add(resource);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(37, 79).append(this.data).append((Object)this.meta).append(this.includedRecs).append(this.links).append(this.included).build();
    }

    public boolean equals(Object obj) {
        JsonApiDocument other;
        block6: {
            block7: {
                if (!(obj instanceof JsonApiDocument)) {
                    return false;
                }
                other = (JsonApiDocument)obj;
                Collection<Resource> resources = this.data.get();
                if ((resources == null || other.getData().get() == null) && resources != other.getData().get()) {
                    return false;
                }
                if (resources == null) break block6;
                if (resources.size() != other.getData().get().size()) break block7;
                if (resources.stream().allMatch(other.getData().get()::contains)) break block6;
            }
            return false;
        }
        if (other.getIncluded() == null) {
            return this.included.isEmpty();
        }
        return this.included.stream().allMatch(other.getIncluded()::contains);
    }

    public String toString() {
        return "JsonApiDocument(data=" + this.getData() + ", meta=" + this.getMeta() + ", links=" + this.getLinks() + ", includedRecs=" + this.includedRecs + ", included=" + this.getIncluded() + ")";
    }
}

