/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.parsers.state;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.exceptions.InvalidAttributeException;
import com.yahoo.elide.core.exceptions.InvalidCollectionException;
import com.yahoo.elide.generated.parsers.CoreParser;
import com.yahoo.elide.jsonapi.models.SingleElementSet;
import com.yahoo.elide.parsers.state.BaseState;
import com.yahoo.elide.parsers.state.CollectionTerminalState;
import com.yahoo.elide.parsers.state.RecordTerminalState;
import com.yahoo.elide.parsers.state.RelationshipTerminalState;
import com.yahoo.elide.parsers.state.StateContext;
import java.util.Optional;
import java.util.Set;

public class RecordState
extends BaseState {
    private final PersistentResource resource;

    public RecordState(PersistentResource resource) {
        Preconditions.checkNotNull((Object)resource);
        this.resource = resource;
    }

    @Override
    public void handle(StateContext state, CoreParser.SubCollectionReadCollectionContext ctx) {
        String subCollection = ctx.term().getText();
        EntityDictionary dictionary = state.getRequestScope().getDictionary();
        try {
            BaseState nextState;
            Set<PersistentResource> collection = this.resource.getRelation(subCollection);
            String entityName = dictionary.getBinding(dictionary.getParameterizedType(this.resource.getObject(), subCollection));
            Class<?> entityClass = dictionary.getBinding(entityName);
            if (entityClass == null) {
                throw new IllegalArgumentException("Unknown type " + entityName);
            }
            if (collection instanceof SingleElementSet) {
                PersistentResource record = collection.iterator().next();
                nextState = new RecordTerminalState(record);
            } else {
                nextState = new CollectionTerminalState(entityClass, Optional.of(this.resource), Optional.of(subCollection));
            }
            state.setState(nextState);
        }
        catch (InvalidAttributeException e) {
            throw new InvalidCollectionException(subCollection);
        }
    }

    @Override
    public void handle(StateContext state, CoreParser.SubCollectionReadEntityContext ctx) {
        String id = ctx.entity().id().getText();
        String subCollection = ctx.entity().term().getText();
        try {
            PersistentResource nextRecord = this.resource.getRelation(subCollection, id);
            state.setState(new RecordTerminalState(nextRecord));
        }
        catch (InvalidAttributeException e) {
            throw new InvalidCollectionException(subCollection);
        }
    }

    @Override
    public void handle(StateContext state, CoreParser.SubCollectionSubCollectionContext ctx) {
        String id = ctx.entity().id().getText();
        String subCollection = ctx.entity().term().getText();
        try {
            state.setState(new RecordState(this.resource.getRelation(subCollection, id)));
        }
        catch (InvalidAttributeException e) {
            throw new InvalidCollectionException(subCollection);
        }
    }

    @Override
    public void handle(StateContext state, CoreParser.SubCollectionRelationshipContext ctx) {
        PersistentResource childRecord;
        String id = ctx.entity().id().getText();
        String subCollection = ctx.entity().term().getText();
        try {
            childRecord = this.resource.getRelation(subCollection, id);
        }
        catch (InvalidAttributeException e) {
            throw new InvalidCollectionException(subCollection);
        }
        String relationName = ctx.relationship().term().getText();
        try {
            childRecord.getRelation(relationName);
        }
        catch (InvalidAttributeException e) {
            throw new InvalidCollectionException(relationName);
        }
        state.setState(new RelationshipTerminalState(childRecord, relationName));
    }
}

