/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.parsers.state;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.exceptions.InvalidAttributeException;
import com.yahoo.elide.core.exceptions.InvalidCollectionException;
import com.yahoo.elide.generated.parsers.CoreParser;
import com.yahoo.elide.parsers.state.BaseState;
import com.yahoo.elide.parsers.state.CollectionTerminalState;
import com.yahoo.elide.parsers.state.RecordState;
import com.yahoo.elide.parsers.state.RecordTerminalState;
import com.yahoo.elide.parsers.state.RelationshipTerminalState;
import com.yahoo.elide.parsers.state.StateContext;
import java.util.Optional;

public class StartState
extends BaseState {
    @Override
    public void handle(StateContext state, CoreParser.RootCollectionLoadEntitiesContext ctx) {
        String entityName = ctx.term().getText();
        EntityDictionary dictionary = state.getRequestScope().getDictionary();
        Class<?> entityClass = dictionary.getBinding(entityName);
        if (entityClass == null || !dictionary.isRoot(entityClass)) {
            throw new InvalidCollectionException(entityName);
        }
        state.setState(new CollectionTerminalState(entityClass, Optional.empty(), Optional.empty()));
    }

    @Override
    public void handle(StateContext state, CoreParser.RootCollectionLoadEntityContext ctx) {
        EntityDictionary dictionary = state.getRequestScope().getDictionary();
        String entityName = ctx.entity().term().getText();
        String id = ctx.entity().id().getText();
        Class<?> entityClass = dictionary.getBinding(entityName);
        if (entityClass == null || !dictionary.isRoot(entityClass)) {
            throw new InvalidCollectionException(entityName);
        }
        PersistentResource<?> record = PersistentResource.loadRecord(entityClass, id, state.getRequestScope());
        state.setState(new RecordTerminalState(record));
    }

    @Override
    public void handle(StateContext state, CoreParser.RootCollectionSubCollectionContext ctx) {
        EntityDictionary dictionary = state.getRequestScope().getDictionary();
        String entityName = ctx.entity().term().getText();
        String id = ctx.entity().id().getText();
        Class<?> entityClass = dictionary.getBinding(entityName);
        if (entityClass == null || !dictionary.isRoot(entityClass)) {
            throw new InvalidCollectionException(entityName);
        }
        PersistentResource<?> record = PersistentResource.loadRecord(entityClass, id, state.getRequestScope());
        state.setState(new RecordState(record));
    }

    @Override
    public void handle(StateContext state, CoreParser.RootCollectionRelationshipContext ctx) {
        EntityDictionary dictionary = state.getRequestScope().getDictionary();
        String entityName = ctx.entity().term().getText();
        String id = ctx.entity().id().getText();
        Class<?> entityClass = dictionary.getBinding(entityName);
        if (entityClass == null || !dictionary.isRoot(entityClass)) {
            throw new InvalidCollectionException(entityName);
        }
        PersistentResource<?> record = PersistentResource.loadRecord(entityClass, id, state.getRequestScope());
        String relationName = ctx.relationship().term().getText();
        try {
            record.getRelation(relationName);
        }
        catch (InvalidAttributeException e) {
            throw new InvalidCollectionException(relationName);
        }
        state.setState(new RelationshipTerminalState(record, relationName));
    }

    public String toString() {
        return this.getClass().getName();
    }
}

