/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.audit.Logger;
import com.yahoo.elide.core.DataStore;
import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.SecurityMode;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.exceptions.InvalidURLException;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.extensions.JsonApiPatch;
import com.yahoo.elide.extensions.PatchRequestScope;
import com.yahoo.elide.generated.parsers.CoreLexer;
import com.yahoo.elide.generated.parsers.CoreParser;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.parsers.DeleteVisitor;
import com.yahoo.elide.parsers.GetVisitor;
import com.yahoo.elide.parsers.PatchVisitor;
import com.yahoo.elide.parsers.PostVisitor;
import com.yahoo.elide.security.User;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.function.Supplier;
import javax.ws.rs.core.MultivaluedMap;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.tuple.Pair;

public class Elide {
    private final Logger auditLogger;
    private final DataStore dataStore;
    private final EntityDictionary dictionary;
    private final JsonApiMapper mapper;

    public Elide(Logger auditLogger, DataStore dataStore, EntityDictionary dictionary) {
        this.auditLogger = auditLogger;
        this.dataStore = dataStore;
        this.dictionary = dictionary;
        dataStore.populateEntityDictionary(dictionary);
        this.mapper = new JsonApiMapper(dictionary);
    }

    public Elide(Logger auditLogger, DataStore dataStore) {
        this(auditLogger, dataStore, new EntityDictionary());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ElideResponse get(String path, MultivaluedMap<String, String> queryParams, Object opaqueUser, SecurityMode securityMode) {
        try (DataStoreTransaction transaction = this.dataStore.beginReadTransaction();){
            User user = transaction.accessUser(opaqueUser);
            RequestScope requestScope = new RequestScope(new JsonApiDocument(), transaction, user, this.dictionary, this.mapper, this.auditLogger, queryParams, securityMode);
            GetVisitor visitor = new GetVisitor(requestScope);
            Supplier responder = (Supplier)visitor.visit(Elide.parse(path));
            requestScope.runDeferredPermissionChecks();
            transaction.flush();
            ElideResponse response = this.buildResponse((Pair<Integer, JsonNode>)((Pair)responder.get()));
            this.auditLogger.commit();
            transaction.commit();
            requestScope.runCommitTriggers();
            ElideResponse elideResponse = response;
            return elideResponse;
        }
        catch (HttpStatusException e) {
            return this.buildErrorResponse(e, securityMode);
        }
        catch (IOException e) {
            return this.buildErrorResponse(new TransactionException(e), securityMode);
        }
        catch (ParseCancellationException e) {
            return this.buildErrorResponse(new InvalidURLException((Exception)((Object)e)), securityMode);
        }
    }

    public ElideResponse get(String path, MultivaluedMap<String, String> queryParams, Object opaqueUser) {
        return this.get(path, queryParams, opaqueUser, SecurityMode.SECURITY_ACTIVE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ElideResponse post(String path, String jsonApiDocument, Object opaqueUser, SecurityMode securityMode) {
        try (DataStoreTransaction transaction = this.dataStore.beginTransaction();){
            User user = transaction.accessUser(opaqueUser);
            JsonApiDocument doc = this.mapper.readJsonApiDocument(jsonApiDocument);
            RequestScope requestScope = new RequestScope(doc, transaction, user, this.dictionary, this.mapper, this.auditLogger, securityMode);
            PostVisitor visitor = new PostVisitor(requestScope);
            Supplier responder = (Supplier)visitor.visit(Elide.parse(path));
            requestScope.runDeferredPermissionChecks();
            transaction.flush();
            ElideResponse response = this.buildResponse((Pair<Integer, JsonNode>)((Pair)responder.get()));
            this.auditLogger.commit();
            transaction.commit();
            requestScope.runCommitTriggers();
            ElideResponse elideResponse = response;
            return elideResponse;
        }
        catch (HttpStatusException e) {
            return this.buildErrorResponse(e, securityMode);
        }
        catch (IOException e) {
            return this.buildErrorResponse(new TransactionException(e), securityMode);
        }
        catch (ParseCancellationException e) {
            return this.buildErrorResponse(new InvalidURLException((Exception)((Object)e)), securityMode);
        }
    }

    public ElideResponse post(String path, String jsonApiDocument, Object opaqueUser) {
        return this.post(path, jsonApiDocument, opaqueUser, SecurityMode.SECURITY_ACTIVE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ElideResponse patch(String contentType, String accept, String path, String jsonApiDocument, Object opaqueUser, SecurityMode securityMode) {
        try (DataStoreTransaction transaction = this.dataStore.beginTransaction();){
            Supplier responder;
            RequestScope requestScope;
            User user = transaction.accessUser(opaqueUser);
            if (JsonApiPatch.isPatchExtension(contentType) && JsonApiPatch.isPatchExtension(accept)) {
                PatchRequestScope patchRequestScope = new PatchRequestScope(transaction, user, this.dictionary, this.mapper, this.auditLogger);
                requestScope = patchRequestScope;
                responder = JsonApiPatch.processJsonPatch(this.dataStore, path, jsonApiDocument, patchRequestScope);
            } else {
                JsonApiDocument doc = this.mapper.readJsonApiDocument(jsonApiDocument);
                requestScope = new RequestScope(doc, transaction, user, this.dictionary, this.mapper, this.auditLogger, securityMode);
                PatchVisitor visitor = new PatchVisitor(requestScope);
                responder = (Supplier)visitor.visit(Elide.parse(path));
            }
            requestScope.runDeferredPermissionChecks();
            transaction.flush();
            ElideResponse response = this.buildResponse((Pair<Integer, JsonNode>)((Pair)responder.get()));
            this.auditLogger.commit();
            transaction.commit();
            requestScope.runCommitTriggers();
            ElideResponse elideResponse = response;
            return elideResponse;
        }
        catch (HttpStatusException e) {
            return this.buildErrorResponse(e, securityMode);
        }
        catch (ParseCancellationException e) {
            return this.buildErrorResponse(new InvalidURLException((Exception)((Object)e)), securityMode);
        }
        catch (IOException e) {
            return this.buildErrorResponse(new TransactionException(e), securityMode);
        }
    }

    public ElideResponse patch(String contentType, String accept, String path, String jsonApiDocument, Object opaqueUser) {
        return this.patch(contentType, accept, path, jsonApiDocument, opaqueUser, SecurityMode.SECURITY_ACTIVE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ElideResponse delete(String path, String jsonApiDocument, Object opaqueUser, SecurityMode securityMode) {
        try (DataStoreTransaction transaction = this.dataStore.beginTransaction();){
            User user = transaction.accessUser(opaqueUser);
            JsonApiDocument doc = jsonApiDocument != null && !jsonApiDocument.equals("") ? this.mapper.readJsonApiDocument(jsonApiDocument) : new JsonApiDocument();
            RequestScope requestScope = new RequestScope(doc, transaction, user, this.dictionary, this.mapper, this.auditLogger, securityMode);
            DeleteVisitor visitor = new DeleteVisitor(requestScope);
            Supplier responder = (Supplier)visitor.visit(Elide.parse(path));
            requestScope.runDeferredPermissionChecks();
            transaction.flush();
            ElideResponse response = this.buildResponse((Pair<Integer, JsonNode>)((Pair)responder.get()));
            this.auditLogger.commit();
            transaction.commit();
            requestScope.runCommitTriggers();
            ElideResponse elideResponse = response;
            return elideResponse;
        }
        catch (HttpStatusException e) {
            return this.buildErrorResponse(e, securityMode);
        }
        catch (IOException e) {
            return this.buildErrorResponse(new TransactionException(e), securityMode);
        }
        catch (ParseCancellationException e) {
            return this.buildErrorResponse(new InvalidURLException((Exception)((Object)e)), securityMode);
        }
    }

    public ElideResponse delete(String path, String jsonApiDocument, Object opaqueUser) {
        return this.delete(path, jsonApiDocument, opaqueUser, SecurityMode.SECURITY_ACTIVE);
    }

    public static ParseTree parse(String path) {
        if ((path = Paths.get(path, new String[0]).normalize().toString()).startsWith("/")) {
            path = path.substring(1);
        }
        ANTLRInputStream is = new ANTLRInputStream(path);
        CoreLexer lexer = new CoreLexer((CharStream)is);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new ParseCancellationException(msg, (Throwable)e);
            }
        });
        CoreParser parser = new CoreParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        return parser.start();
    }

    protected ElideResponse buildErrorResponse(HttpStatusException error, SecurityMode securityMode) {
        return this.buildResponse(securityMode == SecurityMode.SECURITY_ACTIVE_VERBOSE ? error.getVerboseErrorResponse() : error.getErrorResponse());
    }

    protected ElideResponse buildResponse(Pair<Integer, JsonNode> response) {
        try {
            JsonNode responseNode = (JsonNode)response.getRight();
            Integer responseCode = (Integer)response.getLeft();
            String body = this.mapper.writeJsonApiDocument(responseNode);
            return new ElideResponse(responseCode, body);
        }
        catch (JsonProcessingException e) {
            return new ElideResponse(500, e.toString());
        }
    }
}

