/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.audit;

import com.yahoo.elide.annotation.Audit;
import com.yahoo.elide.audit.InvalidSyntaxException;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.ResourceLineage;
import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.util.SimpleContext;
import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;

public class LogMessage {
    private static final ExpressionFactory EXPRESSION_FACTORY = new ExpressionFactoryImpl();
    private static final String CACHE_SIZE = "5000";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final String template;
    private final PersistentResource record;
    private final String[] expressions;
    private final int operationCode;

    public LogMessage(String template, int code) {
        this(template, null, EMPTY_STRING_ARRAY, code);
    }

    public LogMessage(Audit audit, PersistentResource record) throws InvalidSyntaxException {
        this(audit.logStatement(), record, audit.logExpressions(), audit.operation());
    }

    public LogMessage(String template, PersistentResource record, String[] expressions, int code) throws InvalidSyntaxException {
        this.template = template;
        this.record = record;
        this.expressions = expressions;
        this.operationCode = code;
    }

    public int getOperationCode() {
        return this.operationCode;
    }

    public String getMessage() {
        SimpleContext ctx = new SimpleContext();
        if (this.record != null) {
            ResourceLineage lineage = new ResourceLineage(this.record.getLineage(), this.record);
            for (String name : lineage.getKeys()) {
                ValueExpression expression;
                List<PersistentResource> values = lineage.getRecord(name);
                if (values.size() == 1) {
                    expression = EXPRESSION_FACTORY.createValueExpression(values.get(0).getObject(), Object.class);
                } else {
                    List objects = values.stream().map(PersistentResource::getObject).collect(Collectors.toList());
                    expression = EXPRESSION_FACTORY.createValueExpression(objects, List.class);
                }
                ctx.setVariable(name, expression);
            }
        }
        Object[] results = new Object[this.expressions.length];
        for (int idx = 0; idx < results.length; ++idx) {
            Object result;
            ValueExpression expression;
            String expressionText = this.expressions[idx];
            try {
                expression = EXPRESSION_FACTORY.createValueExpression((ELContext)ctx, expressionText, Object.class);
            }
            catch (ELException e) {
                throw new InvalidSyntaxException((Exception)((Object)e));
            }
            results[idx] = result = expression.getValue((ELContext)ctx);
        }
        try {
            return MessageFormat.format(this.template, results);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSyntaxException(e);
        }
    }

    public RequestScope getRequestScope() {
        if (this.record != null) {
            return this.record.getRequestScope();
        }
        return null;
    }

    public String toString() {
        return "LogMessage{message='" + this.getMessage() + '\'' + ", operationCode=" + this.getOperationCode() + '}';
    }

    static {
        Properties properties = new Properties();
        properties.put("javax.el.cacheSize", CACHE_SIZE);
    }
}

