/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.yahoo.elide.core.PersistentResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ResourceLineage {
    private final LinkedMap<String, List<PersistentResource>> resourceMap;

    public ResourceLineage() {
        this.resourceMap = new LinkedMap();
    }

    public ResourceLineage(ResourceLineage sharedLineage, PersistentResource next) {
        this.resourceMap = new LinkedMap(sharedLineage.resourceMap);
        this.addRecord(next);
    }

    public ResourceLineage(ResourceLineage sharedLineage, PersistentResource next, String nextAlias) {
        this.resourceMap = new LinkedMap(sharedLineage.resourceMap);
        this.addRecord(next, nextAlias);
    }

    public List<PersistentResource> getRecord(String name) {
        List list = (List)this.resourceMap.get((Object)name);
        return list == null ? Collections.emptyList() : list;
    }

    public List<String> getKeys() {
        return this.resourceMap.asList();
    }

    private void addRecord(PersistentResource latest) {
        this.addRecord(latest, latest.getType());
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 123).append(this.getKeys()).append((Object)this.resourceMap.asList()).toHashCode();
    }

    public boolean equals(Object input) {
        if (!(input instanceof ResourceLineage)) {
            return false;
        }
        ResourceLineage other = (ResourceLineage)input;
        if (other.getKeys().size() != this.getKeys().size()) {
            return false;
        }
        for (String key : other.getKeys()) {
            if (other.getRecord(key).equals(this.getRecord(key))) continue;
            return false;
        }
        return true;
    }

    private void addRecord(PersistentResource latest, String alias) {
        List<PersistentResource> resources;
        if (this.resourceMap.containsKey((Object)alias)) {
            resources = (List)this.resourceMap.get((Object)alias);
        } else {
            resources = new ArrayList();
            this.resourceMap.put((Object)alias, resources);
        }
        resources.add(latest);
    }
}

