/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.exceptions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpStatusException
extends RuntimeException {
    private static final Logger log = LoggerFactory.getLogger(HttpStatusException.class);
    private static final long serialVersionUID = 1L;
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String verboseMessage;

    public abstract int getStatus();

    public HttpStatusException() {
        this((String)null);
    }

    public HttpStatusException(String message) {
        this(message, (String)null);
    }

    public HttpStatusException(String message, String verboseMessage) {
        this(message, verboseMessage, null);
    }

    public HttpStatusException(String message, String verboseMessage, Throwable cause) {
        super(message, cause, true, log.isTraceEnabled());
        this.verboseMessage = verboseMessage;
    }

    protected static String formatExceptionCause(Throwable e) {
        Throwable error;
        Throwable throwable = error = e.getCause() == null ? e : e.getCause();
        return error == null ? null : (error.getMessage() == null ? error.toString() : error.getMessage());
    }

    public Pair<Integer, JsonNode> getErrorResponse() {
        Map<String, List<String>> errors = Collections.singletonMap("errors", Collections.singletonList(this.toString()));
        return this.buildResponse(errors);
    }

    public Pair<Integer, JsonNode> getVerboseErrorResponse() {
        Map<String, List<String>> errors = Collections.singletonMap("errors", Collections.singletonList(this.getVerboseMessage()));
        return this.buildResponse(errors);
    }

    private Pair<Integer, JsonNode> buildResponse(Map<String, List<String>> errors) {
        JsonNode responseBody = (JsonNode)OBJECT_MAPPER.convertValue(errors, JsonNode.class);
        return Pair.of((Object)this.getStatus(), (Object)responseBody);
    }

    public String getVerboseMessage() {
        return this.verboseMessage != null ? this.verboseMessage : this.toString();
    }

    @Override
    public String toString() {
        String message = this.getMessage();
        String className = this.getClass().getSimpleName();
        message = message == null ? className : className + ": " + message;
        return message;
    }
}

