/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter;

import com.yahoo.elide.core.exceptions.InvalidPredicateException;

public enum Operator {
    IN("in", true),
    NOT("not", true),
    PREFIX("prefix", true),
    POSTFIX("postfix", true),
    INFIX("infix", true),
    ISNULL("isnull", false),
    NOTNULL("notnull", false);

    private final String string;
    private final boolean parameterized;

    public static Operator fromString(String string) {
        for (Operator operator : Operator.values()) {
            if (!operator.getString().equals(string)) continue;
            return operator;
        }
        throw new InvalidPredicateException("Unknown operator in filter: " + string);
    }

    private Operator(String string2, boolean parameterized) {
        this.string = string2;
        this.parameterized = parameterized;
    }

    public String getString() {
        return this.string;
    }

    public boolean isParameterized() {
        return this.parameterized;
    }
}

