/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.yahoo.elide.core.EntityDictionary;
import java.io.IOException;
import java.util.Set;

public class JsonApiSerializer<T>
extends StdSerializer<T> {
    private final Class<T> type;

    JsonApiSerializer(Class<T> type, EntityDictionary dictionary) {
        super(type);
        this.type = type;
    }

    public static Module getModule(EntityDictionary dictionary) {
        SimpleModule jsonApiModule = new SimpleModule("JsonApiModule", new Version(1, 0, 0, null));
        jsonApiModule.addSerializer(new JsonApiSerializer<Set>(Set.class, dictionary));
        return jsonApiModule;
    }

    public void serialize(T object, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        if (object instanceof Set) {
            jsonGenerator.writeStartArray();
            for (Object value : (Set)object) {
                jsonGenerator.writeObject(value);
            }
            jsonGenerator.writeEndArray();
        } else {
            jsonGenerator.writeObject(object);
        }
    }

    public boolean usesObjectId() {
        return true;
    }

    public Class<T> handledType() {
        return this.type;
    }
}

