/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.parsers.state;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.InternalServerErrorException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.exceptions.InvalidObjectIdentifierException;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.document.processors.IncludedProcessor;
import com.yahoo.elide.jsonapi.document.processors.SortProcessor;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.models.Relationship;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.parsers.state.BaseState;
import com.yahoo.elide.parsers.state.StateContext;
import com.yahoo.elide.security.User;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.tuple.Pair;

public class CollectionTerminalState
extends BaseState {
    private final Optional<PersistentResource> parent;
    private final Optional<String> relationName;
    private final Class<?> entityClass;
    private PersistentResource newObject;

    public CollectionTerminalState(Class<?> entityClass, Optional<PersistentResource> parent, Optional<String> relationName) {
        this.parent = parent;
        this.relationName = relationName;
        this.entityClass = entityClass;
    }

    @Override
    public Supplier<Pair<Integer, JsonNode>> handleGet(StateContext state) {
        JsonApiDocument jsonApiDocument = new JsonApiDocument();
        RequestScope requestScope = state.getRequestScope();
        ObjectMapper mapper = requestScope.getMapper().getObjectMapper();
        Optional<MultivaluedMap<String, String>> queryParams = requestScope.getQueryParams();
        Set<PersistentResource> collection = this.getResourceCollection(requestScope);
        jsonApiDocument.setData(this.getData(requestScope, collection));
        IncludedProcessor includedProcessor = new IncludedProcessor();
        includedProcessor.execute(jsonApiDocument, collection, queryParams);
        SortProcessor sortProcessor = new SortProcessor();
        sortProcessor.execute(jsonApiDocument, collection, queryParams);
        JsonNode responseBody = (JsonNode)mapper.convertValue((Object)jsonApiDocument, JsonNode.class);
        return () -> Pair.of((Object)200, (Object)responseBody);
    }

    @Override
    public Supplier<Pair<Integer, JsonNode>> handlePost(StateContext state) {
        RequestScope requestScope = state.getRequestScope();
        JsonApiMapper mapper = requestScope.getMapper();
        this.newObject = this.createObject(requestScope);
        if (this.parent.isPresent()) {
            this.parent.get().addRelation(this.relationName.get(), this.newObject);
        }
        requestScope.getTransaction().save(this.newObject.getObject());
        return () -> {
            JsonApiDocument returnDoc = new JsonApiDocument();
            returnDoc.setData(new Data<Resource>(this.newObject.toResource()));
            JsonNode responseBody = (JsonNode)mapper.getObjectMapper().convertValue((Object)returnDoc, JsonNode.class);
            return Pair.of((Object)201, (Object)responseBody);
        };
    }

    private Set<PersistentResource> getResourceCollection(RequestScope requestScope) {
        Set<PersistentResource> collection = this.parent.isPresent() ? this.parent.get().getRelation(this.relationName.get()) : PersistentResource.loadRecords(this.entityClass, requestScope);
        return collection;
    }

    private Data getData(RequestScope requestScope, Set<PersistentResource> collection) {
        User user = requestScope.getUser();
        Preconditions.checkNotNull(collection);
        Preconditions.checkNotNull((Object)user);
        List resources = collection.stream().map(PersistentResource::toResource).collect(Collectors.toList());
        return new Data(resources);
    }

    private PersistentResource createObject(RequestScope requestScope) throws ForbiddenAccessException, InvalidObjectIdentifierException {
        Map<String, Relationship> relationships;
        Resource resource;
        JsonApiDocument doc = requestScope.getJsonApiDocument();
        JsonApiMapper mapper = requestScope.getMapper();
        Data<Resource> data = doc.getData();
        Collection<Resource> resources = data.get();
        Resource resource2 = resource = resources.size() == 1 ? resources.iterator().next() : null;
        if (resource == null) {
            try {
                throw new InvalidEntityBodyException(mapper.writeJsonApiDocument(doc));
            }
            catch (JsonProcessingException e) {
                throw new InternalServerErrorException((Exception)((Object)e));
            }
        }
        String id = resource.getId();
        PersistentResource<?> pResource = this.parent.isPresent() ? PersistentResource.createObject(this.parent.get(), this.entityClass, requestScope, id) : PersistentResource.createObject(this.entityClass, requestScope, id);
        this.assignId(pResource, id);
        Map<String, Object> attributes = resource.getAttributes();
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                String key = entry.getKey();
                Object val = entry.getValue();
                pResource.updateAttribute(key, val);
            }
        }
        if ((relationships = resource.getRelationships()) != null) {
            for (Map.Entry<String, Relationship> entry : relationships.entrySet()) {
                String fieldName = entry.getKey();
                Relationship relationship = entry.getValue();
                Set<PersistentResource> resourceSet = relationship == null ? null : relationship.toPersistentResources(requestScope);
                pResource.updateRelation(fieldName, resourceSet);
            }
        }
        return pResource;
    }

    private void assignId(PersistentResource persistentResource, String id) {
        if (!persistentResource.isIdGenerated().booleanValue()) {
            if (id != null && !id.isEmpty()) {
                persistentResource.setId(id);
            } else {
                throw new ForbiddenAccessException("No id provided, cannot persist " + persistentResource.getObject());
            }
        }
    }

    public String toString() {
        return "CollectionTerminalState(parent=" + this.parent + ", relationName=" + this.relationName + ", entityClass=" + this.entityClass + ", newObject=" + this.newObject + ")";
    }
}

