/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.security;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.security.Check;
import com.yahoo.elide.security.UserCheck;
import java.util.LinkedHashMap;
import java.util.Map;

public class User {
    private final Object opaqueUser;
    private final Map<Class<? extends Check>, UserCheck.UserPermission> okUserPermissions;
    private final Map<Class<? extends Check>, Map<PersistentResource, Boolean>> okCheckResources;

    public User(Object opaqueUser) {
        this.opaqueUser = opaqueUser;
        this.okUserPermissions = new LinkedHashMap<Class<? extends Check>, UserCheck.UserPermission>();
        this.okCheckResources = new LinkedHashMap<Class<? extends Check>, Map<PersistentResource, Boolean>>();
    }

    public UserCheck.UserPermission checkUserPermission(Check check) {
        if (check instanceof UserCheck) {
            UserCheck.UserPermission checkType = this.okUserPermissions.get(check.getClass());
            if (checkType == null) {
                checkType = ((UserCheck)check).userPermission(this);
                this.okUserPermissions.put(check.getClass(), checkType);
            }
            return checkType;
        }
        return UserCheck.UserPermission.FILTER;
    }

    public boolean ok(Check check, PersistentResource resource) {
        Map<Object, Object> okResourceMap;
        Preconditions.checkState((this == resource.getRequestScope().getUser() ? 1 : 0) != 0);
        switch (this.checkUserPermission(check)) {
            case ALLOW: {
                return true;
            }
            case DENY: {
                return false;
            }
        }
        if (this.okCheckResources.containsKey(check.getClass())) {
            okResourceMap = this.okCheckResources.get(check.getClass());
            if (okResourceMap.containsKey(resource)) {
                return (Boolean)okResourceMap.get(resource);
            }
        } else {
            okResourceMap = new LinkedHashMap();
            this.okCheckResources.put(check.getClass(), okResourceMap);
        }
        boolean ok = check.ok(resource);
        okResourceMap.put(resource, ok);
        return ok;
    }

    public Object getOpaqueUser() {
        return this.opaqueUser;
    }
}

