/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.utils.coerce;

import com.yahoo.elide.core.exceptions.InvalidAttributeException;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.utils.coerce.converters.FromMapConverter;
import com.yahoo.elide.utils.coerce.converters.ToEnumConverter;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;

public class CoerceUtil {
    private static final ToEnumConverter TO_ENUM_CONVERTER = new ToEnumConverter();
    private static final FromMapConverter FROM_MAP_CONVERTER = new FromMapConverter();

    public static Object coerce(Object value, Class<?> cls) {
        if (value == null || cls == null || cls.isAssignableFrom(value.getClass())) {
            return value;
        }
        try {
            return ConvertUtils.convert((Object)value, cls);
        }
        catch (InvalidAttributeException | IllegalArgumentException | ConversionException e) {
            throw new InvalidValueException(value);
        }
    }

    private static void setup() {
        BeanUtilsBean.setInstance((BeanUtilsBean)new BeanUtilsBean(new ConvertUtilsBean(){

            public Converter lookup(Class<?> sourceType, Class<?> targetType) {
                if (targetType.isEnum()) {
                    return TO_ENUM_CONVERTER;
                }
                if (Map.class.isAssignableFrom(sourceType)) {
                    return FROM_MAP_CONVERTER;
                }
                return super.lookup(sourceType, targetType);
            }
        }));
    }

    static {
        CoerceUtil.setup();
    }
}

