/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.yahoo.elide.annotation.ComputedAttribute;
import com.yahoo.elide.annotation.Exclude;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.annotation.SharePermission;
import com.yahoo.elide.core.EntityBinding;
import com.yahoo.elide.core.Initializer;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RelationshipType;
import com.yahoo.elide.core.exceptions.DuplicateMappingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDictionary {
    private static final Logger log = LoggerFactory.getLogger(EntityDictionary.class);
    protected final ConcurrentHashMap<String, Class<?>> bindJsonApiToEntity = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Class<?>, EntityBinding> entityBindings = new ConcurrentHashMap();
    protected final CopyOnWriteArrayList<Class<?>> bindEntityRoots = new CopyOnWriteArrayList();

    protected EntityBinding entityBinding(Class<?> entityClass) {
        EntityBinding entityBinding = this.entityBindings.get(this.lookupEntityClass(entityClass));
        return entityBinding == null ? EntityBinding.EMPTY_BINDING : entityBinding;
    }

    public Class<?> getBinding(String entityName) {
        return this.bindJsonApiToEntity.get(entityName);
    }

    public String getBinding(Class<?> entityClass) {
        return this.entityBinding(entityClass).jsonApi;
    }

    public String getIdFieldName(Class<?> entityClass) {
        return this.entityBinding(entityClass).getIdFieldName();
    }

    public Set<Class<?>> getBindings() {
        return this.entityBindings.keySet();
    }

    public List<String> getAttributes(Class<?> entityClass) {
        return this.entityBinding(entityClass).attrs;
    }

    public List<String> getAttributes(Object entity) {
        return this.getAttributes(entity.getClass());
    }

    public List<String> getRelationships(Class<?> entityClass) {
        return this.entityBinding(entityClass).relationships;
    }

    public List<String> getRelationships(Object entity) {
        return this.getRelationships(entity.getClass());
    }

    public RelationshipType getRelationshipType(Class<?> cls, String relation) {
        ConcurrentHashMap<String, RelationshipType> types = this.entityBinding(cls).relationshipTypes;
        if (types == null) {
            return RelationshipType.NONE;
        }
        RelationshipType type = types.get(relation);
        return type == null ? RelationshipType.NONE : type;
    }

    public String getRelationInverse(Class<?> cls, String relation) {
        String mapping;
        ConcurrentHashMap<String, String> mappings = this.entityBinding(cls).relationshipToInverse;
        if (mappings != null && (mapping = mappings.get(relation)) != null && !mapping.equals("")) {
            return mapping;
        }
        Class<?> inverseType = this.getParameterizedType(cls, relation);
        ConcurrentHashMap<String, String> inverseMappings = this.entityBinding(inverseType).relationshipToInverse;
        for (Map.Entry<String, String> inverseMapping : inverseMappings.entrySet()) {
            String inverseRelationName = inverseMapping.getKey();
            String inverseMappedBy = inverseMapping.getValue();
            if (!relation.equals(inverseMappedBy) || !this.getParameterizedType(inverseType, inverseRelationName).equals(this.lookupEntityClass(cls))) continue;
            return inverseRelationName;
        }
        return "";
    }

    public RelationshipType getRelationshipType(Object entity, String relation) {
        return this.getRelationshipType(entity.getClass(), relation);
    }

    public Class<?> getType(Class<?> entityClass, String identifier) {
        ConcurrentHashMap<String, Class<?>> fieldTypes = this.entityBinding(entityClass).fieldsToTypes;
        return fieldTypes == null ? null : fieldTypes.get(identifier);
    }

    public Class<?> getType(Object entity, String identifier) {
        return this.getType(entity.getClass(), identifier);
    }

    public Class<?> getParameterizedType(Class<?> entityClass, String identifier) {
        return this.getParameterizedType(entityClass, identifier, 0);
    }

    public Class<?> getParameterizedType(Class<?> entityClass, String identifier, int paramIndex) {
        ConcurrentHashMap<String, AccessibleObject> fieldOrMethods = this.entityBinding(entityClass).fieldsToValues;
        if (fieldOrMethods == null) {
            return null;
        }
        AccessibleObject fieldOrMethod = fieldOrMethods.get(identifier);
        if (fieldOrMethod == null) {
            return null;
        }
        Type type = fieldOrMethod instanceof Method ? ((Method)fieldOrMethod).getGenericReturnType() : ((Field)fieldOrMethod).getGenericType();
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[paramIndex];
        }
        return this.getType(entityClass, identifier);
    }

    public Class<?> getParameterizedType(Object entity, String identifier) {
        return this.getParameterizedType(entity.getClass(), identifier);
    }

    public Class<?> getParameterizedType(Object entity, String identifier, int paramIndex) {
        return this.getParameterizedType(entity.getClass(), identifier, paramIndex);
    }

    public String getNameFromAlias(Class<?> entityClass, String alias) {
        ConcurrentHashMap<String, String> map = this.entityBinding(entityClass).aliasesToFields;
        if (map != null) {
            return map.get(alias);
        }
        return null;
    }

    public String getNameFromAlias(Object entity, String alias) {
        return this.getNameFromAlias(entity.getClass(), alias);
    }

    public <T> void initializeEntity(T entity) {
        Initializer initializer;
        if (entity != null && (initializer = this.entityBinding(entity.getClass()).getInitializer()) != null) {
            initializer.initialize(entity);
        }
    }

    public <T> void bindInitializer(Initializer<T> initializer, Class<T> cls) {
        this.entityBinding(cls).setInitializer(initializer);
    }

    public boolean isShareable(Class<?> entityClass) {
        SharePermission share = (SharePermission)EntityDictionary.getFirstAnnotation(entityClass, Collections.singletonList(SharePermission.class));
        return share != null;
    }

    public void bindEntity(Class<?> cls) {
        Exclude exclude;
        Annotation annotation = EntityDictionary.getFirstAnnotation(cls, Arrays.asList(Include.class, Exclude.class));
        Include include = annotation instanceof Include ? (Include)annotation : null;
        Exclude exclude2 = exclude = annotation instanceof Exclude ? (Exclude)annotation : null;
        if (exclude != null) {
            log.trace("Exclude {}", (Object)cls.getName());
            return;
        }
        if (include == null) {
            log.trace("Missing include {}", (Object)cls.getName());
            return;
        }
        String type = "".equals(include.type()) ? WordUtils.uncapitalize((String)cls.getSimpleName()) : include.type();
        Class<?> duplicate = this.bindJsonApiToEntity.put(type, cls);
        if (duplicate != null && !duplicate.equals(cls)) {
            log.error("Duplicate binding {} for {}, {}", new Object[]{type, cls, duplicate});
            throw new DuplicateMappingException(type + " " + cls.getName() + ":" + duplicate.getName());
        }
        this.entityBindings.putIfAbsent(this.lookupEntityClass(cls), new EntityBinding(cls, type));
        if (include.rootLevel()) {
            this.bindEntityRoots.add(cls);
        }
    }

    public <A extends Annotation> A getAnnotation(PersistentResource record, Class<A> annotationClass) {
        return this.getAnnotation(record.getResourceClass(), annotationClass);
    }

    public <A extends Annotation> A getAnnotation(Class<?> recordClass, Class<A> annotationClass) {
        A annotation = null;
        for (Class<?> cls = recordClass; annotation == null && cls != null; cls = cls.getSuperclass()) {
            annotation = cls.getAnnotation(annotationClass);
        }
        Package pkg = recordClass.getPackage();
        while (annotation == null && pkg != null) {
            annotation = pkg.getAnnotation(annotationClass);
            pkg = EntityDictionary.getParentPackage(pkg);
        }
        return annotation;
    }

    public <A extends Annotation> Collection<Method> getTriggers(Class<?> cls, Class<A> annotationClass, String fieldName) {
        return this.entityBinding(cls).getTriggers(annotationClass, fieldName);
    }

    private static Package getParentPackage(Package pkg) {
        String name = pkg.getName();
        int idx = name.lastIndexOf(46);
        return idx == -1 ? null : Package.getPackage(name.substring(0, idx));
    }

    public <A extends Annotation> A getAttributeOrRelationAnnotation(Class<?> entityClass, Class<A> annotationClass, String identifier) {
        AccessibleObject fieldOrMethod = this.entityBinding(entityClass).fieldsToValues.get(identifier);
        if (fieldOrMethod == null) {
            return null;
        }
        return fieldOrMethod.getAnnotation(annotationClass);
    }

    public <A extends Annotation> A[] getAttributeOrRelationAnnotations(Class<?> entityClass, Class<A> annotationClass, String identifier) {
        AccessibleObject fieldOrMethod = this.entityBinding(entityClass).fieldsToValues.get(identifier);
        if (fieldOrMethod == null) {
            return null;
        }
        return fieldOrMethod.getAnnotationsByType(annotationClass);
    }

    public static Annotation getFirstAnnotation(Class<?> entityClass, List<Class<? extends Annotation>> annotationClassList) {
        Class<? extends Annotation> annotationClass;
        Iterator<Class<? extends Annotation>> iterator;
        Annotation annotation = null;
        for (Class<?> cls = entityClass; annotation == null && cls != null; cls = cls.getSuperclass()) {
            iterator = annotationClassList.iterator();
            while (iterator.hasNext() && (annotation = cls.getAnnotation(annotationClass = iterator.next())) == null) {
            }
        }
        Package pkg = entityClass.getPackage();
        while (annotation == null && pkg != null) {
            iterator = annotationClassList.iterator();
            while (iterator.hasNext() && (annotation = pkg.getAnnotation(annotationClass = iterator.next())) == null) {
            }
            pkg = EntityDictionary.getParentPackage(pkg);
        }
        return annotation;
    }

    public boolean isRoot(Class<?> entityClass) {
        return this.bindEntityRoots.contains(entityClass);
    }

    public String getId(Object value) {
        if (value == null) {
            return null;
        }
        try {
            AccessibleObject idField = null;
            for (Class<?> cls = value.getClass(); idField == null && cls != null; cls = cls.getSuperclass()) {
                idField = this.entityBinding(cls).getIdField();
            }
            if (idField instanceof Field) {
                return String.valueOf(((Field)idField).get(value));
            }
            if (idField instanceof Method) {
                return String.valueOf(((Method)idField).invoke(value, (Object[])null));
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return null;
        }
    }

    public Class<?> getIdType(Class<?> entityClass) {
        return this.entityBinding(entityClass).getIdType();
    }

    public Collection<Annotation> getIdAnnotations(Object value) {
        if (value == null) {
            return null;
        }
        AccessibleObject idField = this.entityBinding(value.getClass()).getIdField();
        if (idField != null) {
            return Arrays.asList(idField.getDeclaredAnnotations());
        }
        return Collections.emptyList();
    }

    public static Method findMethod(Class<?> entityClass, String name, Class<?> ... paramClass) throws NoSuchMethodException {
        Method m = entityClass.getMethod(name, paramClass);
        int modifiers = m.getModifiers();
        if (Modifier.isAbstract(modifiers) || m.isAnnotationPresent(Transient.class) && !m.isAnnotationPresent(ComputedAttribute.class)) {
            throw new NoSuchMethodException(name);
        }
        return m;
    }

    public Class<?> lookupEntityClass(Class<?> objClass) {
        for (Class<?> cls = objClass; cls != null; cls = cls.getSuperclass()) {
            if (!cls.isAnnotationPresent(Entity.class)) continue;
            return cls;
        }
        throw new IllegalArgumentException("Unknown Entity " + objClass);
    }

    public AccessibleObject getAccessibleObject(Object target, String fieldName) {
        Class<?> targetClass = this.lookupEntityClass(target.getClass());
        return this.getAccessibleObject(targetClass, fieldName);
    }

    public AccessibleObject getAccessibleObject(Class<?> targetClass, String fieldName) {
        ConcurrentHashMap<String, AccessibleObject> map = this.entityBinding(targetClass).accessibleObject;
        return map.get(fieldName);
    }
}

