/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.security.Check;
import com.yahoo.elide.security.UserCheck;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FilterScope<T> {
    private final RequestScope requestScope;
    private final boolean isAny;
    private final List<Check<T>> checks;
    private UserCheck.UserPermission filterUserPermission = null;

    public FilterScope(RequestScope requestScope) {
        this.requestScope = requestScope;
        this.isAny = false;
        this.checks = Collections.emptyList();
    }

    public FilterScope(RequestScope requestScope, boolean isAny, Class<? extends Check>[] checkClasses) {
        this.requestScope = requestScope;
        this.isAny = isAny;
        ArrayList<Check<T>> checks = new ArrayList<Check<T>>(checkClasses.length);
        for (Class<? extends Check> checkClass : checkClasses) {
            try {
                checks.add(checkClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                checks.add(null);
            }
        }
        this.checks = checks;
    }

    public boolean hasPredicates() {
        return !this.requestScope.getPredicates().isEmpty();
    }

    public UserCheck.UserPermission getUserPermission() {
        if (this.filterUserPermission != null) {
            return this.filterUserPermission;
        }
        UserCheck.UserPermission compositeUserPermission = null;
        for (Check<T> check : this.checks) {
            UserCheck.UserPermission checkUserPermission = this.requestScope.getUser().checkUserPermission(check);
            if (checkUserPermission == UserCheck.ALLOW && this.isAny) {
                compositeUserPermission = UserCheck.ALLOW;
                break;
            }
            if (checkUserPermission == UserCheck.DENY && !this.isAny) {
                compositeUserPermission = UserCheck.DENY;
                break;
            }
            if (checkUserPermission != UserCheck.FILTER) continue;
            compositeUserPermission = UserCheck.FILTER;
        }
        if (compositeUserPermission == null) {
            compositeUserPermission = this.isAny ? UserCheck.DENY : UserCheck.ALLOW;
        }
        this.filterUserPermission = compositeUserPermission;
        return this.filterUserPermission;
    }

    public RequestScope getRequestScope() {
        return this.requestScope;
    }

    public boolean isAny() {
        return this.isAny;
    }

    public List<Check<T>> getChecks() {
        return this.checks;
    }
}

