/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.yahoo.elide.annotation.Audit;
import com.yahoo.elide.annotation.CreatePermission;
import com.yahoo.elide.annotation.DeletePermission;
import com.yahoo.elide.annotation.OnCreate;
import com.yahoo.elide.annotation.OnDelete;
import com.yahoo.elide.annotation.OnUpdate;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.annotation.SharePermission;
import com.yahoo.elide.annotation.UpdatePermission;
import com.yahoo.elide.audit.InvalidSyntaxException;
import com.yahoo.elide.audit.LogMessage;
import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.FilterScope;
import com.yahoo.elide.core.ObjectEntityCache;
import com.yahoo.elide.core.PersistentResourceSet;
import com.yahoo.elide.core.RelationshipType;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.ResourceLineage;
import com.yahoo.elide.core.SecurityMode;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.InternalServerErrorException;
import com.yahoo.elide.core.exceptions.InvalidAttributeException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.exceptions.InvalidObjectIdentifierException;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.filter.Predicate;
import com.yahoo.elide.extensions.PatchRequestScope;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.Relationship;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.jsonapi.models.ResourceIdentifier;
import com.yahoo.elide.jsonapi.models.SingleElementSet;
import com.yahoo.elide.security.Check;
import com.yahoo.elide.security.User;
import com.yahoo.elide.security.UserCheck;
import com.yahoo.elide.utils.coerce.CoerceUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.GeneratedValue;
import lombok.NonNull;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentResource<T> {
    private static final Logger log = LoggerFactory.getLogger(PersistentResource.class);
    private final String type;
    protected T obj;
    private final ResourceLineage lineage;
    private final Optional<String> uuid;
    private final User user;
    private final ObjectEntityCache entityCache;
    private final DataStoreTransaction transaction;
    @NonNull
    private final RequestScope requestScope;
    private final Optional<PersistentResource<?>> parent;
    protected final EntityDictionary dictionary;
    private final Comparator<String> comparator = (string1, string2) -> {
        int diff = string1.length() - string2.length();
        return diff == 0 ? string1.compareTo((String)string2) : diff;
    };
    protected static final boolean ANY = true;
    protected static final boolean ALL = false;

    public static <T> PersistentResource<T> createObject(PersistentResource<?> parent, Class<T> entityClass, RequestScope requestScope, String uuid) {
        DataStoreTransaction tx = requestScope.getTransaction();
        T obj = tx.createObject(entityClass);
        PersistentResource newResource = new PersistentResource(obj, parent, uuid, requestScope);
        PersistentResource.checkPermission(CreatePermission.class, newResource);
        newResource.audit(Audit.Action.CREATE);
        newResource.runTriggers(OnCreate.class);
        requestScope.queueCommitTrigger(newResource);
        String type = newResource.getType();
        requestScope.getObjectEntityCache().put(type, uuid, newResource.getObject());
        requestScope.getDictionary().getRelationships(entityClass).stream().filter(relationName -> {
            if (!newResource.getRelationshipType((String)relationName).isToMany()) return false;
            if (PersistentResource.getValue(newResource.getObject(), relationName, persistentResource.dictionary) != null) return false;
            return true;
        }).forEach(relationName -> newResource.setValue((String)relationName, new LinkedHashSet()));
        requestScope.getNewResources().add(newResource);
        return newResource;
    }

    public static <T> PersistentResource<T> createObject(Class<T> entityClass, RequestScope requestScope, String uuid) {
        return PersistentResource.createObject(null, entityClass, requestScope, uuid);
    }

    public PersistentResource(PersistentResource<?> parent, T obj, RequestScope requestScope) {
        this(obj, parent, requestScope);
    }

    public PersistentResource(T obj, RequestScope requestScope) {
        this(obj, null, requestScope);
    }

    protected PersistentResource(@NonNull T obj, PersistentResource<?> parent, String id, RequestScope requestScope) {
        if (obj == null) {
            throw new NullPointerException("obj");
        }
        this.obj = obj;
        this.uuid = Optional.ofNullable(id);
        this.parent = Optional.ofNullable(parent);
        this.lineage = this.parent.isPresent() ? new ResourceLineage(parent.lineage, parent) : new ResourceLineage();
        this.dictionary = requestScope.getDictionary();
        this.type = this.dictionary.getBinding(obj.getClass());
        this.user = requestScope.getUser();
        this.entityCache = requestScope.getObjectEntityCache();
        this.transaction = requestScope.getTransaction();
        this.requestScope = requestScope;
        this.dictionary.initializeEntity(obj);
    }

    protected PersistentResource(T obj, PersistentResource<?> parent, RequestScope requestScope) {
        this(obj, parent, requestScope.getObjectEntityCache().getUUID(obj), requestScope);
    }

    public boolean matchesId(String checkId) {
        if (checkId == null) {
            return false;
        }
        if (this.uuid.isPresent() && checkId.equals(this.uuid.get())) {
            return true;
        }
        String id = this.getId();
        return checkId.equals(id);
    }

    @NonNull
    public static <T> PersistentResource<T> loadRecord(Class<T> loadClass, String id, RequestScope requestScope) throws InvalidObjectIdentifierException {
        Class<?> idType;
        Preconditions.checkNotNull(loadClass);
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)requestScope);
        DataStoreTransaction tx = requestScope.getTransaction();
        EntityDictionary dictionary = requestScope.getDictionary();
        ObjectEntityCache cache = requestScope.getObjectEntityCache();
        Object obj = cache.get(dictionary.getBinding(loadClass), id);
        if (obj == null && (obj = tx.loadObject(loadClass, (Serializable)CoerceUtil.coerce(id, idType = dictionary.getIdType(loadClass)))) == null) {
            throw new InvalidObjectIdentifierException(id, loadClass.getSimpleName());
        }
        PersistentResource<Object> resource = new PersistentResource<Object>(obj, requestScope);
        super.checkFieldAwarePermissions(ReadPermission.class);
        requestScope.queueCommitTrigger(resource);
        return resource;
    }

    @NonNull
    public static <T> Set<PersistentResource<T>> loadRecords(Class<T> loadClass, RequestScope requestScope) {
        DataStoreTransaction tx = requestScope.getTransaction();
        if (PersistentResource.isDenyFilter(requestScope, loadClass)) {
            return Collections.emptySet();
        }
        ReadPermission annotation = requestScope.getDictionary().getAnnotation(loadClass, ReadPermission.class);
        FilterScope filterScope = PersistentResource.loadChecks(annotation, requestScope);
        Iterable<T> list = tx.loadObjects(loadClass, filterScope);
        Set<PersistentResource<T>> resources = new PersistentResourceSet<T>(list, requestScope);
        resources = PersistentResource.filter(ReadPermission.class, resources);
        for (PersistentResource<T> resource : resources) {
            requestScope.queueCommitTrigger(resource);
        }
        return resources;
    }

    public boolean updateAttribute(String fieldName, Object newVal) {
        this.checkFieldAwarePermissions(UpdatePermission.class, fieldName);
        Object val = this.getAttribute(fieldName);
        if (!(val == newVal || val != null && val.equals(newVal))) {
            this.setValueChecked(fieldName, newVal);
            this.transaction.save(this.obj);
            this.audit(fieldName);
            return true;
        }
        return false;
    }

    public boolean updateRelation(String fieldName, Set<PersistentResource> resourceIdentifiers) {
        this.checkFieldAwarePermissions(UpdatePermission.class, fieldName);
        RelationshipType type = this.getRelationshipType(fieldName);
        if (type.isToMany()) {
            return this.updateToManyRelation(fieldName, resourceIdentifiers);
        }
        return this.updateToOneRelation(fieldName, resourceIdentifiers);
    }

    protected boolean updateToManyRelation(String fieldName, Set<PersistentResource> resourceIdentifiers) {
        Set<PersistentResource> mine = this.getRelation(fieldName);
        if (resourceIdentifiers == null) {
            throw new InvalidEntityBodyException("Bad relation data");
        }
        Set<PersistentResource> requested = resourceIdentifiers.isEmpty() ? new LinkedHashSet<PersistentResource>() : resourceIdentifiers;
        Sets.SetView deleted = Sets.difference(mine, requested);
        Sets.SetView updated = Sets.difference((Set)Sets.union(mine, requested), (Set)Sets.intersection(mine, requested));
        Sets.SetView added = Sets.difference((Set)updated, (Set)deleted);
        this.checkSharePermission((Set<PersistentResource>)added);
        Collection collection = (Collection)this.getValue(fieldName);
        if (collection == null) {
            this.setValue(fieldName, mine);
        }
        deleted.stream().forEach(toDelete -> {
            this.checkFieldAwarePermissions(UpdatePermission.class, fieldName);
            this.delFromCollection(collection, fieldName, (PersistentResource)toDelete);
            this.deleteInverseRelation(fieldName, toDelete.getObject());
            this.transaction.save(toDelete.getObject());
        });
        added.stream().forEach(toAdd -> {
            this.addToCollection(collection, fieldName, (PersistentResource)toAdd);
            this.addInverseRelation(fieldName, toAdd.getObject());
            this.transaction.save(toAdd.getObject());
        });
        this.transaction.save(this.getObject());
        this.audit(fieldName);
        return !updated.isEmpty();
    }

    protected boolean updateToOneRelation(String fieldName, Set<PersistentResource> resourceIdentifiers) {
        PersistentResource oldResource;
        Object newValue;
        Set<PersistentResource> mine = this.getRelation(fieldName);
        if (resourceIdentifiers == null || resourceIdentifiers.isEmpty()) {
            newValue = null;
        } else {
            PersistentResource newResource = resourceIdentifiers.iterator().next();
            newValue = newResource.getObject();
        }
        PersistentResource persistentResource = oldResource = !mine.isEmpty() ? mine.iterator().next() : null;
        if (oldResource == null) {
            if (newValue == null) {
                return false;
            }
            this.checkSharePermission(resourceIdentifiers);
        } else {
            if (oldResource.getObject().equals(newValue)) {
                return false;
            }
            this.checkSharePermission(resourceIdentifiers);
            this.deleteInverseRelation(fieldName, oldResource.getObject());
            this.transaction.save(oldResource.getObject());
        }
        if (newValue != null) {
            this.addInverseRelation(fieldName, newValue);
            this.transaction.save(newValue);
        }
        this.setValueChecked(fieldName, newValue);
        this.transaction.save(this.obj);
        this.audit(fieldName);
        return true;
    }

    public boolean clearRelation(String relationName) {
        this.checkFieldAwarePermissions(UpdatePermission.class, relationName);
        Set<PersistentResource> mine = this.getRelation(relationName);
        if (mine.isEmpty()) {
            return false;
        }
        RelationshipType type = this.getRelationshipType(relationName);
        mine.stream().forEach(toDelete -> this.deleteInverseRelation(relationName, toDelete.getObject()));
        if (type.isToOne()) {
            PersistentResource oldValue = mine.iterator().next();
            this.nullValue(relationName, oldValue);
            this.transaction.save(oldValue.getObject());
        } else {
            Collection collection = (Collection)this.getValue(relationName);
            mine.stream().forEach(toDelete -> {
                String inverseRelation = this.getInverseRelationField(relationName);
                this.checkFieldAwarePermissions(UpdatePermission.class, relationName);
                toDelete.checkFieldAwarePermissions(UpdatePermission.class, inverseRelation);
                this.delFromCollection(collection, relationName, (PersistentResource)toDelete);
                this.transaction.save(toDelete.getObject());
            });
        }
        this.transaction.save(this.obj);
        this.audit(relationName);
        return true;
    }

    public void removeRelation(String fieldName, PersistentResource removeResource) {
        Object relation;
        this.checkFieldAwarePermissions(UpdatePermission.class, fieldName);
        String inverseField = this.getInverseRelationField(fieldName);
        if (inverseField.length() > 0) {
            removeResource.checkFieldAwarePermissions(UpdatePermission.class, inverseField);
        }
        if ((relation = this.getValue(fieldName)) instanceof Collection) {
            if (!((Collection)relation).contains(removeResource.getObject())) {
                return;
            }
            this.delFromCollection((Collection)relation, fieldName, removeResource);
        } else {
            Object oldValue = this.getValue(fieldName);
            if (oldValue == null || !oldValue.equals(removeResource.getObject())) {
                return;
            }
            this.nullValue(fieldName, removeResource);
        }
        this.deleteInverseRelation(fieldName, removeResource.getObject());
        this.transaction.save(removeResource.getObject());
        this.transaction.save(this.obj);
        this.audit(fieldName);
    }

    public void addRelation(String fieldName, PersistentResource newRelation) {
        this.checkFieldAwarePermissions(UpdatePermission.class, fieldName);
        this.checkSharePermission(Collections.singleton(newRelation));
        Object relation = this.getValue(fieldName);
        if (!(relation instanceof Collection)) {
            this.updateRelation(fieldName, Collections.singleton(newRelation));
            return;
        }
        this.addToCollection((Collection)relation, fieldName, newRelation);
        this.addInverseRelation(fieldName, newRelation.getObject());
        this.transaction.save(newRelation.getObject());
        this.transaction.save(this.obj);
        this.audit(fieldName);
    }

    protected void checkSharePermission(Set<PersistentResource> resourceIdentifiers) {
        if (resourceIdentifiers == null) {
            return;
        }
        Set<PersistentResource> newResources = this.getRequestScope().getNewResources();
        for (PersistentResource persistentResource : resourceIdentifiers) {
            if (newResources.contains(persistentResource)) continue;
            if (persistentResource.isShareable()) {
                PersistentResource.checkPermission(SharePermission.class, persistentResource);
                continue;
            }
            if (this.lineage.getRecord(persistentResource.getType()).contains(persistentResource)) continue;
            this.requestScope.logAuthFailure(Arrays.asList(new Class[0]), persistentResource.getType(), persistentResource.getId());
            throw new ForbiddenAccessException("Resource Not Shareable");
        }
    }

    private boolean isShareable() {
        return this.getRequestScope().getDictionary().isShareable(this.obj.getClass());
    }

    public void deleteResource() throws ForbiddenAccessException {
        PersistentResource.checkPermission(DeletePermission.class, this);
        Map<String, Relationship> relations = this.getRelationships();
        for (Map.Entry<String, Relationship> entry : relations.entrySet()) {
            String relationName = entry.getKey();
            String inverseRelationName = this.dictionary.getRelationInverse(this.getResourceClass(), relationName);
            if (inverseRelationName.equals("")) continue;
            for (PersistentResource inverseResource : this.getRelation(relationName)) {
                this.deleteInverseRelation(relationName, inverseResource.getObject());
                this.transaction.save(inverseResource.getObject());
            }
        }
        this.transaction.delete(this.getObject());
        this.audit(Audit.Action.DELETE);
        this.runTriggers(OnDelete.class);
    }

    public String getId() {
        return this.dictionary.getId(this.getObject());
    }

    public void setId(String id) {
        this.setValue(this.dictionary.getIdFieldName(this.getResourceClass()), id);
    }

    public Boolean isIdGenerated() {
        return this.getIdAnnotations().stream().anyMatch(a -> a.annotationType().equals(GeneratedValue.class));
    }

    private Collection<Annotation> getIdAnnotations() {
        return this.dictionary.getIdAnnotations(this.getObject());
    }

    public Optional<String> getUUID() {
        return this.uuid;
    }

    public PersistentResource getRelation(String relation, String id) {
        Set<Predicate> filters;
        if (this.requestScope instanceof PatchRequestScope) {
            filters = Collections.emptySet();
        } else {
            Class<?> entityType = this.dictionary.getParameterizedType(this.getResourceClass(), relation);
            if (entityType == null) {
                throw new InvalidAttributeException(relation, this.type);
            }
            Object idVal = CoerceUtil.coerce(id, this.dictionary.getIdType(entityType));
            String idField = this.dictionary.getIdFieldName(entityType);
            Predicate idFilter = new Predicate(idField, Operator.IN, Collections.singletonList(idVal));
            filters = Collections.singleton(idFilter);
        }
        Set<PersistentResource> resources = this.getRelation(relation, filters);
        for (PersistentResource childResource : resources) {
            if (!childResource.matchesId(id)) continue;
            return childResource;
        }
        throw new InvalidObjectIdentifierException(id, relation);
    }

    public Set<PersistentResource> getRelation(String relationName) {
        if (this.requestScope.getTransaction() != null && !this.requestScope.getPredicates().isEmpty()) {
            Class<?> entityClass = this.dictionary.getParameterizedType(this.obj, relationName);
            String valType = this.dictionary.getBinding(entityClass);
            HashSet<Predicate> filters = new HashSet<Predicate>(this.requestScope.getPredicatesOfType(valType));
            return this.getRelation(relationName, filters);
        }
        return this.getRelation(relationName, Collections.emptySet());
    }

    protected Set<PersistentResource> getRelation(String relationName, Set<Predicate> filters) {
        List<String> relations = this.dictionary.getRelationships(this.obj);
        String realName = this.dictionary.getNameFromAlias(this.obj, relationName);
        String string = relationName = realName == null ? relationName : realName;
        if (relationName == null || relations == null || !relations.contains(relationName)) {
            throw new InvalidAttributeException(relationName, this.type);
        }
        AbstractSet resources = Sets.newLinkedHashSet();
        if (PersistentResource.isDenyFilter(this.requestScope, this.dictionary.getParameterizedType(this.obj, relationName))) {
            this.checkFieldAwarePermissions(ReadPermission.class, relationName);
            return resources;
        }
        RelationshipType type = this.getRelationshipType(relationName);
        Object val = this.getValue(relationName);
        if (val == null) {
            return resources;
        }
        if (val instanceof Collection) {
            Collection filteredVal = (Collection)val;
            if (!filters.isEmpty()) {
                Class<?> entityClass = this.dictionary.getParameterizedType(this.obj, relationName);
                filteredVal = this.requestScope.getTransaction().filterCollection(filteredVal, entityClass, filters);
            }
            resources = new PersistentResourceSet(filteredVal, this.requestScope);
        } else if (type.isToOne()) {
            resources = new SingleElementSet<PersistentResource<Object>>(new PersistentResource<Object>(this, val, this.getRequestScope()));
        } else {
            resources.add(new PersistentResource<Object>(this, val, this.getRequestScope()));
        }
        return PersistentResource.filter(ReadPermission.class, resources);
    }

    private static boolean isDenyFilter(RequestScope requestScope, Class<?> recordClass) {
        if (requestScope.getSecurityMode() == SecurityMode.SECURITY_INACTIVE) {
            return false;
        }
        EntityDictionary dictionary = requestScope.getDictionary();
        ReadPermission annotation = dictionary.getAnnotation(recordClass, ReadPermission.class);
        FilterScope filterScope = PersistentResource.loadChecks(annotation, requestScope);
        if (filterScope.getUserPermission() != UserCheck.DENY) {
            return false;
        }
        ArrayList<String> fields = new ArrayList<String>();
        fields.addAll(dictionary.getAttributes(recordClass));
        fields.addAll(dictionary.getRelationships(recordClass));
        for (String field : fields) {
            FilterScope fieldFilterScope;
            ReadPermission fieldAnnotation = dictionary.getAttributeOrRelationAnnotation(recordClass, ReadPermission.class, field);
            if (fieldAnnotation == null || (fieldFilterScope = PersistentResource.loadChecks(fieldAnnotation, requestScope)).getUserPermission() == UserCheck.DENY) continue;
            return false;
        }
        return true;
    }

    public RelationshipType getRelationshipType(String relation) {
        return this.dictionary.getRelationshipType(this.obj, relation);
    }

    public Object getAttribute(String attr) {
        return this.getValue(attr);
    }

    public T getObject() {
        return this.obj;
    }

    public void setObject(T obj) {
        this.obj = obj;
    }

    @JsonIgnore
    public Class<T> getResourceClass() {
        return this.dictionary.lookupEntityClass(this.obj.getClass());
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        String id = this.dictionary.getId(this.getObject());
        result = 31 * result + (this.uuid.isPresent() ? this.uuid.hashCode() : 0);
        result = 31 * result + (id == null ? 0 : id.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PersistentResource) {
            PersistentResource that = (PersistentResource)obj;
            String theirId = this.dictionary.getId(that.getObject());
            return this.matchesId(theirId) && Objects.equals(this.type, that.type);
        }
        return false;
    }

    public ResourceLineage getLineage() {
        return this.lineage;
    }

    public EntityDictionary getDictionary() {
        return this.dictionary;
    }

    public RequestScope getRequestScope() {
        return this.requestScope;
    }

    public Resource toResource() {
        Resource resource = new Resource(this.type, this.obj == null ? this.uuid.orElseThrow(() -> new InvalidEntityBodyException("No id found on object")) : this.dictionary.getId(this.obj));
        resource.setRelationships(this.getRelationships());
        resource.setAttributes(this.getAttributes());
        return resource;
    }

    protected Map<String, Relationship> getRelationships() {
        LinkedHashMap<String, Relationship> relationshipMap = new LinkedHashMap<String, Relationship>();
        Set<String> relationshipFields = PersistentResource.filterFields(ReadPermission.class, this, this.dictionary.getRelationships(this.obj));
        for (String field : relationshipFields) {
            Set<PersistentResource> relationships = this.getRelation(field);
            TreeMap<String, Resource> orderedById = new TreeMap<String, Resource>(this.comparator);
            for (PersistentResource relationship : relationships) {
                orderedById.put(relationship.getId(), new ResourceIdentifier(relationship.getType(), relationship.getId()).castToResource());
            }
            Collection resources = orderedById.values();
            RelationshipType relationshipType = this.getRelationshipType(field);
            Data<Resource> data = relationshipType.isToOne() ? (resources.isEmpty() ? new Data<Resource>((Resource)null) : new Data(resources.iterator().next())) : new Data(resources);
            relationshipMap.put(field, new Relationship(null, data));
        }
        return relationshipMap;
    }

    protected Map<String, Object> getAttributes() {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        Set<String> attrFields = PersistentResource.filterFields(ReadPermission.class, this, this.dictionary.getAttributes(this.obj));
        for (String field : attrFields) {
            Object val = this.getAttribute(field);
            attributes.put(field, val);
        }
        return attributes;
    }

    protected void setValueChecked(String fieldName, Object newValue) {
        this.checkFieldAwarePermissions(UpdatePermission.class, fieldName);
        this.setValue(fieldName, newValue);
    }

    protected void nullValue(String fieldName, PersistentResource oldValue) {
        if (oldValue == null) {
            return;
        }
        String inverseField = this.getInverseRelationField(fieldName);
        if (inverseField.length() > 0) {
            oldValue.checkFieldAwarePermissions(UpdatePermission.class, inverseField);
        }
        this.setValueChecked(fieldName, null);
    }

    protected Object getValue(String fieldName) {
        this.checkFieldAwarePermissions(ReadPermission.class, fieldName);
        return PersistentResource.getValue(this.getObject(), fieldName, this.dictionary);
    }

    protected void addToCollection(Collection collection, String collectionName, PersistentResource toAdd) {
        this.checkFieldAwarePermissions(UpdatePermission.class, collectionName);
        toAdd.checkFieldAwarePermissions(ReadPermission.class, collectionName);
        if (collection == null) {
            collection = Collections.singleton(toAdd.getObject());
            this.setValueChecked(collectionName, collection);
        }
        collection.add(toAdd.getObject());
    }

    protected void delFromCollection(Collection collection, String collectionName, PersistentResource toDelete) {
        if (collection == null) {
            return;
        }
        collection.remove(toDelete.getObject());
    }

    protected void setValue(String fieldName, Object value) {
        Class<?> targetClass = this.obj.getClass();
        try {
            Class<?> fieldClass = this.dictionary.getType(targetClass, fieldName);
            String realName = this.dictionary.getNameFromAlias(this.obj, fieldName);
            fieldName = realName != null ? realName : fieldName;
            String setMethod = "set" + WordUtils.capitalize((String)fieldName);
            Method method = EntityDictionary.findMethod(targetClass, setMethod, fieldClass);
            method.invoke(this.obj, this.coerce(value, fieldName, fieldClass));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InvalidAttributeException(fieldName, this.type);
        }
        catch (IllegalArgumentException | NoSuchMethodException noMethod) {
            try {
                Field field = targetClass.getField(fieldName);
                field.set(this.obj, this.coerce(value, fieldName, field.getType()));
            }
            catch (IllegalAccessException | NoSuchFieldException noField) {
                throw new InvalidAttributeException(fieldName, this.type);
            }
        }
        this.runTriggers(OnUpdate.class, fieldName);
        this.requestScope.queueCommitTrigger(this, fieldName);
    }

    <A extends Annotation> void runTriggers(Class<A> annotationClass) {
        this.runTriggers(annotationClass, "");
    }

    <A extends Annotation> void runTriggers(Class<A> annotationClass, String fieldName) {
        Class<?> targetClass = this.obj.getClass();
        Collection<Method> methods = this.dictionary.getTriggers(targetClass, annotationClass, fieldName);
        for (Method method : methods) {
            try {
                method.invoke(this.obj, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private Object coerce(Object value, String fieldName, Class<?> fieldClass) {
        if (fieldClass != null && Collection.class.isAssignableFrom(fieldClass) && value instanceof Collection) {
            return this.coerceCollection((Collection)value, fieldName, fieldClass);
        }
        if (fieldClass != null && Map.class.isAssignableFrom(fieldClass) && value instanceof Map) {
            return this.coerceMap((Map)value, fieldName, fieldClass);
        }
        return CoerceUtil.coerce(value, fieldClass);
    }

    private Collection coerceCollection(Collection<?> values, String fieldName, Class<?> fieldClass) {
        Class<?> providedType = this.dictionary.getParameterizedType(this.obj, fieldName);
        if (fieldClass.isAssignableFrom(values.getClass())) {
            boolean valid = true;
            for (Object member : values) {
                if (member == null || providedType.isAssignableFrom(member.getClass())) continue;
                valid = false;
                break;
            }
            if (valid) {
                return values;
            }
        }
        ArrayList<Object> list = new ArrayList<Object>(values.size());
        for (Object member : values) {
            list.add(CoerceUtil.coerce(member, providedType));
        }
        if (Set.class.isAssignableFrom(fieldClass)) {
            return new LinkedHashSet(list);
        }
        return list;
    }

    private Map coerceMap(Map<?, ?> values, String fieldName, Class<?> fieldClass) {
        Class<?> valueType;
        Class<?> keyType = this.dictionary.getParameterizedType(this.obj, fieldName, 0);
        if (this.isValidParameterizedMap(values, keyType, valueType = this.dictionary.getParameterizedType(this.obj, fieldName, 1))) {
            return values;
        }
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(values.size());
        for (Map.Entry<?, ?> entry : values.entrySet()) {
            result.put(CoerceUtil.coerce(entry.getKey(), keyType), CoerceUtil.coerce(entry.getValue(), valueType));
        }
        return result;
    }

    private boolean isValidParameterizedMap(Map<?, ?> values, Class<?> keyType, Class<?> valueType) {
        for (Map.Entry<?, ?> entry : values.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if ((key == null || keyType.isAssignableFrom(key.getClass())) && (value == null || valueType.isAssignableFrom(value.getClass()))) continue;
            return false;
        }
        return true;
    }

    public static Object getValue(Object target, String fieldName, EntityDictionary dictionary) {
        AccessibleObject accessor = dictionary.getAccessibleObject(target, fieldName);
        try {
            if (accessor instanceof Method) {
                return ((Method)accessor).invoke(target, new Object[0]);
            }
            if (accessor instanceof Field) {
                return ((Field)accessor).get(target);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InvalidAttributeException(fieldName, dictionary.getBinding(target.getClass()));
        }
        throw new InvalidAttributeException(fieldName, dictionary.getBinding(target.getClass()));
    }

    protected void deleteInverseRelation(String relationName, Object inverseEntity) {
        String inverseRelationName = this.getInverseRelationField(relationName);
        if (!inverseRelationName.equals("")) {
            Class<?> inverseRelationType = this.dictionary.getType(inverseEntity.getClass(), inverseRelationName);
            PersistentResource<Object> inverseResource = new PersistentResource<Object>(this, inverseEntity, this.getRequestScope());
            Object inverseRelation = inverseResource.getValue(inverseRelationName);
            if (inverseRelation == null) {
                return;
            }
            if (inverseRelation instanceof Collection) {
                super.checkFieldAwarePermissions(UpdatePermission.class, inverseRelationName);
                inverseResource.delFromCollection((Collection)inverseRelation, inverseRelationName, this);
            } else if (inverseRelationType.equals(this.getResourceClass())) {
                inverseResource.nullValue(inverseRelationName, this);
            } else {
                throw new InternalServerErrorException("Relationship type mismatch");
            }
        }
    }

    private String getInverseRelationField(String relationName) {
        Class<?> entityClass = this.dictionary.lookupEntityClass(this.obj.getClass());
        return this.dictionary.getRelationInverse(entityClass, relationName);
    }

    protected void addInverseRelation(String relationName, Object relationValue) {
        Class<?> entityClass = this.dictionary.lookupEntityClass(this.obj.getClass());
        Object inverseEntity = relationValue;
        String inverseRelationName = this.dictionary.getRelationInverse(entityClass, relationName);
        if (!inverseRelationName.equals("")) {
            Class<?> inverseRelationType = this.dictionary.getType(inverseEntity.getClass(), inverseRelationName);
            PersistentResource<Object> inverseResource = new PersistentResource<Object>(this, inverseEntity, this.getRequestScope());
            Object inverseRelation = inverseResource.getValue(inverseRelationName);
            if (Collection.class.isAssignableFrom(inverseRelationType)) {
                if (inverseRelation != null) {
                    inverseResource.addToCollection((Collection)inverseRelation, inverseRelationName, this);
                } else {
                    inverseResource.setValueChecked(inverseRelationName, Collections.singleton(this.getObject()));
                }
            } else if (inverseRelationType.equals(this.getResourceClass())) {
                inverseResource.setValueChecked(inverseRelationName, this.getObject());
            } else {
                throw new InternalServerErrorException("Relationship type mismatch");
            }
        }
    }

    protected static <A extends Annotation, T> Set<PersistentResource<T>> filter(Class<A> permission, Set<PersistentResource<T>> resources) {
        LinkedHashSet<PersistentResource<T>> filteredSet = new LinkedHashSet<PersistentResource<T>>();
        for (PersistentResource<T> resource : resources) {
            try {
                super.checkFieldAwarePermissions(permission);
                filteredSet.add(resource);
            }
            catch (ForbiddenAccessException e) {}
        }
        if (resources instanceof SingleElementSet && resources.equals(filteredSet)) {
            return resources;
        }
        return filteredSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <A extends Annotation> Set<String> filterFields(Class<A> permission, PersistentResource resource, Collection<String> fields) {
        LinkedHashSet<String> filteredSet = new LinkedHashSet<String>();
        boolean save = resource.getRequestScope().isNotDeferred();
        try {
            resource.getRequestScope().setNotDeferred(true);
            for (String field : fields) {
                try {
                    if (!PersistentResource.checkIncludeSparseField(resource.getRequestScope().getSparseFields(), resource.type, field)) continue;
                    resource.checkFieldAwarePermissions(permission, field);
                    filteredSet.add(field);
                }
                catch (ForbiddenAccessException e) {}
            }
        }
        finally {
            resource.getRequestScope().setNotDeferred(save);
        }
        return filteredSet;
    }

    static <A extends Annotation> void checkPermission(Class<A> annotationClass, A annotation, PersistentResource resource) {
        Class[] allChecks;
        Class[] anyChecks;
        if (resource.getRequestScope().getSecurityMode() == SecurityMode.SECURITY_INACTIVE) {
            return;
        }
        try {
            anyChecks = (Class[])annotationClass.getMethod("any", new Class[0]).invoke(annotation, (Object[])null);
            allChecks = (Class[])annotationClass.getMethod("all", new Class[0]).invoke(annotation, (Object[])null);
        }
        catch (ReflectiveOperationException e) {
            throw new InvalidSyntaxException("Unknown permission " + annotationClass.getName(), e);
        }
        if (anyChecks.length > 0) {
            resource.requestScope.checkPermissions(annotationClass, anyChecks, true, resource);
        } else if (allChecks.length > 0) {
            resource.requestScope.checkPermissions(annotationClass, allChecks, false, resource);
        } else {
            throw new InvalidSyntaxException("Unknown permission " + annotationClass.getName());
        }
    }

    static <A extends Annotation> FilterScope loadChecks(A annotation, RequestScope requestScope) {
        Class[] allChecks;
        Class[] anyChecks;
        if (annotation == null) {
            return new FilterScope(requestScope);
        }
        Class<?> annotationClass = annotation.getClass();
        try {
            anyChecks = (Class[])annotationClass.getMethod("any", new Class[0]).invoke(annotation, (Object[])null);
            allChecks = (Class[])annotationClass.getMethod("all", new Class[0]).invoke(annotation, (Object[])null);
        }
        catch (ReflectiveOperationException e) {
            throw new InvalidSyntaxException("Unknown permission " + annotationClass.getName(), e);
        }
        if (anyChecks.length > 0) {
            return new FilterScope(requestScope, true, anyChecks);
        }
        if (allChecks.length > 0) {
            return new FilterScope(requestScope, false, allChecks);
        }
        throw new InvalidSyntaxException("Unknown permission " + annotationClass.getName());
    }

    static <A extends Annotation> void checkPermission(Class<A> annotationClass, PersistentResource resource) {
        A annotation = resource.getDictionary().getAnnotation(resource, annotationClass);
        if (annotation == null) {
            return;
        }
        PersistentResource.checkPermission(annotationClass, annotation, resource);
    }

    private <A extends Annotation> void checkFieldAwarePermissions(Class<A> annotationClass) {
        this.requestScope.checkFieldAwarePermissions(annotationClass, this);
    }

    private <A extends Annotation> void checkFieldAwarePermissions(Class<A> annotationClass, String fieldName) {
        this.requestScope.checkFieldAwarePermissions(annotationClass, this, fieldName);
    }

    static void checkPermissions(Class<? extends Check>[] checks, boolean mode, PersistentResource resource) {
        for (Class<? extends Check> check : checks) {
            Check checkHandler;
            try {
                checkHandler = check.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new InvalidSyntaxException("Illegal permission check " + check.getName(), e);
            }
            boolean ok = resource.getRequestScope().getUser().ok(checkHandler, resource);
            if (ok && mode) {
                return;
            }
            if (ok || mode) continue;
            resource.getRequestScope().logAuthFailure(Arrays.asList(check), resource.getType(), resource.getId());
            throw new ForbiddenAccessException("Permission Check failed");
        }
        if (mode) {
            resource.getRequestScope().logAuthFailure(Arrays.asList(checks), resource.getType(), resource.getId());
            throw new ForbiddenAccessException("Permission Check failed");
        }
    }

    protected static <A extends Annotation> void checkFieldPermission(Class<A> annotationClass, PersistentResource resource, String fieldName) {
        A annotation = resource.getDictionary().getAttributeOrRelationAnnotation(resource.getResourceClass(), annotationClass, fieldName);
        if (annotation == null) {
            return;
        }
        PersistentResource.checkPermission(annotationClass, annotation, resource);
    }

    protected static <A extends Annotation> void checkFieldPermissionIfExists(Class<A> annotationClass, PersistentResource resource, String fieldName) {
        A annotation = resource.getDictionary().getAttributeOrRelationAnnotation(resource.getResourceClass(), annotationClass, fieldName);
        if (annotation == null) {
            throw new ForbiddenAccessException("Unable to find " + annotationClass.getSimpleName() + " annotation for " + resource.getResourceClass().getSimpleName() + "#" + fieldName);
        }
        PersistentResource.checkFieldPermission(annotationClass, resource, fieldName);
    }

    protected static boolean checkIncludeSparseField(Map<String, Set<String>> sparseFields, String type, String fieldName) {
        if (!sparseFields.isEmpty()) {
            if (!sparseFields.containsKey(type)) {
                return false;
            }
            if (!sparseFields.get(type).contains(fieldName)) {
                return false;
            }
        }
        return true;
    }

    protected void audit(String fieldName) {
        Audit[] annotations = (Audit[])this.dictionary.getAttributeOrRelationAnnotations(this.getResourceClass(), Audit.class, fieldName);
        if (annotations == null) {
            return;
        }
        for (Audit annotation : annotations) {
            if (annotation.action() != Audit.Action.UPDATE) {
                throw new InvalidSyntaxException("Only Audit.Action.UPDATE is allowed on fields.");
            }
            LogMessage message = new LogMessage(annotation, this);
            this.getRequestScope().getLogger().log(message);
        }
    }

    protected void audit(Audit.Action action) {
        Audit[] annotations = (Audit[])this.getResourceClass().getAnnotationsByType(Audit.class);
        if (annotations == null) {
            return;
        }
        for (Audit annotation : annotations) {
            if (annotation.action() != action) continue;
            LogMessage message = new LogMessage(annotation, this);
            this.getRequestScope().getLogger().log(message);
        }
    }

    public Object getOpaqueUser() {
        if (this.getRequestScope().getUser() == null) {
            return null;
        }
        return this.getRequestScope().getUser().getOpaqueUser();
    }

    public String toString() {
        return "PersistentResource(type=" + this.getType() + ", obj=" + this.obj + ", lineage=" + this.getLineage() + ", uuid=" + this.getUUID() + ", user=" + this.user + ", entityCache=" + this.entityCache + ", transaction=" + this.transaction + ", requestScope=" + this.getRequestScope() + ", parent=" + this.parent + ", dictionary=" + this.getDictionary() + ", comparator=" + this.comparator + ")";
    }
}

