/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.extensions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.elide.Elide;
import com.yahoo.elide.core.DataStore;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.SecurityMode;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.extensions.PatchRequestScope;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.models.Patch;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.parsers.DeleteVisitor;
import com.yahoo.elide.parsers.PatchVisitor;
import com.yahoo.elide.parsers.PostVisitor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class JsonApiPatch {
    private final List<PatchAction> actions;
    private final String rootUri;
    private static final ObjectNode ERR_NODE_ERR_IN_SUBSEQUENT_OPERATION;
    private static final ObjectNode ERR_NODE_OPERATION_NOT_RUN;

    public static Supplier<Pair<Integer, JsonNode>> processJsonPatch(DataStore dataStore, String uri, String patchDoc, PatchRequestScope requestScope) throws IOException {
        List<Patch> actions = requestScope.getMapper().readJsonApiPatchExtDoc(patchDoc);
        JsonApiPatch processor = new JsonApiPatch(dataStore, actions, uri, requestScope);
        return processor.processActions(requestScope);
    }

    private JsonApiPatch(DataStore dataStore, List<Patch> actions, String rootUri, RequestScope requestScope) {
        this.actions = actions.stream().map(PatchAction::new).collect(Collectors.toList());
        this.rootUri = rootUri;
    }

    private Supplier<Pair<Integer, JsonNode>> processActions(PatchRequestScope requestScope) {
        try {
            List<Supplier<Pair<Integer, JsonNode>>> results = this.handleActions(requestScope);
            this.postProcessRelationships(requestScope);
            results.forEach(Supplier::get);
            return () -> {
                try {
                    return Pair.of((Object)200, (Object)JsonApiPatch.mergeResponse(results));
                }
                catch (HttpStatusException e) {
                    return this.buildErrorResponse(e, requestScope.getSecurityMode());
                }
            };
        }
        catch (HttpStatusException e) {
            return () -> this.buildErrorResponse(e, requestScope.getSecurityMode());
        }
    }

    private List<Supplier<Pair<Integer, JsonNode>>> handleActions(PatchRequestScope requestScope) {
        return this.actions.stream().map(action -> {
            try {
                Supplier<Pair<Integer, JsonNode>> result;
                CharSequence[] combined = (String[])ArrayUtils.addAll((Object[])this.rootUri.split("/"), (Object[])action.patch.getPath().split("/"));
                String fullPath = String.join((CharSequence)"/", combined).replace("/-", "");
                switch (action.patch.getOperation()) {
                    case ADD: {
                        result = this.handleAddOp(fullPath, action.patch.getValue(), requestScope, (PatchAction)action);
                        break;
                    }
                    case REPLACE: {
                        result = this.handleReplaceOp(fullPath, action.patch.getValue(), requestScope);
                        break;
                    }
                    case REMOVE: {
                        result = this.handleRemoveOp(fullPath, action.patch.getValue(), requestScope);
                        break;
                    }
                    default: {
                        throw new InvalidEntityBodyException("Could not parse patch extension operation:" + (Object)((Object)action.patch.getOperation()));
                    }
                }
                return result;
            }
            catch (HttpStatusException e) {
                action.cause = e;
                throw e;
            }
        }).collect(Collectors.toList());
    }

    private Supplier<Pair<Integer, JsonNode>> handleAddOp(String path, JsonNode patchValue, PatchRequestScope requestScope, PatchAction action) {
        try {
            JsonApiDocument value = requestScope.getMapper().readJsonApiPatchExtValue(patchValue);
            Data<Resource> data = value.getData();
            if (data == null || data.get() == null) {
                throw new InvalidEntityBodyException("Expected an entity body but received none.");
            }
            Collection<Resource> resources = data.get();
            if (!path.contains("relationships")) {
                String id = JsonApiPatch.getSingleResource(resources).getId();
                String fullPath = path + "/" + id;
                JsonApiPatch.getSingleResource(resources).setRelationships(null);
                action.doc = requestScope.getMapper().readJsonApiPatchExtValue(patchValue);
                action.path = fullPath;
                action.isPostProcessing = true;
            }
            PostVisitor visitor = new PostVisitor(new PatchRequestScope(value, requestScope));
            return (Supplier)visitor.visit(Elide.parse(path));
        }
        catch (HttpStatusException e) {
            action.cause = e;
            throw e;
        }
        catch (IOException e) {
            throw new InvalidEntityBodyException("Could not parse patch extension value: " + patchValue);
        }
    }

    private Supplier<Pair<Integer, JsonNode>> handleReplaceOp(String path, JsonNode patchVal, PatchRequestScope requestScope) {
        try {
            JsonApiDocument value = requestScope.getMapper().readJsonApiPatchExtValue(patchVal);
            PatchVisitor visitor = new PatchVisitor(new PatchRequestScope(value, requestScope));
            return (Supplier)visitor.visit(Elide.parse(path));
        }
        catch (IOException e) {
            throw new InvalidEntityBodyException("Could not parse patch extension value: " + patchVal);
        }
    }

    private Supplier<Pair<Integer, JsonNode>> handleRemoveOp(String path, JsonNode patchValue, PatchRequestScope requestScope) {
        try {
            String fullPath;
            JsonApiDocument value = requestScope.getMapper().readJsonApiPatchExtValue(patchValue);
            if (path.contains("relationships")) {
                fullPath = path;
            } else {
                Data<Resource> data = value.getData();
                if (data == null || data.get() == null) {
                    fullPath = path;
                } else {
                    Collection<Resource> resources = data.get();
                    String id = JsonApiPatch.getSingleResource(resources).getId();
                    fullPath = path + "/" + id;
                }
            }
            DeleteVisitor visitor = new DeleteVisitor(new PatchRequestScope(value, requestScope));
            return (Supplier)visitor.visit(Elide.parse(fullPath));
        }
        catch (IOException e) {
            throw new InvalidEntityBodyException("Could not parse patch extension value: " + patchValue);
        }
    }

    private void postProcessRelationships(PatchRequestScope requestScope) {
        this.actions.forEach(action -> action.postProcess(requestScope));
    }

    private Pair<Integer, JsonNode> buildErrorResponse(HttpStatusException e, SecurityMode securityMode) {
        if (e.getStatus() == 403) {
            return securityMode == SecurityMode.SECURITY_ACTIVE_VERBOSE ? e.getVerboseErrorResponse() : e.getErrorResponse();
        }
        ObjectNode errorContainer = this.getErrorContainer();
        ArrayNode errorList = (ArrayNode)errorContainer.get("errors");
        boolean failed = false;
        for (PatchAction action : this.actions) {
            failed = this.processAction(errorList, failed, action);
        }
        return Pair.of((Object)400, (Object)errorContainer);
    }

    private ObjectNode getErrorContainer() {
        ObjectNode container = JsonNodeFactory.instance.objectNode();
        container.set("errors", (JsonNode)JsonNodeFactory.instance.arrayNode());
        return container;
    }

    private boolean processAction(ArrayNode errorList, boolean failed, PatchAction action) {
        if (action.cause != null) {
            errorList.add(JsonApiPatch.toErrorNode(action.cause.getMessage(), action.cause.getStatus()));
            failed = true;
        } else if (!failed) {
            errorList.add((JsonNode)ERR_NODE_ERR_IN_SUBSEQUENT_OPERATION);
        } else {
            errorList.add((JsonNode)ERR_NODE_OPERATION_NOT_RUN);
        }
        return failed;
    }

    private static void clearAllExceptRelationships(JsonApiDocument doc) {
        Data<Resource> data = doc.getData();
        if (data == null || data.get() == null) {
            return;
        }
        data.get().forEach(JsonApiPatch::clearAllExceptRelationships);
    }

    private static void clearAllExceptRelationships(Resource resource) {
        resource.setAttributes(null);
        resource.setLinks(null);
        resource.setMeta(null);
    }

    private static JsonNode toErrorNode(String detail, Integer status) {
        ObjectNode formattedError = JsonNodeFactory.instance.objectNode();
        formattedError.set("detail", (JsonNode)JsonNodeFactory.instance.textNode(detail));
        if (status != null) {
            formattedError.set("status", (JsonNode)JsonNodeFactory.instance.numberNode(status));
        }
        return formattedError;
    }

    private static JsonNode mergeResponse(List<Supplier<Pair<Integer, JsonNode>>> results) {
        ArrayNode list = JsonNodeFactory.instance.arrayNode();
        for (Supplier<Pair<Integer, JsonNode>> result : results) {
            JsonNode node = (JsonNode)result.get().getRight();
            if (node == null || node instanceof NullNode) {
                node = JsonNodeFactory.instance.objectNode().set("data", null);
            }
            list.add(node);
        }
        return list;
    }

    public static boolean isPatchExtension(String header) {
        if (header == null) {
            return false;
        }
        return Arrays.asList(header.split(";")).stream().map(key -> key.split("=")).filter(value -> ((String[])value).length == 2).anyMatch(value -> value[0].trim().equals("ext") && value[1].trim().equals("jsonpatch"));
    }

    private static Resource getSingleResource(Collection<Resource> resources) {
        if (resources == null || resources.size() != 1) {
            throw new InvalidEntityBodyException("Expected single resource.");
        }
        return resources.iterator().next();
    }

    static {
        ERR_NODE_OPERATION_NOT_RUN = JsonNodeFactory.instance.objectNode();
        ERR_NODE_OPERATION_NOT_RUN.set("detail", (JsonNode)JsonNodeFactory.instance.textNode("Operation not executed. Terminated by earlier failure."));
        ERR_NODE_ERR_IN_SUBSEQUENT_OPERATION = JsonNodeFactory.instance.objectNode();
        ERR_NODE_ERR_IN_SUBSEQUENT_OPERATION.set("detail", (JsonNode)JsonNodeFactory.instance.textNode("Subsequent operation failed."));
    }

    private static class PatchAction {
        public final Patch patch;
        public HttpStatusException cause;
        public boolean isPostProcessing;
        public JsonApiDocument doc;
        public String path;

        public PatchAction(Patch patch) {
            this.patch = patch;
            this.cause = null;
        }

        public void postProcess(PatchRequestScope requestScope) {
            if (this.isPostProcessing) {
                try {
                    JsonApiPatch.clearAllExceptRelationships(this.doc);
                    PatchVisitor visitor = new PatchVisitor(new PatchRequestScope(this.doc, requestScope));
                    visitor.visit(Elide.parse(this.path));
                }
                catch (HttpStatusException e) {
                    this.cause = e;
                    throw e;
                }
            }
        }
    }
}

