/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.InvalidObjectIdentifierException;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.jsonapi.models.ResourceIdentifier;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Relationship {
    private final Map<String, String> links;
    private final Data<Resource> data;
    @JsonIgnore
    private final Data<ResourceIdentifier> idData;

    public Relationship(@JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="data") Data<Resource> data) {
        Resource resource;
        this.links = links;
        this.data = data;
        this.idData = data != null ? (data.isToOne() ? new Data<ResourceIdentifier>((resource = data.get().iterator().next()) != null ? resource.toResourceIdentifier() : null) : new Data(data.get().stream().map(Resource::toResourceIdentifier).collect(Collectors.toList()))) : null;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, String> getLinks() {
        return this.links == null || this.links.isEmpty() ? null : this.links;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Data<Resource> getData() {
        return this.data;
    }

    @JsonIgnore
    public Data<ResourceIdentifier> getResourceIdentifierData() {
        return this.idData;
    }

    public Set<PersistentResource> toPersistentResources(RequestScope requestScope) throws ForbiddenAccessException, InvalidObjectIdentifierException {
        LinkedHashSet<PersistentResource> res = new LinkedHashSet<PersistentResource>();
        if (this.data == null) {
            return null;
        }
        Collection<Resource> resources = this.data.get();
        if (resources != null) {
            for (Resource resource : resources) {
                try {
                    if (this.data.isToOne() && resource == null) continue;
                    res.add(resource.toPersistentResource(requestScope));
                }
                catch (ForbiddenAccessException e) {}
            }
        }
        return res.isEmpty() ? (this.data.isToOne() ? null : res) : res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Data<Resource> that = ((Relationship)o).getData();
        if (that == null || this.data == null) {
            return that == this.data;
        }
        Collection<ResourceIdentifier> resourceIdentifiers = this.data.toResourceIdentifiers();
        Collection<ResourceIdentifier> theirIdentifiers = that.toResourceIdentifiers();
        return resourceIdentifiers.stream().allMatch(theirIdentifiers::contains);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.data).toHashCode();
    }
}

