/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.parsers.state;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.exceptions.InvalidOperationException;
import com.yahoo.elide.jsonapi.document.processors.IncludedProcessor;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.models.Relationship;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.jsonapi.models.SingleElementSet;
import com.yahoo.elide.parsers.state.BaseState;
import com.yahoo.elide.parsers.state.CollectionTerminalState;
import com.yahoo.elide.parsers.state.StateContext;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.tuple.Pair;

public class RecordTerminalState
extends BaseState {
    private final PersistentResource record;
    private final Optional<CollectionTerminalState> collectionTerminalState;

    public RecordTerminalState(PersistentResource record) {
        this(record, null);
    }

    public RecordTerminalState(PersistentResource record, CollectionTerminalState collectionTerminalState) {
        this.record = record;
        this.collectionTerminalState = Optional.ofNullable(collectionTerminalState);
    }

    @Override
    public Supplier<Pair<Integer, JsonNode>> handleGet(StateContext state) {
        ObjectMapper mapper = state.getRequestScope().getMapper().getObjectMapper();
        return () -> Pair.of((Object)200, (Object)this.getResponseBody(this.record, state.getRequestScope(), mapper));
    }

    @Override
    public Supplier<Pair<Integer, JsonNode>> handlePost(StateContext state) {
        if (this.collectionTerminalState.isPresent()) {
            return this.collectionTerminalState.get().handlePost(state);
        }
        throw new InvalidOperationException("Cannot POST to a record.");
    }

    @Override
    public Supplier<Pair<Integer, JsonNode>> handlePatch(StateContext state) {
        Resource resource;
        NullNode empty = JsonNodeFactory.instance.nullNode();
        JsonApiDocument jsonApiDocument = state.getJsonApiDocument();
        Data<Resource> data = jsonApiDocument.getData();
        if (data == null) {
            throw new InvalidEntityBodyException("Expected data but found null");
        }
        if (data.get() instanceof SingleElementSet && this.record.matchesId((resource = data.get().iterator().next()).getId())) {
            this.patch(data.get().iterator().next(), state.getRequestScope());
            return () -> RecordTerminalState.lambda$handlePatch$33((JsonNode)empty);
        }
        throw new InvalidEntityBodyException("Expected single element but found list");
    }

    @Override
    public Supplier<Pair<Integer, JsonNode>> handleDelete(StateContext state) {
        try {
            this.record.deleteResource();
            return () -> Pair.of((Object)204, null);
        }
        catch (ForbiddenAccessException e) {
            return () -> Pair.of((Object)e.getStatus(), null);
        }
    }

    private JsonNode getResponseBody(PersistentResource rec, RequestScope requestScope, ObjectMapper mapper) {
        Optional<MultivaluedMap<String, String>> queryParams = requestScope.getQueryParams();
        JsonApiDocument jsonApiDocument = new JsonApiDocument();
        Data<Resource> data = rec == null ? null : new Data<Resource>(rec.toResource());
        jsonApiDocument.setData(data);
        IncludedProcessor includedProcessor = new IncludedProcessor();
        includedProcessor.execute(jsonApiDocument, rec, queryParams);
        return (JsonNode)mapper.convertValue((Object)jsonApiDocument, JsonNode.class);
    }

    private boolean patch(Resource resource, RequestScope requestScope) {
        Map<String, Relationship> relationships;
        boolean isUpdated = false;
        Map<String, Object> attributes = resource.getAttributes();
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                String key = entry.getKey();
                Object newVal = entry.getValue();
                isUpdated |= this.record.updateAttribute(key, newVal);
            }
        }
        if ((relationships = resource.getRelationships()) != null) {
            for (Map.Entry<String, Relationship> entry : relationships.entrySet()) {
                String key = entry.getKey();
                Relationship relationship = entry.getValue();
                Set<PersistentResource> resources = relationship == null ? null : relationship.toPersistentResources(requestScope);
                isUpdated |= this.record.updateRelation(key, resources);
            }
        }
        return isUpdated;
    }

    public String toString() {
        return "RecordTerminalState(record=" + this.record + ", collectionTerminalState=" + this.collectionTerminalState + ")";
    }

    private static /* synthetic */ Pair lambda$handlePatch$33(JsonNode jsonNode) {
        return Pair.of((Object)204, (Object)jsonNode);
    }
}

