/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.parsers.state;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RelationshipType;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.jsonapi.document.processors.IncludedProcessor;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.models.Relationship;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.parsers.state.BaseState;
import com.yahoo.elide.parsers.state.StateContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.tuple.Pair;

public class RelationshipTerminalState
extends BaseState {
    private final PersistentResource record;
    private final RelationshipType relationshipType;
    private final String relationshipName;

    public RelationshipTerminalState(PersistentResource record, String relationshipName) {
        this.record = record;
        this.relationshipType = record.getRelationshipType(relationshipName);
        this.relationshipName = relationshipName;
    }

    @Override
    public Supplier<Pair<Integer, JsonNode>> handleGet(StateContext state) {
        JsonApiDocument doc = new JsonApiDocument();
        RequestScope requestScope = state.getRequestScope();
        ObjectMapper mapper = requestScope.getMapper().getObjectMapper();
        Optional<MultivaluedMap<String, String>> queryParams = requestScope.getQueryParams();
        Map<String, Relationship> relationships = this.record.toResource().getRelationships();
        Relationship relationship = null;
        if (relationships != null) {
            relationship = relationships.get(this.relationshipName);
        }
        if (relationship != null) {
            Data<Resource> data = relationship.getData();
            doc.setData(data);
            IncludedProcessor includedProcessor = new IncludedProcessor();
            includedProcessor.execute(doc, this.record, queryParams);
            return () -> Pair.of((Object)200, (Object)mapper.convertValue((Object)doc, JsonNode.class));
        }
        if (this.relationshipType.isToMany()) {
            doc.setData(new Data<Resource>(new ArrayList()));
        } else if (this.relationshipType.isToOne()) {
            doc.setData(new Data<Resource>((Resource)null));
        } else {
            throw new IllegalStateException("Failed to GET a relationship; relationship is neither toMany nor toOne");
        }
        return () -> Pair.of((Object)200, (Object)mapper.convertValue((Object)doc, JsonNode.class));
    }

    @Override
    public Supplier<Pair<Integer, JsonNode>> handlePatch(StateContext state) {
        return this.handleRequest(state, this::patch);
    }

    @Override
    public Supplier<Pair<Integer, JsonNode>> handlePost(StateContext state) {
        return this.handleRequest(state, this::post);
    }

    @Override
    public Supplier<Pair<Integer, JsonNode>> handleDelete(StateContext state) {
        return this.handleRequest(state, this::delete);
    }

    private Supplier<Pair<Integer, JsonNode>> handleRequest(StateContext state, BiFunction<Data<Resource>, RequestScope, Boolean> handler) {
        Data<Resource> data = state.getJsonApiDocument().getData();
        handler.apply(data, state.getRequestScope());
        return () -> Pair.of((Object)204, null);
    }

    private boolean patch(Data<Resource> data, RequestScope requestScope) {
        boolean isUpdated;
        if (this.relationshipType.isToMany() && data == null) {
            throw new InvalidEntityBodyException("Expected data but received null");
        }
        if (this.relationshipType.isToMany()) {
            Collection<Resource> resources = data.get();
            if (resources == null) {
                return false;
            }
            isUpdated = !resources.isEmpty() ? this.record.updateRelation(this.relationshipName, new Relationship(null, new Data<Resource>(resources)).toPersistentResources(requestScope)) : this.record.clearRelation(this.relationshipName);
        } else if (this.relationshipType.isToOne()) {
            if (data != null) {
                Resource resource = data.get().iterator().next();
                Relationship relationship = new Relationship(null, new Data<Resource>(resource));
                isUpdated = this.record.updateRelation(this.relationshipName, relationship.toPersistentResources(requestScope));
            } else {
                isUpdated = this.record.clearRelation(this.relationshipName);
            }
        } else {
            throw new IllegalStateException("Bad relationship type");
        }
        return isUpdated;
    }

    private boolean post(Data<Resource> data, RequestScope requestScope) {
        if (data == null) {
            throw new InvalidEntityBodyException("Expected data but received null");
        }
        Collection<Resource> resources = data.get();
        if (resources == null) {
            return false;
        }
        resources.stream().forEachOrdered(resource -> this.record.addRelation(this.relationshipName, resource.toPersistentResource(requestScope)));
        return true;
    }

    private boolean delete(Data<Resource> data, RequestScope requestScope) {
        if (data == null) {
            throw new InvalidEntityBodyException("Expected data but received null");
        }
        Collection<Resource> resources = data.get();
        if (resources == null || resources.isEmpty()) {
            throw new ForbiddenAccessException("Unknown update");
        }
        resources.stream().forEachOrdered(resource -> this.record.removeRelation(this.relationshipName, resource.toPersistentResource(requestScope)));
        return true;
    }
}

