/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.yahoo.elide.annotation.Audit;
import com.yahoo.elide.annotation.CreatePermission;
import com.yahoo.elide.annotation.DeletePermission;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.annotation.SharePermission;
import com.yahoo.elide.annotation.UpdatePermission;
import com.yahoo.elide.audit.InvalidSyntaxException;
import com.yahoo.elide.audit.LogMessage;
import com.yahoo.elide.core.CRUDEvent;
import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.PersistentResourceSet;
import com.yahoo.elide.core.RelationshipType;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.ResourceLineage;
import com.yahoo.elide.core.VerifyFieldAccessFilterExpressionVisitor;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.InternalServerErrorException;
import com.yahoo.elide.core.exceptions.InvalidAttributeException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.exceptions.InvalidObjectIdentifierException;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.filter.InPredicate;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.Relationship;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.jsonapi.models.ResourceIdentifier;
import com.yahoo.elide.jsonapi.models.SingleElementSet;
import com.yahoo.elide.parsers.expression.CanPaginateVisitor;
import com.yahoo.elide.security.ChangeSpec;
import com.yahoo.elide.security.permissions.ExpressionResult;
import com.yahoo.elide.utils.coerce.CoerceUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;

public class PersistentResource<T>
implements com.yahoo.elide.security.PersistentResource<T> {
    protected T obj;
    private final String type;
    private final ResourceLineage lineage;
    private final Optional<String> uuid;
    private final DataStoreTransaction transaction;
    private final RequestScope requestScope;
    private int hashCode = 0;
    static final String CLASS_NO_FIELD = "";
    protected final EntityDictionary dictionary;
    private final Comparator<String> lengthFirstComparator = (string1, string2) -> {
        int diff = string1.length() - string2.length();
        return diff == 0 ? string1.compareTo((String)string2) : diff;
    };

    public String toString() {
        return String.format("PersistentResource{type=%s, id=%s}", this.type, this.uuid.orElse(this.getId()));
    }

    public static <T> PersistentResource<T> createObject(PersistentResource<?> parent, Class<T> entityClass, RequestScope requestScope, Optional<String> uuid) {
        T obj = requestScope.getTransaction().createNewObject(entityClass);
        String id = uuid.orElse(null);
        PersistentResource newResource = new PersistentResource(obj, parent, id, requestScope);
        PersistentResource.assignId(newResource, id);
        requestScope.getNewPersistentResources().add(newResource);
        PersistentResource.checkPermission(CreatePermission.class, newResource);
        newResource.auditClass(Audit.Action.CREATE, new ChangeSpec(newResource, null, null, newResource.getObject()));
        requestScope.publishLifecycleEvent(newResource, CRUDEvent.CRUDAction.CREATE);
        String type = newResource.getType();
        requestScope.setUUIDForObject(type, id, newResource.getObject());
        requestScope.getDictionary().getRelationships(entityClass).stream().filter(relationName -> newResource.getRelationshipType((String)relationName).isToMany() && newResource.getValueUnchecked((String)relationName) == null).forEach(relationName -> newResource.setValue((String)relationName, new LinkedHashSet()));
        super.markDirty();
        return newResource;
    }

    public PersistentResource(@NonNull T obj, PersistentResource parent, String id, @NonNull RequestScope scope) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (scope == null) {
            throw new NullPointerException("scope is marked non-null but is null");
        }
        this.obj = obj;
        this.uuid = Optional.ofNullable(id);
        this.lineage = parent != null ? new ResourceLineage(parent.lineage, parent) : new ResourceLineage();
        this.dictionary = scope.getDictionary();
        this.type = this.dictionary.getJsonAliasFor(obj.getClass());
        this.transaction = scope.getTransaction();
        this.requestScope = scope;
        this.dictionary.initializeEntity(obj);
    }

    public boolean matchesId(String checkId) {
        if (checkId == null) {
            return false;
        }
        return this.uuid.map(checkId::equals).orElseGet(() -> {
            String id = this.getId();
            return !"0".equals(id) && !"null".equals(id) && checkId.equals(id);
        });
    }

    @NonNull
    public static <T> PersistentResource<T> loadRecord(Class<T> loadClass, String id, RequestScope requestScope) throws InvalidObjectIdentifierException {
        Preconditions.checkNotNull(loadClass);
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)requestScope);
        DataStoreTransaction tx = requestScope.getTransaction();
        EntityDictionary dictionary = requestScope.getDictionary();
        Object obj = requestScope.getObjectById(dictionary.getJsonAliasFor(loadClass), id);
        if (obj == null) {
            Optional<FilterExpression> permissionFilter = PersistentResource.getPermissionFilterExpression(loadClass, requestScope);
            Class<?> idType = dictionary.getIdType(loadClass);
            obj = tx.loadObject(loadClass, (Serializable)CoerceUtil.coerce(id, idType), permissionFilter, requestScope);
            if (obj == null) {
                throw new InvalidObjectIdentifierException(id, dictionary.getJsonAliasFor(loadClass));
            }
        }
        PersistentResource<T> resource = new PersistentResource<T>(loadClass.cast(obj), null, requestScope.getUUIDFor(obj), requestScope);
        if (!requestScope.getNewResources().contains(resource)) {
            super.checkFieldAwarePermissions(ReadPermission.class);
        }
        return resource;
    }

    private static <T> Optional<FilterExpression> getPermissionFilterExpression(Class<T> loadClass, RequestScope requestScope) {
        try {
            return requestScope.getPermissionExecutor().getReadPermissionFilter(loadClass);
        }
        catch (ForbiddenAccessException e) {
            return Optional.empty();
        }
    }

    public static Set<PersistentResource> loadRecords(Class<?> loadClass, List<String> ids, Optional<FilterExpression> filter, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope requestScope) {
        Set<PersistentResource> existingResources;
        Sets.SetView allResources;
        Set allExpectedIds;
        Sets.SetView missedIds;
        FilterExpression filterExpression;
        EntityDictionary dictionary = requestScope.getDictionary();
        DataStoreTransaction tx = requestScope.getTransaction();
        if (PersistentResource.shouldSkipCollection(loadClass, ReadPermission.class, requestScope)) {
            if (ids.isEmpty()) {
                return Collections.emptySet();
            }
            throw new InvalidObjectIdentifierException(ids.toString(), dictionary.getJsonAliasFor(loadClass));
        }
        if (pagination.isPresent() && !pagination.get().isDefaultInstance() && !CanPaginateVisitor.canPaginate(loadClass, dictionary, requestScope)) {
            throw new BadRequestException(String.format("Cannot paginate %s", dictionary.getJsonAliasFor(loadClass)));
        }
        Set<Object> newResources = new LinkedHashSet();
        if (!ids.isEmpty()) {
            String typeAlias = dictionary.getJsonAliasFor(loadClass);
            newResources = requestScope.getNewPersistentResources().stream().filter(resource -> typeAlias.equals(resource.getType()) && ids.contains(resource.getUUID().orElse(CLASS_NO_FIELD))).collect(Collectors.toSet());
            FilterExpression idExpression = PersistentResource.buildIdFilterExpression(ids, loadClass, dictionary, requestScope);
            filterExpression = filter.map(fe -> new AndFilterExpression(idExpression, (FilterExpression)fe)).orElse(idExpression);
        } else {
            filterExpression = filter.orElse(null);
        }
        Optional<FilterExpression> permissionFilter = PersistentResource.getPermissionFilterExpression(loadClass, requestScope);
        if (permissionFilter.isPresent()) {
            filterExpression = filterExpression != null ? new AndFilterExpression(filterExpression, permissionFilter.get()) : permissionFilter.get();
        }
        if (!(missedIds = Sets.difference(new HashSet<String>(ids), allExpectedIds = (allResources = Sets.union(newResources, existingResources = PersistentResource.filter(ReadPermission.class, filter, new PersistentResourceSet<Object>(tx.loadObjects(loadClass, Optional.ofNullable(filterExpression), sorting, pagination.map(p -> p.evaluate(loadClass)), requestScope), requestScope)))).stream().map(resource -> (String)resource.getUUID().orElseGet(resource::getId)).collect(Collectors.toSet()))).isEmpty()) {
            throw new InvalidObjectIdentifierException(missedIds.toString(), dictionary.getJsonAliasFor(loadClass));
        }
        return allResources;
    }

    public boolean updateAttribute(String fieldName, Object newVal) {
        Class<?> fieldClass = this.dictionary.getType(this.getResourceClass(), fieldName);
        newVal = this.dictionary.coerce(this.obj, newVal, fieldName, fieldClass);
        Object val = this.getValueUnchecked(fieldName);
        this.checkFieldAwareDeferPermissions(UpdatePermission.class, fieldName, newVal, val);
        if (!Objects.equals(val, newVal)) {
            this.setValueChecked(fieldName, newVal);
            this.markDirty();
            if (this.dictionary.isAttribute(this.obj.getClass(), fieldName)) {
                this.transaction.setAttribute(this.obj, fieldName, newVal, this.requestScope);
            }
            return true;
        }
        return false;
    }

    public boolean updateRelation(String fieldName, Set<PersistentResource> resourceIdentifiers) {
        boolean isUpdated;
        RelationshipType type = this.getRelationshipType(fieldName);
        Set<PersistentResource> resources = PersistentResource.filter(ReadPermission.class, Optional.empty(), this.getRelationUncheckedUnfiltered(fieldName));
        if (type.isToMany()) {
            List modifiedResources = CollectionUtils.isEmpty(resourceIdentifiers) ? Collections.emptyList() : resourceIdentifiers.stream().map(PersistentResource::getObject).collect(Collectors.toList());
            this.checkFieldAwareDeferPermissions(UpdatePermission.class, fieldName, modifiedResources, resources.stream().map(PersistentResource::getObject).collect(Collectors.toList()));
            isUpdated = this.updateToManyRelation(fieldName, resourceIdentifiers, resources);
        } else {
            PersistentResource resource = PersistentResource.firstOrNullIfEmpty(resources);
            Object original = resource == null ? null : resource.getObject();
            PersistentResource modifiedResource = PersistentResource.firstOrNullIfEmpty(resourceIdentifiers);
            Object modified = modifiedResource == null ? null : modifiedResource.getObject();
            this.checkFieldAwareDeferPermissions(UpdatePermission.class, fieldName, modified, original);
            isUpdated = this.updateToOneRelation(fieldName, resourceIdentifiers, resources);
        }
        return isUpdated;
    }

    protected boolean updateToManyRelation(String fieldName, Set<PersistentResource> resourceIdentifiers, Set<PersistentResource> mine) {
        if (resourceIdentifiers == null) {
            throw new InvalidEntityBodyException("Bad relation data");
        }
        Set<PersistentResource> requested = resourceIdentifiers.isEmpty() ? new LinkedHashSet<PersistentResource>() : resourceIdentifiers;
        Sets.SetView deleted = Sets.difference(mine, requested);
        Sets.SetView updated = Sets.difference((Set)Sets.union(mine, requested), (Set)Sets.intersection(mine, requested));
        Sets.SetView added = Sets.difference((Set)updated, (Set)deleted);
        this.checkSharePermission((Set<PersistentResource>)added);
        Collection collection = (Collection)this.getValueUnchecked(fieldName);
        if (collection == null) {
            this.setValue(fieldName, mine);
        }
        LinkedHashSet<Object> newRelationships = new LinkedHashSet<Object>();
        LinkedHashSet<Object> deletedRelationships = new LinkedHashSet<Object>();
        deleted.stream().forEach(toDelete -> {
            this.delFromCollection(collection, fieldName, (PersistentResource)toDelete, false);
            this.deleteInverseRelation(fieldName, toDelete.getObject());
            deletedRelationships.add(toDelete.getObject());
        });
        added.stream().forEach(toAdd -> {
            this.addToCollection(collection, fieldName, (PersistentResource)toAdd);
            this.addInverseRelation(fieldName, toAdd.getObject());
            newRelationships.add(toAdd.getObject());
        });
        if (!updated.isEmpty()) {
            this.markDirty();
        }
        this.transaction.updateToManyRelation(this.transaction, this.obj, fieldName, newRelationships, deletedRelationships, this.requestScope);
        return !updated.isEmpty();
    }

    protected boolean updateToOneRelation(String fieldName, Set<PersistentResource> resourceIdentifiers, Set<PersistentResource> mine) {
        PersistentResource oldResource;
        Object newValue = null;
        PersistentResource newResource = null;
        if (CollectionUtils.isNotEmpty(resourceIdentifiers)) {
            newResource = (PersistentResource)IterableUtils.first(resourceIdentifiers);
            newValue = newResource.getObject();
        }
        if ((oldResource = PersistentResource.firstOrNullIfEmpty(mine)) == null) {
            if (newValue == null) {
                return false;
            }
            this.checkSharePermission(resourceIdentifiers);
        } else {
            if (oldResource.getObject().equals(newValue)) {
                return false;
            }
            this.checkSharePermission(resourceIdentifiers);
            if (this.hasInverseRelation(fieldName)) {
                this.deleteInverseRelation(fieldName, oldResource.getObject());
                oldResource.markDirty();
            }
        }
        if (newResource != null && this.hasInverseRelation(fieldName)) {
            this.addInverseRelation(fieldName, newValue);
            newResource.markDirty();
        }
        this.setValueChecked(fieldName, newValue);
        this.transaction.updateToOneRelation(this.transaction, this.obj, fieldName, newValue, this.requestScope);
        this.markDirty();
        return true;
    }

    public boolean clearRelation(String relationName) {
        Set<PersistentResource> mine = PersistentResource.filter(ReadPermission.class, Optional.empty(), this.getRelationUncheckedUnfiltered(relationName));
        this.checkFieldAwareDeferPermissions(UpdatePermission.class, relationName, Collections.emptySet(), mine.stream().map(PersistentResource::getObject).collect(Collectors.toSet()));
        if (mine.isEmpty()) {
            return false;
        }
        RelationshipType type = this.getRelationshipType(relationName);
        mine.stream().forEach(toDelete -> {
            if (this.hasInverseRelation(relationName)) {
                this.deleteInverseRelation(relationName, toDelete.getObject());
                toDelete.markDirty();
            }
        });
        if (type.isToOne()) {
            PersistentResource oldValue = (PersistentResource)IterableUtils.first(mine);
            if (oldValue != null && oldValue.getObject() != null) {
                this.nullValue(relationName, oldValue);
                oldValue.markDirty();
                this.markDirty();
                this.transaction.updateToOneRelation(this.transaction, this.obj, relationName, null, this.requestScope);
            }
        } else {
            Collection collection = (Collection)this.getValueUnchecked(relationName);
            if (CollectionUtils.isNotEmpty((Collection)collection)) {
                LinkedHashSet<Object> deletedRelationships = new LinkedHashSet<Object>();
                mine.stream().forEach(toDelete -> {
                    this.delFromCollection(collection, relationName, (PersistentResource)toDelete, false);
                    if (this.hasInverseRelation(relationName)) {
                        toDelete.markDirty();
                    }
                    deletedRelationships.add(toDelete.getObject());
                });
                this.markDirty();
                this.transaction.updateToManyRelation(this.transaction, this.obj, relationName, new LinkedHashSet<Object>(), deletedRelationships, this.requestScope);
            }
        }
        return true;
    }

    public void removeRelation(String fieldName, PersistentResource removeResource) {
        RelationshipType type;
        Object relation;
        Object original = relation = this.getValueUnchecked(fieldName);
        Collection modified = null;
        if (relation instanceof Collection) {
            original = this.copyCollection((Collection)relation);
        }
        if (relation instanceof Collection && removeResource != null) {
            modified = CollectionUtils.disjunction((Iterable)((Collection)relation), Collections.singleton(removeResource.getObject()));
        }
        this.checkFieldAwareDeferPermissions(UpdatePermission.class, fieldName, modified, original);
        if (relation instanceof Collection) {
            if (removeResource == null || !((Collection)relation).contains(removeResource.getObject())) {
                return;
            }
            this.delFromCollection((Collection)relation, fieldName, removeResource, false);
        } else {
            if (relation == null || removeResource == null || !relation.equals(removeResource.getObject())) {
                return;
            }
            this.nullValue(fieldName, removeResource);
        }
        if (this.hasInverseRelation(fieldName)) {
            this.deleteInverseRelation(fieldName, removeResource.getObject());
            removeResource.markDirty();
        }
        if (!Objects.equals(original, modified)) {
            this.markDirty();
        }
        if ((type = this.getRelationshipType(fieldName)).isToOne()) {
            this.transaction.updateToOneRelation(this.transaction, this.obj, fieldName, null, this.requestScope);
        } else {
            this.transaction.updateToManyRelation(this.transaction, this.obj, fieldName, new LinkedHashSet<Object>(), Sets.newHashSet((Object[])new Object[]{removeResource.getObject()}), this.requestScope);
        }
    }

    public boolean relationshipAlreadyExists(String fieldName, PersistentResource toAdd) {
        Object relation = this.getValueUnchecked(fieldName);
        String toAddId = toAdd.getId();
        if (toAddId == null) {
            return false;
        }
        if (relation instanceof Collection) {
            return ((Collection)relation).stream().anyMatch(obj -> toAddId.equals(this.dictionary.getId(obj)));
        }
        return toAddId.equals(this.dictionary.getId(relation));
    }

    public void addRelation(String fieldName, PersistentResource newRelation) {
        if (!newRelation.isNewlyCreated() && this.relationshipAlreadyExists(fieldName, newRelation)) {
            return;
        }
        this.checkSharePermission(Collections.singleton(newRelation));
        Object relation = this.getValueUnchecked(fieldName);
        if (relation instanceof Collection) {
            if (this.addToCollection((Collection)relation, fieldName, newRelation)) {
                this.markDirty();
            }
            this.transaction.updateToManyRelation(this.transaction, this.obj, fieldName, Sets.newHashSet((Object[])new Object[]{newRelation.getObject()}), new LinkedHashSet<Object>(), this.requestScope);
            this.addInverseRelation(fieldName, newRelation.getObject());
        } else {
            this.updateRelation(fieldName, Collections.singleton(newRelation));
        }
    }

    protected void checkSharePermission(Set<PersistentResource> resourceIdentifiers) {
        if (resourceIdentifiers == null) {
            return;
        }
        Set<PersistentResource> newResources = this.getRequestScope().getNewPersistentResources();
        for (PersistentResource persistentResource : resourceIdentifiers) {
            if (newResources.contains(persistentResource) || this.lineage.getRecord(persistentResource.getType()).contains(persistentResource)) continue;
            PersistentResource.checkPermission(SharePermission.class, persistentResource);
        }
    }

    public void deleteResource() throws ForbiddenAccessException {
        PersistentResource.checkPermission(DeletePermission.class, this);
        Map<String, Relationship> relations = this.getRelationships();
        for (Map.Entry<String, Relationship> entry : relations.entrySet()) {
            String inverseRelationName;
            String relationName = entry.getKey();
            if (this.dictionary.cascadeDeletes(this.getResourceClass(), relationName) || CLASS_NO_FIELD.equals(inverseRelationName = this.dictionary.getRelationInverse(this.getResourceClass(), relationName))) continue;
            for (PersistentResource inverseResource : this.getRelationCheckedUnfiltered(relationName)) {
                if (!this.hasInverseRelation(relationName)) continue;
                this.deleteInverseRelation(relationName, inverseResource.getObject());
                inverseResource.markDirty();
            }
        }
        this.transaction.delete(this.getObject(), this.requestScope);
        this.auditClass(Audit.Action.DELETE, new ChangeSpec((com.yahoo.elide.security.PersistentResource)this, null, this.getObject(), null));
        this.requestScope.publishLifecycleEvent(this, CRUDEvent.CRUDAction.DELETE);
        this.requestScope.getDeletedResources().add(this);
    }

    public String getId() {
        return this.dictionary.getId(this.getObject());
    }

    public void setId(String id) {
        this.setValue(this.dictionary.getIdFieldName(this.getResourceClass()), id);
    }

    public boolean isIdGenerated() {
        return this.dictionary.getEntityBinding(this.getObject().getClass()).isIdGenerated();
    }

    public Optional<String> getUUID() {
        return this.uuid;
    }

    public PersistentResource getRelation(String relation, String id) {
        Set<PersistentResource> resources = this.getRelation(relation, Collections.singletonList(id), Optional.empty(), Optional.empty(), Optional.empty());
        if (resources.isEmpty()) {
            return null;
        }
        for (PersistentResource resource : resources) {
            if (!resource.matchesId(id)) continue;
            return resource;
        }
        return null;
    }

    public Set<PersistentResource> getRelation(String relation, List<String> ids, Optional<FilterExpression> filter, Optional<Sorting> sorting, Optional<Pagination> pagination) {
        FilterExpression filterExpression;
        Class<?> entityType = this.dictionary.getParameterizedType(this.getResourceClass(), relation);
        Set<Object> newResources = new LinkedHashSet();
        if (entityType == null) {
            throw new InvalidAttributeException(relation, this.type);
        }
        if (!ids.isEmpty()) {
            newResources = this.requestScope.getNewPersistentResources().stream().filter(resource -> entityType.isAssignableFrom(resource.getResourceClass()) && ids.contains(resource.getUUID().orElse(CLASS_NO_FIELD))).collect(Collectors.toSet());
            FilterExpression idExpression = PersistentResource.buildIdFilterExpression(ids, entityType, this.dictionary, this.requestScope);
            filterExpression = filter.map(fe -> new AndFilterExpression(idExpression, (FilterExpression)fe)).orElse(idExpression);
        } else {
            filterExpression = filter.orElse(null);
        }
        Set<PersistentResource> existingResources = PersistentResource.filter(ReadPermission.class, filter, this.getRelation(relation, Optional.ofNullable(filterExpression), sorting, pagination, true));
        Sets.SetView allResources = Sets.union(newResources, existingResources);
        Set allExpectedIds = allResources.stream().map(resource -> (String)resource.getUUID().orElseGet(resource::getId)).collect(Collectors.toSet());
        Sets.SetView missedIds = Sets.difference(new HashSet<String>(ids), allExpectedIds);
        if (!missedIds.isEmpty()) {
            throw new InvalidObjectIdentifierException(missedIds.toString(), relation);
        }
        return allResources;
    }

    private static FilterExpression buildIdFilterExpression(List<String> ids, Class<?> entityType, EntityDictionary dictionary, RequestScope scope) {
        Class<?> idType = dictionary.getIdType(entityType);
        String idField = dictionary.getIdFieldName(entityType);
        String typeAlias = dictionary.getJsonAliasFor(entityType);
        List<Object> coercedIds = ids.stream().filter(id -> scope.getObjectById(typeAlias, (String)id) == null).map(id -> CoerceUtil.coerce(id, idType)).collect(Collectors.toList());
        InPredicate idFilter = new InPredicate(new Path.PathElement(entityType, idType, idField), coercedIds);
        return idFilter;
    }

    public Set<PersistentResource> getRelationCheckedFiltered(String relationName, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination) {
        return PersistentResource.filter(ReadPermission.class, filterExpression, this.getRelation(relationName, filterExpression, sorting, pagination, true));
    }

    private Set<PersistentResource> getRelationUncheckedUnfiltered(String relationName) {
        return this.getRelation(relationName, Optional.empty(), Optional.empty(), Optional.empty(), false);
    }

    private Set<PersistentResource> getRelationCheckedUnfiltered(String relationName) {
        return this.getRelation(relationName, Optional.empty(), Optional.empty(), Optional.empty(), true);
    }

    private Set<PersistentResource> getRelation(String relationName, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, boolean checked) {
        if (checked && !this.checkRelation(relationName)) {
            return Collections.emptySet();
        }
        Class<?> relationClass = this.dictionary.getParameterizedType(this.obj, relationName);
        if (pagination.isPresent() && !pagination.get().isDefaultInstance() && !CanPaginateVisitor.canPaginate(relationClass, this.dictionary, this.requestScope)) {
            throw new BadRequestException(String.format("Cannot paginate %s", this.dictionary.getJsonAliasFor(relationClass)));
        }
        return this.getRelationUnchecked(relationName, filterExpression, sorting, pagination);
    }

    protected boolean checkRelation(String relationName) {
        List<String> relations = this.dictionary.getRelationships(this.obj);
        String realName = this.dictionary.getNameFromAlias(this.obj, relationName);
        String string = relationName = realName == null ? relationName : realName;
        if (relationName == null || relations == null || !relations.contains(relationName)) {
            throw new InvalidAttributeException(relationName, this.type);
        }
        this.checkFieldAwareDeferPermissions(ReadPermission.class, relationName, null, null);
        return !PersistentResource.shouldSkipCollection(this.dictionary.getParameterizedType(this.obj, relationName), ReadPermission.class, this.requestScope);
    }

    protected Set<PersistentResource> getRelationChecked(String relationName, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination) {
        if (!this.checkRelation(relationName)) {
            return Collections.emptySet();
        }
        return this.getRelationUnchecked(relationName, filterExpression, sorting, pagination);
    }

    private Set<PersistentResource> getRelationUnchecked(String relationName, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination) {
        RelationshipType type = this.getRelationshipType(relationName);
        Class<?> relationClass = this.dictionary.getParameterizedType(this.obj, relationName);
        if (relationClass == null) {
            throw new InvalidAttributeException(relationName, this.getType());
        }
        Optional<Pagination> computedPagination = pagination.map(p -> p.evaluate(relationClass));
        Optional<FilterExpression> permissionFilter = PersistentResource.getPermissionFilterExpression(relationClass, this.requestScope);
        Optional<FilterExpression> computedFilters = filterExpression;
        if (permissionFilter.isPresent() && filterExpression.isPresent()) {
            AndFilterExpression mergedExpression = new AndFilterExpression(filterExpression.get(), permissionFilter.get());
            computedFilters = Optional.of(mergedExpression);
        } else if (permissionFilter.isPresent()) {
            computedFilters = permissionFilter;
        }
        Object val = this.transaction.getRelation(this.transaction, this.obj, relationName, computedFilters, sorting, computedPagination, this.requestScope);
        if (val == null) {
            return Collections.emptySet();
        }
        AbstractSet resources = Sets.newLinkedHashSet();
        if (val instanceof Iterable) {
            Iterable filteredVal = (Iterable)val;
            resources = new PersistentResourceSet(this, filteredVal, this.requestScope);
        } else if (type.isToOne()) {
            resources = new SingleElementSet<PersistentResource<Object>>(new PersistentResource<Object>(val, this, this.requestScope.getUUIDFor(val), this.requestScope));
        } else {
            resources.add(new PersistentResource<Object>(val, this, this.requestScope.getUUIDFor(val), this.requestScope));
        }
        return resources;
    }

    private static boolean shouldSkipCollection(Class<?> resourceClass, Class<? extends Annotation> annotationClass, RequestScope requestScope) {
        try {
            requestScope.getPermissionExecutor().checkUserPermissions(resourceClass, annotationClass);
        }
        catch (ForbiddenAccessException e) {
            return true;
        }
        return false;
    }

    public RelationshipType getRelationshipType(String relation) {
        return this.dictionary.getRelationshipType(this.obj, relation);
    }

    public Object getAttribute(String attr) {
        return this.getValueChecked(attr);
    }

    public T getObject() {
        return this.obj;
    }

    public void setObject(T obj) {
        this.obj = obj;
    }

    @JsonIgnore
    public Class<T> getResourceClass() {
        return this.dictionary.lookupBoundClass(this.obj.getClass());
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            String id = this.dictionary.getId(this.getObject());
            this.hashCode = this.uuid.isPresent() && ("0".equals(id) || "null".equals(id)) ? Objects.hashCode(this.uuid) : Objects.hashCode(id);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PersistentResource) {
            PersistentResource that = (PersistentResource)obj;
            if (this.getObject() == that.getObject()) {
                return true;
            }
            String theirId = this.dictionary.getId(that.getObject());
            return this.matchesId(theirId) && Objects.equals(this.type, that.type);
        }
        return false;
    }

    public ResourceLineage getLineage() {
        return this.lineage;
    }

    public EntityDictionary getDictionary() {
        return this.dictionary;
    }

    public RequestScope getRequestScope() {
        return this.requestScope;
    }

    public Resource toResource() {
        return this.toResource(this::getRelationships, this::getAttributes);
    }

    public Resource toResourceWithSortingAndPagination() {
        return this.toResource(this::getRelationshipsWithSortingAndPagination, this::getAttributes);
    }

    public Resource toResource(Supplier<Map<String, Relationship>> relationshipSupplier, Supplier<Map<String, Object>> attributeSupplier) {
        Resource resource = new Resource(this.type, this.obj == null ? this.uuid.orElseThrow(() -> new InvalidEntityBodyException("No id found on object")) : this.dictionary.getId(this.obj));
        resource.setRelationships(relationshipSupplier.get());
        resource.setAttributes(attributeSupplier.get());
        return resource;
    }

    protected Map<String, Relationship> getRelationships() {
        return this.getRelationshipsWithRelationshipFunction(relationName -> {
            Optional<FilterExpression> filterExpression = this.requestScope.getExpressionForRelation(this, (String)relationName);
            return this.getRelationCheckedFiltered((String)relationName, filterExpression, Optional.empty(), Optional.empty());
        });
    }

    protected Map<String, Relationship> getRelationshipsWithSortingAndPagination() {
        return this.getRelationshipsWithRelationshipFunction(relationName -> {
            Optional<FilterExpression> filterExpression = this.requestScope.getExpressionForRelation(this, (String)relationName);
            Optional<Sorting> sorting = Optional.ofNullable(this.requestScope.getSorting());
            Optional<Pagination> pagination = Optional.ofNullable(this.requestScope.getPagination());
            return this.getRelationCheckedFiltered((String)relationName, filterExpression, sorting, pagination);
        });
    }

    protected Map<String, Relationship> getRelationshipsWithRelationshipFunction(Function<String, Set<PersistentResource>> relationshipFunction) {
        LinkedHashMap<String, Relationship> relationshipMap = new LinkedHashMap<String, Relationship>();
        Set<String> relationshipFields = this.filterFields(this.dictionary.getRelationships(this.obj));
        for (String field : relationshipFields) {
            TreeMap<String, Resource> orderedById = new TreeMap<String, Resource>(this.lengthFirstComparator);
            for (PersistentResource relationship : relationshipFunction.apply(field)) {
                orderedById.put(relationship.getId(), new ResourceIdentifier(relationship.getType(), relationship.getId()).castToResource());
            }
            Collection resources = orderedById.values();
            RelationshipType relationshipType = this.getRelationshipType(field);
            Data<Resource> data = relationshipType.isToOne() ? new Data(PersistentResource.firstOrNullIfEmpty(resources)) : new Data<Resource>(resources);
            relationshipMap.put(field, new Relationship(null, data));
        }
        return relationshipMap;
    }

    protected Map<String, Object> getAttributes() {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        Set<String> attrFields = this.filterFields(this.dictionary.getAttributes(this.obj));
        for (String field : attrFields) {
            Object val = this.getAttribute(field);
            attributes.put(field, val);
        }
        return attributes;
    }

    protected void setValueChecked(String fieldName, Object newValue) {
        Object existingValue = this.getValueUnchecked(fieldName);
        this.checkFieldAwareDeferPermissions(UpdatePermission.class, fieldName, newValue, existingValue);
        this.setValue(fieldName, newValue);
    }

    protected void nullValue(String fieldName, PersistentResource oldValue) {
        if (oldValue == null) {
            return;
        }
        String inverseField = this.getInverseRelationField(fieldName);
        if (!inverseField.isEmpty()) {
            oldValue.checkFieldAwareDeferPermissions(UpdatePermission.class, inverseField, null, this.getObject());
        }
        this.setValueChecked(fieldName, null);
    }

    protected Object getValueChecked(String fieldName) {
        this.requestScope.publishLifecycleEvent(this, CRUDEvent.CRUDAction.READ);
        this.requestScope.publishLifecycleEvent(this, fieldName, CRUDEvent.CRUDAction.READ, Optional.empty());
        this.checkFieldAwareDeferPermissions(ReadPermission.class, fieldName, null, null);
        return PersistentResource.getValue(this.getObject(), fieldName, this.requestScope);
    }

    protected Object getValueUnchecked(String fieldName) {
        this.requestScope.publishLifecycleEvent(this, CRUDEvent.CRUDAction.READ);
        this.requestScope.publishLifecycleEvent(this, fieldName, CRUDEvent.CRUDAction.READ, Optional.empty());
        return PersistentResource.getValue(this.getObject(), fieldName, this.requestScope);
    }

    protected boolean addToCollection(Collection collection, String collectionName, PersistentResource toAdd) {
        Set<T> singleton = Collections.singleton(toAdd.getObject());
        Collection original = this.copyCollection(collection);
        this.checkFieldAwareDeferPermissions(UpdatePermission.class, collectionName, CollectionUtils.union((Iterable)CollectionUtils.emptyIfNull((Collection)collection), singleton), original);
        if (collection == null) {
            collection = Collections.singleton(toAdd.getObject());
            Object value = this.getValueUnchecked(collectionName);
            if (!Objects.equals(value, toAdd.getObject())) {
                this.setValueChecked(collectionName, collection);
                return true;
            }
        } else if (!collection.contains(toAdd.getObject())) {
            collection.add(toAdd.getObject());
            this.triggerUpdate(collectionName, original, collection);
            return true;
        }
        return false;
    }

    protected void delFromCollection(Collection collection, String collectionName, PersistentResource toDelete, boolean isInverseCheck) {
        Collection original = this.copyCollection(collection);
        this.checkFieldAwareDeferPermissions(UpdatePermission.class, collectionName, CollectionUtils.disjunction((Iterable)collection, Collections.singleton(toDelete.getObject())), original);
        String inverseField = this.getInverseRelationField(collectionName);
        if (!isInverseCheck && !inverseField.isEmpty()) {
            Object originalValue = toDelete.getValueUnchecked(inverseField);
            Collection<Object> originalBidirectional = originalValue instanceof Collection ? this.copyCollection((Collection)originalValue) : Collections.singleton(originalValue);
            Collection removedBidrectional = CollectionUtils.disjunction(Collections.singleton(this.getObject()), originalBidirectional);
            toDelete.checkFieldAwareDeferPermissions(UpdatePermission.class, inverseField, removedBidrectional, originalBidirectional);
        }
        if (collection == null) {
            return;
        }
        collection.remove(toDelete.getObject());
        this.triggerUpdate(collectionName, original, collection);
    }

    protected void setValue(String fieldName, Object value) {
        Object original = this.getValueUnchecked(fieldName);
        this.dictionary.setValue(this.obj, fieldName, value);
        this.triggerUpdate(fieldName, original, value);
    }

    public static Object getValue(Object target, String fieldName, RequestScope requestScope) {
        EntityDictionary dictionary = requestScope.getDictionary();
        return dictionary.getValue(target, fieldName, requestScope);
    }

    protected void deleteInverseRelation(String relationName, Object inverseEntity) {
        String inverseField = this.getInverseRelationField(relationName);
        if (!CLASS_NO_FIELD.equals(inverseField)) {
            Class<T> inverseType = this.dictionary.getType(inverseEntity.getClass(), inverseField);
            String uuid = this.requestScope.getUUIDFor(inverseEntity);
            PersistentResource<Object> inverseResource = new PersistentResource<Object>(inverseEntity, this, uuid, this.requestScope);
            Object inverseRelation = inverseResource.getValueUnchecked(inverseField);
            if (inverseRelation == null) {
                return;
            }
            if (inverseRelation instanceof Collection) {
                inverseResource.delFromCollection((Collection)inverseRelation, inverseField, this, true);
            } else if (inverseType.isAssignableFrom(this.getResourceClass())) {
                inverseResource.nullValue(inverseField, this);
            } else {
                throw new InternalServerErrorException("Relationship type mismatch");
            }
            super.markDirty();
            RelationshipType inverseRelationType = inverseResource.getRelationshipType(inverseField);
            if (inverseRelationType.isToOne()) {
                this.transaction.updateToOneRelation(this.transaction, inverseEntity, inverseField, null, this.requestScope);
            } else {
                assert (inverseRelation instanceof Collection) : inverseField + " not a collection";
                this.transaction.updateToManyRelation(this.transaction, inverseEntity, inverseField, new LinkedHashSet<Object>(), Sets.newHashSet((Object[])new Object[]{this.obj}), this.requestScope);
            }
        }
    }

    private boolean hasInverseRelation(String relationName) {
        String inverseField = this.getInverseRelationField(relationName);
        return StringUtils.isNotEmpty((CharSequence)inverseField);
    }

    private String getInverseRelationField(String relationName) {
        return this.dictionary.getRelationInverse(this.obj.getClass(), relationName);
    }

    protected void addInverseRelation(String relationName, Object inverseObj) {
        String inverseName = this.dictionary.getRelationInverse(this.obj.getClass(), relationName);
        if (!CLASS_NO_FIELD.equals(inverseName)) {
            Class<T> inverseType = this.dictionary.getType(inverseObj.getClass(), inverseName);
            String uuid = this.requestScope.getUUIDFor(inverseObj);
            PersistentResource<Object> inverseResource = new PersistentResource<Object>(inverseObj, this, uuid, this.requestScope);
            Object inverseRelation = inverseResource.getValueUnchecked(inverseName);
            if (Collection.class.isAssignableFrom(inverseType)) {
                if (inverseRelation != null) {
                    inverseResource.addToCollection((Collection)inverseRelation, inverseName, this);
                } else {
                    inverseResource.setValueChecked(inverseName, Collections.singleton(this.getObject()));
                }
            } else if (inverseType.isAssignableFrom(this.getResourceClass())) {
                inverseResource.setValueChecked(inverseName, this.getObject());
            } else {
                throw new InternalServerErrorException("Relationship type mismatch");
            }
            super.markDirty();
            RelationshipType inverseRelationType = inverseResource.getRelationshipType(inverseName);
            if (inverseRelationType.isToOne()) {
                this.transaction.updateToOneRelation(this.transaction, inverseObj, inverseName, this.obj, this.requestScope);
            } else {
                assert (inverseRelation == null || inverseRelation instanceof Collection) : inverseName + " not a collection";
                this.transaction.updateToManyRelation(this.transaction, inverseObj, inverseName, Sets.newHashSet((Object[])new Object[]{this.obj}), new LinkedHashSet<Object>(), this.requestScope);
            }
        }
    }

    protected static Set<PersistentResource> filter(Class<? extends Annotation> permission, Optional<FilterExpression> filter, Set<PersistentResource> resources) {
        LinkedHashSet<PersistentResource> filteredSet = new LinkedHashSet<PersistentResource>();
        for (PersistentResource resource : resources) {
            try {
                if (!resource.getRequestScope().getNewResources().contains(resource)) {
                    resource.checkFieldAwarePermissions(permission);
                    if (filter.isPresent() && !filter.get().accept(new VerifyFieldAccessFilterExpressionVisitor(resource)).booleanValue()) continue;
                }
                filteredSet.add(resource);
            }
            catch (ForbiddenAccessException forbiddenAccessException) {}
        }
        if (resources instanceof SingleElementSet && resources.equals(filteredSet)) {
            return resources;
        }
        return filteredSet;
    }

    protected Set<String> filterFields(Collection<String> fields) {
        LinkedHashSet<String> filteredSet = new LinkedHashSet<String>();
        for (String field : fields) {
            try {
                if (!PersistentResource.checkIncludeSparseField(this.requestScope.getSparseFields(), this.type, field)) continue;
                this.checkFieldAwareReadPermissions(field);
                filteredSet.add(field);
            }
            catch (ForbiddenAccessException forbiddenAccessException) {}
        }
        return filteredSet;
    }

    private void triggerUpdate(String fieldName, Object original, Object value) {
        ChangeSpec changeSpec = new ChangeSpec((com.yahoo.elide.security.PersistentResource)this, fieldName, original, value);
        CRUDEvent.CRUDAction action = this.isNewlyCreated() ? CRUDEvent.CRUDAction.CREATE : CRUDEvent.CRUDAction.UPDATE;
        this.requestScope.publishLifecycleEvent(this, fieldName, action, Optional.of(changeSpec));
        this.requestScope.publishLifecycleEvent(this, action);
        this.auditField(new ChangeSpec((com.yahoo.elide.security.PersistentResource)this, fieldName, original, value));
    }

    private static <A extends Annotation> ExpressionResult checkPermission(Class<A> annotationClass, PersistentResource resource) {
        return resource.requestScope.getPermissionExecutor().checkPermission(annotationClass, resource);
    }

    private <A extends Annotation> ExpressionResult checkFieldAwarePermissions(Class<A> annotationClass) {
        return this.requestScope.getPermissionExecutor().checkPermission(annotationClass, this);
    }

    private <A extends Annotation> ExpressionResult checkFieldAwareReadPermissions(String fieldName) {
        return this.requestScope.getPermissionExecutor().checkSpecificFieldPermissions(this, null, ReadPermission.class, fieldName);
    }

    private <A extends Annotation> ExpressionResult checkFieldAwareDeferPermissions(Class<A> annotationClass, String fieldName, Object modified, Object original) {
        ChangeSpec changeSpec = UpdatePermission.class.isAssignableFrom(annotationClass) ? new ChangeSpec((com.yahoo.elide.security.PersistentResource)this, fieldName, original, modified) : null;
        return this.requestScope.getPermissionExecutor().checkSpecificFieldPermissionsDeferred(this, changeSpec, annotationClass, fieldName);
    }

    protected static boolean checkIncludeSparseField(Map<String, Set<String>> sparseFields, String type, String fieldName) {
        if (!sparseFields.isEmpty()) {
            if (!sparseFields.containsKey(type)) {
                return false;
            }
            if (!sparseFields.get(type).contains(fieldName)) {
                return false;
            }
        }
        return true;
    }

    protected void auditField(ChangeSpec changeSpec) {
        String fieldName = changeSpec.getFieldName();
        Audit[] annotations = (Audit[])this.dictionary.getAttributeOrRelationAnnotations(this.getResourceClass(), Audit.class, fieldName);
        if (annotations == null || annotations.length == 0) {
            this.auditClass(Audit.Action.UPDATE, changeSpec);
            return;
        }
        for (Audit annotation : annotations) {
            if (annotation.action().length != 1 || annotation.action()[0] != Audit.Action.UPDATE) {
                throw new InvalidSyntaxException("Only Audit.Action.UPDATE is allowed on fields.");
            }
            LogMessage message = new LogMessage(annotation, this, Optional.of(changeSpec));
            this.getRequestScope().getAuditLogger().log(message);
        }
    }

    protected void auditClass(Audit.Action action, ChangeSpec changeSpec) {
        Audit[] annotations = (Audit[])this.getResourceClass().getAnnotationsByType(Audit.class);
        if (annotations == null) {
            return;
        }
        for (Audit annotation : annotations) {
            for (Audit.Action auditAction : annotation.action()) {
                if (auditAction != action) continue;
                LogMessage message = new LogMessage(annotation, this, Optional.ofNullable(changeSpec));
                this.getRequestScope().getAuditLogger().log(message);
            }
        }
    }

    private Collection copyCollection(Collection collection) {
        ArrayList newCollection = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return newCollection;
        }
        collection.iterator().forEachRemaining(newCollection::add);
        return newCollection;
    }

    private void markDirty() {
        this.requestScope.getDirtyResources().add(this);
    }

    private static void assignId(PersistentResource persistentResource, String id) {
        if (!persistentResource.isIdGenerated()) {
            if (StringUtils.isNotEmpty((CharSequence)id)) {
                persistentResource.setId(id);
            } else {
                throw new InvalidValueException(persistentResource.toResource(), "No id provided, cannot persist " + persistentResource.getObject());
            }
        }
    }

    private static <T> T firstOrNullIfEmpty(Collection<T> coll) {
        return (T)(CollectionUtils.isEmpty(coll) ? null : IterableUtils.first(coll));
    }
}

