/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.datastore.inmemory;

import com.google.common.collect.Sets;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.core.DataStore;
import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.datastore.inmemory.HashMapStoreTransaction;
import com.yahoo.elide.core.datastore.test.DataStoreTestHarness;
import com.yahoo.elide.utils.ClassScanner;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class HashMapDataStore
implements DataStore,
DataStoreTestHarness {
    private final Map<Class<?>, Map<String, Object>> dataStore = Collections.synchronizedMap(new HashMap());
    private EntityDictionary dictionary;
    private final Set<Package> beanPackages;
    private final ConcurrentHashMap<Class<?>, AtomicLong> typeIds = new ConcurrentHashMap();

    public HashMapDataStore(Package beanPackage) {
        this(Sets.newHashSet((Object[])new Package[]{beanPackage}));
    }

    public HashMapDataStore(Set<Package> beanPackages) {
        this.beanPackages = beanPackages;
        for (Package beanPackage : beanPackages) {
            ClassScanner.getAnnotatedClasses(beanPackage, Include.class).stream().filter(modelClass -> modelClass.getName().startsWith(beanPackage.getName())).forEach(modelClass -> this.dataStore.put((Class<?>)modelClass, Collections.synchronizedMap(new LinkedHashMap())));
        }
    }

    @Override
    public void populateEntityDictionary(EntityDictionary dictionary) {
        for (Class<?> clazz : this.dataStore.keySet()) {
            dictionary.bindEntity(clazz);
        }
        this.dictionary = dictionary;
    }

    @Override
    public DataStoreTransaction beginTransaction() {
        return new HashMapStoreTransaction(this.dataStore, this.dictionary, this.typeIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Data store contents ");
        for (Class<?> cls : this.dataStore.keySet()) {
            sb.append("\n Table ").append(cls).append(" contents \n");
            Map<String, Object> data = this.dataStore.get(cls);
            for (Map.Entry<String, Object> e : data.entrySet()) {
                sb.append(" Id: ").append(e.getKey()).append(" Value: ").append(e.getValue());
            }
        }
        return sb.toString();
    }

    @Override
    public DataStore getDataStore() {
        return this;
    }

    @Override
    public void cleanseTestData() {
        for (Map<String, Object> objects : this.dataStore.values()) {
            objects.clear();
        }
        this.typeIds.clear();
    }

    public EntityDictionary getDictionary() {
        return this.dictionary;
    }

    public Set<Package> getBeanPackages() {
        return this.beanPackages;
    }

    public ConcurrentHashMap<Class<?>, AtomicLong> getTypeIds() {
        return this.typeIds;
    }
}

