/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.exceptions;

import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.security.permissions.expressions.Expression;
import java.util.Optional;

public class ForbiddenAccessException
extends HttpStatusException {
    private static final long serialVersionUID = 1L;
    private final Optional<Expression> expression;
    private final Optional<Expression.EvaluationMode> evaluationMode;

    public ForbiddenAccessException(String message) {
        this(message, null, null);
    }

    public ForbiddenAccessException(String message, Expression expression, Expression.EvaluationMode mode) {
        super(403, null, null, () -> message + ": " + expression);
        this.expression = Optional.ofNullable(expression);
        this.evaluationMode = Optional.ofNullable(mode);
    }

    public String getLoggedMessage() {
        return String.format("ForbiddenAccessException: Message=%s\tMode=%s\tExpression=[%s]", this.getVerboseMessage(), this.getEvaluationMode(), this.getExpression());
    }

    public Optional<Expression> getExpression() {
        return this.expression;
    }

    public Optional<Expression.EvaluationMode> getEvaluationMode() {
        return this.evaluationMode;
    }
}

