/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter.dialect;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.filter.dialect.JoinFilterDialect;
import com.yahoo.elide.core.filter.dialect.ParseException;
import com.yahoo.elide.core.filter.dialect.SubqueryFilterDialect;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.parsers.JsonApiParser;
import com.yahoo.elide.utils.coerce.CoerceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedMap;

public class DefaultFilterDialect
implements JoinFilterDialect,
SubqueryFilterDialect {
    private final EntityDictionary dictionary;

    public DefaultFilterDialect(EntityDictionary dictionary) {
        this.dictionary = dictionary;
    }

    private List<FilterPredicate> extractPredicates(MultivaluedMap<String, String> queryParams) throws ParseException {
        ArrayList<FilterPredicate> filterPredicates = new ArrayList<FilterPredicate>();
        Pattern pattern = Pattern.compile("filter\\[([^\\]]+)\\](\\[([^\\]]+)\\])?");
        for (Map.Entry entry : queryParams.entrySet()) {
            String paramName = (String)entry.getKey();
            List paramValues = (List)entry.getValue();
            Matcher matcher = pattern.matcher(paramName);
            if (!matcher.find()) {
                throw new ParseException("Invalid filter format: " + paramName);
            }
            String[] keyParts = matcher.group(1).split("\\.");
            if (keyParts.length < 2) {
                throw new ParseException("Invalid filter format: " + paramName);
            }
            Operator operator = matcher.group(3) == null ? Operator.IN : Operator.fromString(matcher.group(3));
            Path path = this.getPath(keyParts);
            List<Path.PathElement> elements = path.getPathElements();
            Path.PathElement last = elements.get(elements.size() - 1);
            ArrayList<Object> values = new ArrayList<Object>();
            if (operator.isParameterized()) {
                for (String valueParams : paramValues) {
                    for (String valueParam : valueParams.split(",")) {
                        values.add(CoerceUtil.coerce(valueParam, last.getFieldType()));
                    }
                }
            }
            FilterPredicate filterPredicate = new FilterPredicate(path, operator, values);
            filterPredicates.add(filterPredicate);
        }
        return filterPredicates;
    }

    @Override
    public FilterExpression parseGlobalExpression(String path, MultivaluedMap<String, String> filterParams) throws ParseException {
        List<FilterPredicate> filterPredicates = this.extractPredicates(filterParams);
        String normalizedPath = JsonApiParser.normalizePath(path);
        String[] pathComponents = normalizedPath.split("/");
        String firstPathComponent = "";
        if (pathComponents.length > 0) {
            firstPathComponent = pathComponents[0];
        }
        FilterExpression joinedExpression = null;
        for (FilterPredicate filterPredicate : filterPredicates) {
            Class firstClass = filterPredicate.getPath().getPathElements().get(0).getType();
            if (!this.dictionary.getJsonAliasFor(firstClass).equals(firstPathComponent)) {
                throw new ParseException(String.format("Invalid predicate: %s", filterPredicate));
            }
            if ((filterPredicate.getOperator().equals((Object)Operator.HASMEMBER) || filterPredicate.getOperator().equals((Object)Operator.HASNOMEMBER)) && !FilterPredicate.isLastPathElementAssignableFrom(this.dictionary, filterPredicate.getPath(), Collection.class)) {
                throw new ParseException("Invalid Path: Last Path Element has to be a collection type");
            }
            if (joinedExpression == null) {
                joinedExpression = filterPredicate;
                continue;
            }
            joinedExpression = new AndFilterExpression(joinedExpression, filterPredicate);
        }
        return joinedExpression;
    }

    @Override
    public Map<String, FilterExpression> parseTypedExpression(String path, MultivaluedMap<String, String> filterParams) throws ParseException {
        HashMap<String, FilterExpression> expressionMap = new HashMap<String, FilterExpression>();
        List<FilterPredicate> filterPredicates = this.extractPredicates(filterParams);
        for (FilterPredicate filterPredicate : filterPredicates) {
            this.validateFilterPredicate(filterPredicate);
            String entityType = this.dictionary.getJsonAliasFor(filterPredicate.getEntityType());
            FilterExpression filterExpression = (FilterExpression)expressionMap.get(entityType);
            if (filterExpression != null) {
                expressionMap.put(entityType, new AndFilterExpression(filterExpression, filterPredicate));
                continue;
            }
            expressionMap.put(entityType, filterPredicate);
        }
        return expressionMap;
    }

    private Path getPath(String[] keyParts) throws ParseException {
        int i;
        if (keyParts == null || keyParts.length <= 0) {
            throw new ParseException("Invalid filter expression");
        }
        ArrayList<Path.PathElement> path = new ArrayList<Path.PathElement>();
        Class[] types = new Class[keyParts.length];
        String type = keyParts[0];
        types[0] = this.dictionary.getEntityClass(type);
        if (types[0] == null) {
            throw new ParseException("Unknown entity in filter: " + type);
        }
        for (i = 1; i < keyParts.length; ++i) {
            Class<?> fieldType;
            String field = keyParts[i];
            Class entityClass = types[i - 1];
            Class<?> clazz = fieldType = "id".equals(field.toLowerCase(Locale.ENGLISH)) ? this.dictionary.getIdType(entityClass) : this.dictionary.getParameterizedType(entityClass, field);
            if (fieldType == null) {
                throw new ParseException("Unknown field in filter: " + field);
            }
            types[i] = fieldType;
        }
        for (i = 0; i < types.length - 1; ++i) {
            Class typeClass = types[i];
            String fieldName = keyParts[i + 1];
            Class fieldClass = types[i + 1];
            Path.PathElement pathElement = new Path.PathElement(typeClass, fieldClass, fieldName);
            path.add(pathElement);
        }
        return new Path(path);
    }

    private void validateFilterPredicate(FilterPredicate filterPredicate) throws ParseException {
        switch (filterPredicate.getOperator()) {
            case ISEMPTY: 
            case NOTEMPTY: {
                this.emptyOperatorConditions(filterPredicate);
                break;
            }
            case HASMEMBER: 
            case HASNOMEMBER: {
                this.memberOfOperatorConditions(filterPredicate);
                break;
            }
            default: {
                if (!FilterPredicate.toManyInPath(this.dictionary, filterPredicate.getPath())) break;
                throw new ParseException("Invalid toMany join: " + filterPredicate);
            }
        }
    }

    private void emptyOperatorConditions(FilterPredicate filterPredicate) throws ParseException {
        if (FilterPredicate.toManyInPathExceptLastPathElement(this.dictionary, filterPredicate.getPath())) {
            throw new ParseException("Invalid toMany join. toMany association has to be the target collection." + filterPredicate);
        }
    }

    private void memberOfOperatorConditions(FilterPredicate filterPredicate) throws ParseException {
        if (FilterPredicate.toManyInPath(this.dictionary, filterPredicate.getPath())) {
            throw new ParseException("Invalid toMany join: member of operator cannot be used for toMany relationships");
        }
        if (!FilterPredicate.isLastPathElementAssignableFrom(this.dictionary, filterPredicate.getPath(), Collection.class)) {
            throw new ParseException("Invalid Path: Last Path Element has to be a collection type");
        }
    }
}

