/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter.dialect;

import com.google.common.collect.ImmutableMap;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.InPredicate;
import com.yahoo.elide.core.filter.IsEmptyPredicate;
import com.yahoo.elide.core.filter.IsNullPredicate;
import com.yahoo.elide.core.filter.NotEmptyPredicate;
import com.yahoo.elide.core.filter.NotNullPredicate;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.filter.dialect.CaseSensitivityStrategy;
import com.yahoo.elide.core.filter.dialect.JoinFilterDialect;
import com.yahoo.elide.core.filter.dialect.ParseException;
import com.yahoo.elide.core.filter.dialect.SubqueryFilterDialect;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.parsers.JsonApiParser;
import com.yahoo.elide.utils.TypeHelper;
import com.yahoo.elide.utils.coerce.CoerceUtil;
import cz.jirutka.rsql.parser.RSQLParser;
import cz.jirutka.rsql.parser.RSQLParserException;
import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLOperators;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.collections4.CollectionUtils;

public class RSQLFilterDialect
implements SubqueryFilterDialect,
JoinFilterDialect {
    private static final String SINGLE_PARAMETER_ONLY = "There can only be a single filter query parameter";
    private static final String INVALID_QUERY_PARAMETER = "Invalid query parameter: ";
    private static final Pattern TYPED_FILTER_PATTERN = Pattern.compile("filter\\[([^\\]]+)\\]");
    private static final ComparisonOperator ISNULL_OP = new ComparisonOperator("=isnull=", false);
    private static final ComparisonOperator ISEMPTY_OP = new ComparisonOperator("=isempty=", false);
    private static final ComparisonOperator HASMEMBER_OP = new ComparisonOperator("=hasmember=", false);
    private static final ComparisonOperator HASNOMEMBER_OP = new ComparisonOperator("=hasnomember=", false);
    private static final Map<ComparisonOperator, Operator> OPERATOR_MAP = ImmutableMap.builder().put((Object)RSQLOperators.LESS_THAN, (Object)Operator.LT).put((Object)RSQLOperators.GREATER_THAN, (Object)Operator.GT).put((Object)RSQLOperators.GREATER_THAN_OR_EQUAL, (Object)Operator.GE).put((Object)RSQLOperators.LESS_THAN_OR_EQUAL, (Object)Operator.LE).put((Object)HASMEMBER_OP, (Object)Operator.HASMEMBER).put((Object)HASNOMEMBER_OP, (Object)Operator.HASNOMEMBER).build();
    private final RSQLParser parser = new RSQLParser(RSQLFilterDialect.getDefaultOperatorsWithIsnull());
    private final EntityDictionary dictionary;
    private final CaseSensitivityStrategy caseSensitivityStrategy;

    public RSQLFilterDialect(EntityDictionary dictionary) {
        this(dictionary, new CaseSensitivityStrategy.FIQLCompliant());
    }

    public RSQLFilterDialect(EntityDictionary dictionary, CaseSensitivityStrategy caseSensitivityStrategy) {
        this.dictionary = dictionary;
        this.caseSensitivityStrategy = caseSensitivityStrategy;
    }

    private static Set<ComparisonOperator> getDefaultOperatorsWithIsnull() {
        Set operators = RSQLOperators.defaultOperators();
        operators.add(ISNULL_OP);
        operators.add(ISEMPTY_OP);
        operators.add(HASMEMBER_OP);
        operators.add(HASNOMEMBER_OP);
        return operators;
    }

    @Override
    public FilterExpression parseGlobalExpression(String path, MultivaluedMap<String, String> filterParams) throws ParseException {
        if (filterParams.size() != 1) {
            throw new ParseException(SINGLE_PARAMETER_ONLY);
        }
        Map.Entry entry = CollectionUtils.get(filterParams, (int)0);
        String queryParamName = (String)entry.getKey();
        if (!"filter".equals(queryParamName)) {
            throw new ParseException(INVALID_QUERY_PARAMETER + queryParamName);
        }
        List queryParamValues = (List)entry.getValue();
        if (queryParamValues.size() != 1) {
            throw new ParseException(SINGLE_PARAMETER_ONLY);
        }
        String queryParamValue = (String)queryParamValues.get(0);
        String normalizedPath = JsonApiParser.normalizePath(path);
        String[] pathComponents = normalizedPath.split("/");
        String lastPathComponent = pathComponents.length > 0 ? pathComponents[pathComponents.length - 1] : "";
        Class<?> entityType = this.dictionary.getEntityClass(lastPathComponent);
        if (entityType == null) {
            throw new ParseException("No such collection: " + lastPathComponent);
        }
        return this.parseFilterExpression(queryParamValue, entityType, true);
    }

    @Override
    public Map<String, FilterExpression> parseTypedExpression(String path, MultivaluedMap<String, String> filterParams) throws ParseException {
        HashMap<String, FilterExpression> expressionByType = new HashMap<String, FilterExpression>();
        for (Map.Entry entry : filterParams.entrySet()) {
            String paramName = (String)entry.getKey();
            List paramValues = (List)entry.getValue();
            Matcher matcher = TYPED_FILTER_PATTERN.matcher(paramName);
            if (matcher.find()) {
                String typeName = matcher.group(1);
                if (paramValues.size() != 1) {
                    throw new ParseException("Exactly one RSQL expression must be defined for type : " + typeName);
                }
                Class<?> entityType = this.dictionary.getEntityClass(typeName);
                if (entityType == null) {
                    throw new ParseException(INVALID_QUERY_PARAMETER + paramName);
                }
                String expressionText = (String)paramValues.get(0);
                FilterExpression filterExpression = this.parseFilterExpression(expressionText, entityType, false);
                expressionByType.put(typeName, filterExpression);
                continue;
            }
            throw new ParseException(INVALID_QUERY_PARAMETER + paramName);
        }
        return expressionByType;
    }

    public FilterExpression parseFilterExpression(String expressionText, Class<?> entityType, boolean allowNestedToManyAssociations) throws ParseException {
        try {
            Node ast = this.parser.parse(expressionText);
            RSQL2FilterExpressionVisitor visitor = new RSQL2FilterExpressionVisitor(allowNestedToManyAssociations);
            return (FilterExpression)ast.accept((RSQLVisitor)visitor, entityType);
        }
        catch (RSQLParserException e) {
            throw new ParseException(e.getMessage());
        }
    }

    public class RSQL2FilterExpressionVisitor
    implements RSQLVisitor<FilterExpression, Class> {
        private boolean allowNestedToManyAssociations = false;

        public RSQL2FilterExpressionVisitor(boolean allowNestedToManyAssociations) {
            this.allowNestedToManyAssociations = allowNestedToManyAssociations;
        }

        private Path buildPath(Class rootEntityType, String selector) {
            String[] associationNames = selector.split("\\.");
            ArrayList<Path.PathElement> path = new ArrayList<Path.PathElement>();
            Class<?> entityType = rootEntityType;
            for (String associationName : associationNames) {
                if (associationName.equals("id")) {
                    associationName = RSQLFilterDialect.this.dictionary.getIdFieldName(entityType);
                }
                String typeName = RSQLFilterDialect.this.dictionary.getJsonAliasFor(entityType);
                Class<?> fieldType = RSQLFilterDialect.this.dictionary.getParameterizedType(entityType, associationName);
                if (fieldType == null) {
                    throw new RSQLParseException(String.format("No such association %s for type %s", associationName, typeName));
                }
                path.add(new Path.PathElement(entityType, fieldType, associationName));
                entityType = fieldType;
            }
            return new Path(path);
        }

        public FilterExpression visit(AndNode node, Class entityType) {
            List children = node.getChildren();
            if (children.size() < 2) {
                throw new RSQLParseException("Logical AND requires two arguments");
            }
            FilterExpression left = (FilterExpression)((Node)children.get(0)).accept((RSQLVisitor)this, (Object)entityType);
            FilterExpression right = (FilterExpression)((Node)children.get(1)).accept((RSQLVisitor)this, (Object)entityType);
            AndFilterExpression andFilterExpression = new AndFilterExpression(left, right);
            for (int idx = 2; idx < children.size(); ++idx) {
                right = (FilterExpression)((Node)children.get(idx)).accept((RSQLVisitor)this, (Object)entityType);
                andFilterExpression = new AndFilterExpression(andFilterExpression, right);
            }
            return andFilterExpression;
        }

        public FilterExpression visit(OrNode node, Class entityType) {
            List children = node.getChildren();
            if (children.size() < 2) {
                throw new RSQLParseException("Logical OR requires two arguments");
            }
            FilterExpression left = (FilterExpression)((Node)children.get(0)).accept((RSQLVisitor)this, (Object)entityType);
            FilterExpression right = (FilterExpression)((Node)children.get(1)).accept((RSQLVisitor)this, (Object)entityType);
            OrFilterExpression orFilterExpression = new OrFilterExpression(left, right);
            for (int idx = 2; idx < children.size(); ++idx) {
                right = (FilterExpression)((Node)children.get(idx)).accept((RSQLVisitor)this, (Object)entityType);
                orFilterExpression = new OrFilterExpression(orFilterExpression, right);
            }
            return orFilterExpression;
        }

        public FilterExpression visit(ComparisonNode node, Class entityType) {
            ComparisonOperator op = node.getOperator();
            String relationship = node.getSelector();
            List arguments = node.getArguments();
            Path path = this.buildPath(entityType, relationship);
            if (op.equals((Object)ISEMPTY_OP)) {
                if (FilterPredicate.toManyInPathExceptLastPathElement(RSQLFilterDialect.this.dictionary, path) && !this.allowNestedToManyAssociations) {
                    throw new RSQLParseException(String.format("Invalid association %s. toMany association has to be the target collection.", relationship));
                }
                return this.buildIsEmptyOperator(path, arguments);
            }
            if (op.equals((Object)HASMEMBER_OP) || op.equals((Object)HASNOMEMBER_OP)) {
                if (FilterPredicate.toManyInPath(RSQLFilterDialect.this.dictionary, path)) {
                    throw new RSQLParseException("Invalid toMany join: member of operator cannot be used for toMany relationships");
                }
                if (!FilterPredicate.isLastPathElementAssignableFrom(RSQLFilterDialect.this.dictionary, path, Collection.class)) {
                    throw new RSQLParseException("Invalid Path: Last Path Element has to be a collection type");
                }
            }
            if (FilterPredicate.toManyInPath(RSQLFilterDialect.this.dictionary, path) && !this.allowNestedToManyAssociations) {
                throw new RSQLParseException(String.format("Invalid association %s", relationship));
            }
            if (op.equals((Object)ISNULL_OP)) {
                return this.buildIsNullOperator(path, arguments);
            }
            Class relationshipType = path.lastElement().map(Path.PathElement::getFieldType).orElseThrow(() -> new IllegalStateException("Path must not be empty"));
            List<Object> values = arguments.stream().map(argument -> TypeHelper.isPrimitiveNumberType(relationshipType) || Number.class.isAssignableFrom(relationshipType) ? argument.replace("*", "") : argument).map(argument -> CoerceUtil.coerce(argument, relationshipType)).collect(Collectors.toList());
            if (op.equals((Object)RSQLOperators.EQUAL) || op.equals((Object)RSQLOperators.IN)) {
                return this.equalityExpression((String)arguments.get(0), path, values);
            }
            if (op.equals((Object)RSQLOperators.NOT_EQUAL) || op.equals((Object)RSQLOperators.NOT_IN)) {
                return new NotFilterExpression(this.equalityExpression((String)arguments.get(0), path, values));
            }
            if (OPERATOR_MAP.containsKey(op)) {
                return new FilterPredicate(path, (Operator)((Object)OPERATOR_MAP.get(op)), values);
            }
            throw new RSQLParseException(String.format("Invalid Operator %s", op.getSymbol()));
        }

        private FilterExpression equalityExpression(String argument, Path path, List<Object> values) {
            boolean startsWith = argument.startsWith("*");
            boolean endsWith = argument.endsWith("*");
            if (startsWith && endsWith && argument.length() > 2) {
                String value = argument.substring(1, argument.length() - 1);
                return new FilterPredicate(path, RSQLFilterDialect.this.caseSensitivityStrategy.mapOperator(Operator.INFIX), Collections.singletonList(value));
            }
            if (startsWith && argument.length() > 1) {
                String value = argument.substring(1, argument.length());
                return new FilterPredicate(path, RSQLFilterDialect.this.caseSensitivityStrategy.mapOperator(Operator.POSTFIX), Collections.singletonList(value));
            }
            if (endsWith && argument.length() > 1) {
                String value = argument.substring(0, argument.length() - 1);
                return new FilterPredicate(path, RSQLFilterDialect.this.caseSensitivityStrategy.mapOperator(Operator.PREFIX), Collections.singletonList(value));
            }
            Boolean isStringLike = path.lastElement().map(e -> e.getFieldType().isAssignableFrom(String.class)).orElse(false);
            if (isStringLike.booleanValue()) {
                return new FilterPredicate(path, RSQLFilterDialect.this.caseSensitivityStrategy.mapOperator(Operator.IN), values);
            }
            return new InPredicate(path, values);
        }

        private FilterExpression buildIsNullOperator(Path path, List<String> arguments) {
            String arg = arguments.get(0);
            try {
                boolean wantsNull = CoerceUtil.coerce(arg, Boolean.TYPE);
                if (wantsNull) {
                    return new IsNullPredicate(path);
                }
                return new NotNullPredicate(path);
            }
            catch (InvalidValueException ignored) {
                throw new RSQLParseException(String.format("Invalid value for operator =isnull= '%s'", arg));
            }
        }

        private FilterExpression buildIsEmptyOperator(Path path, List<String> arguments) {
            String arg = arguments.get(0);
            try {
                boolean wantsEmpty = CoerceUtil.coerce(arg, Boolean.TYPE);
                if (wantsEmpty) {
                    return new IsEmptyPredicate(path);
                }
                return new NotEmptyPredicate(path);
            }
            catch (InvalidValueException ignored) {
                throw new RSQLParseException(String.format("Invalid value for operator =isempty= '%s'", arg));
            }
        }
    }

    public static class RSQLParseException
    extends RSQLParserException {
        private String message;

        RSQLParseException(String message) {
            super(null);
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

