/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter.expression;

import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import java.util.Collection;
import java.util.HashSet;

public class PredicateExtractionVisitor
implements FilterExpressionVisitor<Collection<FilterPredicate>> {
    Collection<FilterPredicate> filterPredicates;

    public PredicateExtractionVisitor() {
        this.filterPredicates = new HashSet<FilterPredicate>();
    }

    public PredicateExtractionVisitor(Collection<FilterPredicate> predicates) {
        this.filterPredicates = predicates;
    }

    @Override
    public Collection<FilterPredicate> visitPredicate(FilterPredicate filterPredicate) {
        this.filterPredicates.add(filterPredicate);
        return this.filterPredicates;
    }

    @Override
    public Collection<FilterPredicate> visitAndExpression(AndFilterExpression expression) {
        expression.getLeft().accept(this);
        expression.getRight().accept(this);
        return this.filterPredicates;
    }

    @Override
    public Collection<FilterPredicate> visitOrExpression(OrFilterExpression expression) {
        expression.getLeft().accept(this);
        expression.getRight().accept(this);
        return this.filterPredicates;
    }

    @Override
    public Collection<FilterPredicate> visitNotExpression(NotFilterExpression expression) {
        expression.getNegated().accept(this);
        return this.filterPredicates;
    }

    public Collection<FilterPredicate> getFilterPredicates() {
        return this.filterPredicates;
    }
}

