/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.pagination;

import com.google.common.collect.ImmutableMap;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.annotation.Paginate;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;

public class Pagination {
    public static final int DEFAULT_OFFSET = 0;
    public static final int DEFAULT_PAGE_LIMIT = 500;
    public static final int MAX_PAGE_LIMIT = 10000;
    public static final String PAGE_NUMBER_KEY = "page[number]";
    public static final String PAGE_SIZE_KEY = "page[size]";
    public static final String PAGE_OFFSET_KEY = "page[offset]";
    public static final String PAGE_LIMIT_KEY = "page[limit]";
    public static final String PAGE_TOTALS_KEY = "page[totals]";
    public static final Map<String, PaginationKey> PAGE_KEYS = new HashMap<String, PaginationKey>();
    private long pageTotals = 0L;
    private static final String PAGE_KEYS_CSV;
    private Map<PaginationKey, Integer> pageData;
    private int offset;
    private int limit;
    private boolean generateTotals;
    private final int defaultMaxPageSize;
    private final int defaultPageSize;

    private Pagination(Map<PaginationKey, Integer> pageData, int defaultMaxPageSize, int defaultPageSize) {
        this.pageData = pageData;
        this.defaultMaxPageSize = defaultMaxPageSize;
        this.defaultPageSize = defaultPageSize;
    }

    public static Pagination fromOffsetAndLimit(int limit, int offset, boolean generatePageTotals) {
        ImmutableMap.Builder pageData = ImmutableMap.builder().put((Object)PAGE_KEYS.get(PAGE_OFFSET_KEY), (Object)offset).put((Object)PAGE_KEYS.get(PAGE_LIMIT_KEY), (Object)limit);
        if (generatePageTotals) {
            pageData.put((Object)PAGE_KEYS.get(PAGE_TOTALS_KEY), (Object)1);
        }
        Pagination result = new Pagination((Map<PaginationKey, Integer>)pageData.build(), 10000, 500);
        result.offset = offset;
        result.limit = limit;
        result.generateTotals = generatePageTotals;
        return result;
    }

    public static Optional<Pagination> fromOffsetAndFirst(Optional<String> firstOpt, Optional<String> offsetOpt, boolean generatePageTotals, ElideSettings elideSettings) {
        return firstOpt.map(firstString -> {
            int first;
            int offset;
            try {
                offset = offsetOpt.map(Integer::parseInt).orElse(0);
                first = Integer.parseInt(firstString);
            }
            catch (NumberFormatException e) {
                throw new InvalidValueException((Object)"Offset and first must be numeric values.");
            }
            if (offset < 0) {
                throw new InvalidValueException((Object)"Offset values must be non-negative.");
            }
            if (first < 1) {
                throw new InvalidValueException((Object)"Limit values must be positive.");
            }
            ImmutableMap.Builder pageData = ImmutableMap.builder().put((Object)PAGE_KEYS.get(PAGE_OFFSET_KEY), (Object)offset).put((Object)PAGE_KEYS.get(PAGE_LIMIT_KEY), (Object)first);
            if (generatePageTotals) {
                pageData.put((Object)PAGE_KEYS.get(PAGE_TOTALS_KEY), (Object)1);
            }
            return Optional.of(Pagination.getPagination((Map<PaginationKey, Integer>)pageData.build(), elideSettings));
        }).orElseGet(() -> {
            if (generatePageTotals) {
                Pagination pagination = Pagination.getDefaultPagination(elideSettings);
                pagination.pageData.put(PAGE_KEYS.get(PAGE_TOTALS_KEY), 1);
                return Optional.of(pagination);
            }
            return Optional.empty();
        });
    }

    public static Pagination parseQueryParams(MultivaluedMap<String, String> queryParams, ElideSettings elideSettings) throws InvalidValueException {
        HashMap<PaginationKey, Integer> pageData = new HashMap<PaginationKey, Integer>();
        queryParams.entrySet().forEach(paramEntry -> {
            String queryParamKey = (String)paramEntry.getKey();
            if (PAGE_KEYS.containsKey(queryParamKey)) {
                PaginationKey paginationKey = PAGE_KEYS.get(queryParamKey);
                if (paginationKey.equals((Object)PaginationKey.totals)) {
                    pageData.put(paginationKey, 0);
                } else {
                    String value = (String)((List)paramEntry.getValue()).get(0);
                    try {
                        int intValue = Integer.parseInt(value, 10);
                        pageData.put(paginationKey, intValue);
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidValueException((Object)"page values must be integers");
                    }
                }
            } else if (queryParamKey.startsWith("page[")) {
                throw new InvalidValueException((Object)("Invalid Pagination Parameter. Accepted values are " + PAGE_KEYS_CSV));
            }
        });
        return Pagination.getPagination(pageData, elideSettings);
    }

    public void setPageTotals(long total) {
        this.pageTotals = total;
    }

    public long getPageTotals() {
        return this.pageTotals;
    }

    private static Pagination getPagination(Map<PaginationKey, Integer> pageData, ElideSettings elideSettings) {
        Pagination result = new Pagination(pageData, elideSettings.getDefaultMaxPageSize(), elideSettings.getDefaultPageSize());
        result.offset = 0;
        result.limit = elideSettings.getDefaultPageSize();
        return result;
    }

    private Pagination evaluate(int defaultLimit, int maxLimit) {
        if (this.hasInvalidCombination(this.pageData)) {
            throw new InvalidValueException((Object)"Invalid usage of pagination parameters.");
        }
        if (this.pageData.containsKey((Object)PaginationKey.size) || this.pageData.containsKey((Object)PaginationKey.number)) {
            this.pageByPages(defaultLimit, maxLimit);
        } else if (this.pageData.containsKey((Object)PaginationKey.limit) || this.pageData.containsKey((Object)PaginationKey.offset)) {
            this.pageByOffset(defaultLimit, maxLimit);
        } else {
            this.limit = defaultLimit;
            this.offset = 0;
        }
        this.generateTotals = this.pageData.containsKey((Object)PaginationKey.totals);
        return this;
    }

    private boolean hasInvalidCombination(Map<PaginationKey, Integer> pageData) {
        return !(!pageData.containsKey((Object)PaginationKey.size) && !pageData.containsKey((Object)PaginationKey.number) || !pageData.containsKey((Object)PaginationKey.limit) && !pageData.containsKey((Object)PaginationKey.offset));
    }

    private void pageByOffset(int defaultLimit, int maxLimit) {
        int n = this.limit = this.pageData.containsKey((Object)PaginationKey.limit) ? this.pageData.get((Object)PaginationKey.limit) : defaultLimit;
        if (this.limit > maxLimit) {
            throw new InvalidValueException((Object)("page[limit] value must be less than or equal to " + maxLimit));
        }
        if (this.limit < 0) {
            throw new InvalidValueException((Object)"page[limit] value must contain a positive value");
        }
        int n2 = this.offset = this.pageData.containsKey((Object)PaginationKey.offset) ? this.pageData.get((Object)PaginationKey.offset) : 0;
        if (this.offset < 0) {
            throw new InvalidValueException((Object)"page[offset] must contain a positive values.");
        }
    }

    private void pageByPages(int defaultLimit, int maxLimit) {
        int pageNumber;
        int n = this.limit = this.pageData.containsKey((Object)PaginationKey.size) ? this.pageData.get((Object)PaginationKey.size) : defaultLimit;
        if (this.limit > maxLimit) {
            throw new InvalidValueException((Object)("page[size] value must be less than or equal to " + maxLimit));
        }
        if (this.limit < 0) {
            throw new InvalidValueException((Object)"page[size] must contain a positive value.");
        }
        int n2 = pageNumber = this.pageData.containsKey((Object)PaginationKey.number) ? this.pageData.get((Object)PaginationKey.number) : 1;
        if (pageNumber < 1) {
            throw new InvalidValueException((Object)"page[number] must contain a positive value.");
        }
        this.offset = (pageNumber - 1) * this.limit;
    }

    public Pagination evaluate(Class entityClass) {
        Paginate paginate = entityClass != null ? entityClass.getAnnotation(Paginate.class) : null;
        int defaultLimit = paginate != null ? paginate.defaultLimit() : this.defaultPageSize;
        int maxLimit = paginate != null ? paginate.maxLimit() : this.defaultMaxPageSize;
        this.evaluate(defaultLimit, maxLimit);
        this.generateTotals = this.generateTotals && (paginate == null || paginate.countable());
        return this;
    }

    public boolean isDefaultInstance() {
        return this.pageData.isEmpty();
    }

    public boolean isEmpty() {
        return this.isDefaultInstance();
    }

    public static Pagination getDefaultPagination(ElideSettings elideSettings) {
        Pagination defaultPagination = new Pagination(new HashMap<PaginationKey, Integer>(), elideSettings.getDefaultMaxPageSize(), elideSettings.getDefaultPageSize());
        defaultPagination.offset = 0;
        defaultPagination.limit = 500;
        return defaultPagination;
    }

    public String toString() {
        return "Pagination(pageTotals=" + this.getPageTotals() + ", pageData=" + this.pageData + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ", generateTotals=" + this.isGenerateTotals() + ", defaultMaxPageSize=" + this.defaultMaxPageSize + ", defaultPageSize=" + this.defaultPageSize + ")";
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isGenerateTotals() {
        return this.generateTotals;
    }

    static {
        PAGE_KEYS.put(PAGE_NUMBER_KEY, PaginationKey.number);
        PAGE_KEYS.put(PAGE_SIZE_KEY, PaginationKey.size);
        PAGE_KEYS.put(PAGE_OFFSET_KEY, PaginationKey.offset);
        PAGE_KEYS.put(PAGE_LIMIT_KEY, PaginationKey.limit);
        PAGE_KEYS.put(PAGE_TOTALS_KEY, PaginationKey.totals);
        PAGE_KEYS_CSV = PAGE_KEYS.keySet().stream().collect(Collectors.joining(", "));
    }

    public static enum PaginationKey {
        offset,
        number,
        size,
        limit,
        totals;

    }
}

