/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.parsers;

import com.yahoo.elide.generated.parsers.CoreLexer;
import com.yahoo.elide.generated.parsers.CoreParser;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;

public class JsonApiParser {
    private static final Pattern DUPLICATE_SEPARATOR_PATTERN = Pattern.compile("/+");

    public static String normalizePath(String path) {
        String normalizedPath = DUPLICATE_SEPARATOR_PATTERN.matcher(path).replaceAll("/");
        if (normalizedPath.endsWith("/")) {
            normalizedPath = normalizedPath.substring(0, normalizedPath.length() - 1);
        }
        if (normalizedPath.startsWith("/")) {
            normalizedPath = normalizedPath.substring(1);
        }
        return normalizedPath;
    }

    public static ParseTree parse(String path) {
        String normalizedPath = JsonApiParser.normalizePath(path);
        CodePointCharStream is = CharStreams.fromString((String)normalizedPath);
        CoreLexer lexer = new CoreLexer((CharStream)is);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new ParseCancellationException(msg, (Throwable)e);
            }
        });
        CoreParser parser = new CoreParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        return parser.start();
    }
}

