/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.resources;

import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.annotation.PATCH;
import com.yahoo.elide.resources.DefaultOpaqueUserFunction;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Singleton
@Produces(value={"application/vnd.api+json"})
@Path(value="/")
public class JsonApiEndpoint {
    protected final Elide elide;
    protected final Function<SecurityContext, Object> getUser;
    public static final DefaultOpaqueUserFunction DEFAULT_GET_USER = securityContext -> securityContext;

    @Inject
    public JsonApiEndpoint(@Named(value="elide") Elide elide, @Named(value="elideUserExtractionFunction") DefaultOpaqueUserFunction getUser) {
        this.elide = elide;
        this.getUser = getUser == null ? DEFAULT_GET_USER : getUser;
    }

    @POST
    @Path(value="{path:.*}")
    @Consumes(value={"application/vnd.api+json"})
    public Response post(@PathParam(value="path") String path, @Context SecurityContext securityContext, String jsonapiDocument) {
        return JsonApiEndpoint.build(this.elide.post(path, jsonapiDocument, this.getUser.apply(securityContext)));
    }

    @GET
    @Path(value="{path:.*}")
    public Response get(@PathParam(value="path") String path, @Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        return JsonApiEndpoint.build(this.elide.get(path, (MultivaluedMap<String, String>)queryParams, this.getUser.apply(securityContext)));
    }

    @PATCH
    @Path(value="{path:.*}")
    @Consumes(value={"application/vnd.api+json"})
    public Response patch(@HeaderParam(value="Content-Type") String contentType, @HeaderParam(value="accept") String accept, @PathParam(value="path") String path, @Context SecurityContext securityContext, String jsonapiDocument) {
        return JsonApiEndpoint.build(this.elide.patch(contentType, accept, path, jsonapiDocument, this.getUser.apply(securityContext)));
    }

    @DELETE
    @Path(value="{path:.*}")
    @Consumes(value={"application/vnd.api+json"})
    public Response delete(@PathParam(value="path") String path, @Context SecurityContext securityContext, String jsonApiDocument) {
        return JsonApiEndpoint.build(this.elide.delete(path, jsonApiDocument, this.getUser.apply(securityContext)));
    }

    private static Response build(ElideResponse response) {
        return Response.status((int)response.getResponseCode()).entity((Object)response.getBody()).build();
    }
}

