/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.security;

import com.yahoo.elide.annotation.FilterExpressionPath;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.parsers.expression.FilterExpressionCheckEvaluationVisitor;
import com.yahoo.elide.security.ChangeSpec;
import com.yahoo.elide.security.RequestScope;
import com.yahoo.elide.security.User;
import com.yahoo.elide.security.checks.InlineCheck;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilterExpressionCheck<T>
extends InlineCheck<T> {
    private static final Logger log = LoggerFactory.getLogger(FilterExpressionCheck.class);

    public abstract FilterExpression getFilterExpression(Class<?> var1, RequestScope var2);

    public final boolean ok(User user) {
        throw new UnsupportedOperationException();
    }

    public final boolean ok(T object, RequestScope requestScope, Optional<ChangeSpec> changeSpec) {
        Class<?> entityClass = FilterExpressionCheck.coreScope(requestScope).getDictionary().lookupBoundClass(object.getClass());
        FilterExpression filterExpression = this.getFilterExpression(entityClass, requestScope);
        return filterExpression.accept(new FilterExpressionCheckEvaluationVisitor(object, this, requestScope));
    }

    public boolean applyPredicateToObject(T object, FilterPredicate filterPredicate, RequestScope requestScope) {
        try {
            com.yahoo.elide.core.RequestScope scope = FilterExpressionCheck.coreScope(requestScope);
            Predicate<T> fn = filterPredicate.getOperator().contextualize(filterPredicate.getPath(), filterPredicate.getValues(), scope);
            return fn.test(object);
        }
        catch (Exception e) {
            log.error("Failed to apply predicate {}", (Object)filterPredicate, (Object)e);
            return false;
        }
    }

    protected static Path getFieldPath(Class<?> type, RequestScope requestScope, String method, String defaultPath) {
        EntityDictionary dictionary;
        FilterExpressionPath fep = (dictionary = FilterExpressionCheck.coreScope(requestScope).getDictionary()).getMethodAnnotation(type, method, FilterExpressionPath.class);
        return new Path(type, dictionary, fep == null ? defaultPath : fep.value());
    }

    protected static com.yahoo.elide.core.RequestScope coreScope(RequestScope requestScope) {
        return (com.yahoo.elide.core.RequestScope)requestScope;
    }
}

