/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide;

import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.audit.AuditLogger;
import com.yahoo.elide.audit.Slf4jLogger;
import com.yahoo.elide.core.DataStore;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.filter.dialect.DefaultFilterDialect;
import com.yahoo.elide.core.filter.dialect.JoinFilterDialect;
import com.yahoo.elide.core.filter.dialect.RSQLFilterDialect;
import com.yahoo.elide.core.filter.dialect.SubqueryFilterDialect;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.security.PermissionExecutor;
import com.yahoo.elide.security.checks.Check;
import com.yahoo.elide.security.executors.ActivePermissionExecutor;
import com.yahoo.elide.utils.coerce.converters.EpochToDateConverter;
import com.yahoo.elide.utils.coerce.converters.ISO8601DateSerde;
import com.yahoo.elide.utils.coerce.converters.Serde;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;

public class ElideSettingsBuilder {
    private final DataStore dataStore;
    private AuditLogger auditLogger;
    private JsonApiMapper jsonApiMapper;
    private EntityDictionary entityDictionary = new EntityDictionary(new HashMap<String, Class<? extends Check>>());
    private Function<RequestScope, PermissionExecutor> permissionExecutorFunction = ActivePermissionExecutor::new;
    private List<JoinFilterDialect> joinFilterDialects;
    private List<SubqueryFilterDialect> subqueryFilterDialects;
    private Map<Class, Serde> serdes;
    private int defaultMaxPageSize = 10000;
    private int defaultPageSize = 500;
    private boolean useFilterExpressions;
    private int updateStatusCode;
    private boolean returnErrorObjects;
    private boolean encodeErrorResponses;

    public ElideSettingsBuilder(DataStore dataStore) {
        this.dataStore = dataStore;
        this.auditLogger = new Slf4jLogger();
        this.jsonApiMapper = new JsonApiMapper(this.entityDictionary);
        this.joinFilterDialects = new ArrayList<JoinFilterDialect>();
        this.subqueryFilterDialects = new ArrayList<SubqueryFilterDialect>();
        this.updateStatusCode = 204;
        this.serdes = new HashMap<Class, Serde>();
        this.withEpochDates();
    }

    public ElideSettings build() {
        if (this.joinFilterDialects.isEmpty()) {
            this.joinFilterDialects.add(new DefaultFilterDialect(this.entityDictionary));
            this.joinFilterDialects.add(new RSQLFilterDialect(this.entityDictionary));
        }
        if (this.subqueryFilterDialects.isEmpty()) {
            this.subqueryFilterDialects.add(new DefaultFilterDialect(this.entityDictionary));
            this.subqueryFilterDialects.add(new RSQLFilterDialect(this.entityDictionary));
        }
        return new ElideSettings(this.auditLogger, this.dataStore, this.entityDictionary, this.jsonApiMapper, this.permissionExecutorFunction, this.joinFilterDialects, this.subqueryFilterDialects, this.defaultMaxPageSize, this.defaultPageSize, this.useFilterExpressions, this.updateStatusCode, this.returnErrorObjects, this.serdes, this.encodeErrorResponses);
    }

    public ElideSettingsBuilder withAuditLogger(AuditLogger auditLogger) {
        this.auditLogger = auditLogger;
        return this;
    }

    public ElideSettingsBuilder withEntityDictionary(EntityDictionary entityDictionary) {
        this.entityDictionary = entityDictionary;
        return this;
    }

    public ElideSettingsBuilder withJsonApiMapper(JsonApiMapper jsonApiMapper) {
        this.jsonApiMapper = jsonApiMapper;
        return this;
    }

    public ElideSettingsBuilder withPermissionExecutor(Function<RequestScope, PermissionExecutor> permissionExecutorFunction) {
        this.permissionExecutorFunction = permissionExecutorFunction;
        return this;
    }

    public ElideSettingsBuilder withPermissionExecutor(Class<? extends PermissionExecutor> permissionExecutorClass) {
        this.permissionExecutorFunction = requestScope -> {
            try {
                Constructor ctor = permissionExecutorClass.getDeclaredConstructor(RequestScope.class);
                return (PermissionExecutor)ctor.newInstance(requestScope);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                try {
                    return (PermissionExecutor)permissionExecutorClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
        return this;
    }

    public ElideSettingsBuilder withJoinFilterDialect(JoinFilterDialect dialect) {
        this.joinFilterDialects.add(dialect);
        return this;
    }

    public ElideSettingsBuilder withSubqueryFilterDialect(SubqueryFilterDialect dialect) {
        this.subqueryFilterDialects.add(dialect);
        return this;
    }

    public ElideSettingsBuilder withDefaultMaxPageSize(int maxPageSize) {
        this.defaultMaxPageSize = maxPageSize;
        return this;
    }

    public ElideSettingsBuilder withDefaultPageSize(int pageSize) {
        this.defaultPageSize = pageSize;
        return this;
    }

    public ElideSettingsBuilder withUpdate200Status() {
        this.updateStatusCode = 200;
        return this;
    }

    public ElideSettingsBuilder withUpdate204Status() {
        this.updateStatusCode = 204;
        return this;
    }

    public ElideSettingsBuilder withUseFilterExpressions(boolean useFilterExpressions) {
        this.useFilterExpressions = useFilterExpressions;
        return this;
    }

    public ElideSettingsBuilder withISO8601Dates(String dateFormat, TimeZone tz) {
        this.serdes.put(java.util.Date.class, new ISO8601DateSerde(dateFormat, tz));
        this.serdes.put(Date.class, new ISO8601DateSerde(dateFormat, tz, Date.class));
        this.serdes.put(Time.class, new ISO8601DateSerde(dateFormat, tz, Time.class));
        this.serdes.put(Timestamp.class, new ISO8601DateSerde(dateFormat, tz, Timestamp.class));
        return this;
    }

    public ElideSettingsBuilder withEpochDates() {
        this.serdes.put(java.util.Date.class, new EpochToDateConverter<java.util.Date>(java.util.Date.class));
        this.serdes.put(Date.class, new EpochToDateConverter<Date>(Date.class));
        this.serdes.put(Time.class, new EpochToDateConverter<Time>(Time.class));
        this.serdes.put(Timestamp.class, new EpochToDateConverter<Timestamp>(Timestamp.class));
        return this;
    }

    public ElideSettingsBuilder withReturnErrorObjects(boolean returnErrorObjects) {
        this.returnErrorObjects = returnErrorObjects;
        return this;
    }

    public ElideSettingsBuilder withEncodeErrorResponses(boolean encodeErrorResponses) {
        this.encodeErrorResponses = encodeErrorResponses;
        return this;
    }
}

