/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.audit;

import com.yahoo.elide.annotation.Audit;
import com.yahoo.elide.audit.InvalidSyntaxException;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.ResourceLineage;
import com.yahoo.elide.security.ChangeSpec;
import com.yahoo.elide.security.User;
import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.util.SimpleContext;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;

public class LogMessage {
    private static final ExpressionFactory EXPRESSION_FACTORY = new ExpressionFactoryImpl();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final String template;
    private final PersistentResource record;
    private final String[] expressions;
    private final int operationCode;
    private final Optional<ChangeSpec> changeSpec;

    public LogMessage(String template, int code) {
        this(template, null, EMPTY_STRING_ARRAY, code, Optional.empty());
    }

    public LogMessage(Audit audit, PersistentResource record, Optional<ChangeSpec> changeSpec) throws InvalidSyntaxException {
        this(audit.logStatement(), record, audit.logExpressions(), audit.operation(), changeSpec);
    }

    public LogMessage(String template, PersistentResource record, String[] expressions, int code, Optional<ChangeSpec> changeSpec) throws InvalidSyntaxException {
        this.template = template;
        this.record = record;
        this.expressions = expressions;
        this.operationCode = code;
        this.changeSpec = changeSpec;
    }

    public int getOperationCode() {
        return this.operationCode;
    }

    public String getMessage() {
        SimpleContext ctx = new SimpleContext();
        SimpleContext singleElementContext = new SimpleContext();
        if (this.record != null) {
            ResourceLineage lineage = new ResourceLineage(this.record.getLineage(), this.record);
            for (String name : lineage.getKeys()) {
                ValueExpression singleElementExpression;
                ValueExpression expression;
                List<PersistentResource> values = lineage.getRecord(name);
                if (values.size() == 1) {
                    singleElementExpression = expression = EXPRESSION_FACTORY.createValueExpression(values.get(0).getObject(), Object.class);
                } else {
                    List objects = values.stream().map(PersistentResource::getObject).collect(Collectors.toList());
                    expression = EXPRESSION_FACTORY.createValueExpression(objects, List.class);
                    singleElementExpression = EXPRESSION_FACTORY.createValueExpression(values.get(values.size() - 1).getObject(), Object.class);
                }
                ctx.setVariable(name, expression);
                singleElementContext.setVariable(name, singleElementExpression);
            }
            Object user = this.getUser();
            if (user != null) {
                ValueExpression opaqueUserValueExpression = EXPRESSION_FACTORY.createValueExpression(user, Object.class);
                ctx.setVariable("opaqueUser", opaqueUserValueExpression);
                singleElementContext.setVariable("opaqueUser", opaqueUserValueExpression);
            }
        }
        Object[] results = new Object[this.expressions.length];
        for (int idx = 0; idx < results.length; ++idx) {
            Object result;
            ValueExpression singleElementExpression;
            ValueExpression expression;
            String expressionText = this.expressions[idx];
            try {
                expression = EXPRESSION_FACTORY.createValueExpression((ELContext)ctx, expressionText, Object.class);
                singleElementExpression = EXPRESSION_FACTORY.createValueExpression((ELContext)singleElementContext, expressionText, Object.class);
            }
            catch (ELException e) {
                throw new InvalidSyntaxException((Exception)((Object)e));
            }
            try {
                result = singleElementExpression.getValue((ELContext)singleElementContext);
            }
            catch (PropertyNotFoundException e) {
                result = expression.getValue((ELContext)ctx);
            }
            results[idx] = result;
        }
        try {
            return MessageFormat.format(this.template, results);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSyntaxException(e);
        }
    }

    public RequestScope getRequestScope() {
        if (this.record != null) {
            return this.record.getRequestScope();
        }
        return null;
    }

    public Object getUser() {
        User user;
        RequestScope requestScope = this.getRequestScope();
        if (requestScope != null && (user = requestScope.getUser()) != null) {
            return user.getOpaqueUser();
        }
        return null;
    }

    public Optional<ChangeSpec> getChangeSpec() {
        return this.changeSpec;
    }

    public String toString() {
        return "LogMessage{message='" + this.getMessage() + '\'' + ", operationCode=" + this.getOperationCode() + '}';
    }
}

