/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.security.checks.Check;
import java.util.Objects;

public interface CheckInstantiator {
    default public Check getCheck(EntityDictionary dictionary, String checkName) {
        Class<? extends Check> checkCls = dictionary.getCheck(checkName);
        return this.instantiateCheck(checkCls);
    }

    default public Check instantiateCheck(Class<? extends Check> checkCls) {
        try {
            return Objects.requireNonNull(checkCls).newInstance();
        }
        catch (IllegalAccessException | InstantiationException | NullPointerException e) {
            String checkName = checkCls != null ? checkCls.getName() : "null";
            throw new IllegalArgumentException("Could not instantiate specified check '" + checkName + "'.", e);
        }
    }
}

