/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.yahoo.elide.Injector;
import com.yahoo.elide.annotation.ComputedAttribute;
import com.yahoo.elide.annotation.ComputedRelationship;
import com.yahoo.elide.annotation.Exclude;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.annotation.MappedInterface;
import com.yahoo.elide.annotation.SecurityCheck;
import com.yahoo.elide.annotation.SharePermission;
import com.yahoo.elide.core.EntityBinding;
import com.yahoo.elide.core.Initializer;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RelationshipType;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.exceptions.InternalServerErrorException;
import com.yahoo.elide.core.exceptions.InvalidAttributeException;
import com.yahoo.elide.functions.LifeCycleHook;
import com.yahoo.elide.security.checks.Check;
import com.yahoo.elide.security.checks.prefab.Collections;
import com.yahoo.elide.security.checks.prefab.Common;
import com.yahoo.elide.security.checks.prefab.Role;
import com.yahoo.elide.utils.ClassScanner;
import com.yahoo.elide.utils.coerce.CoerceUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Transient;
import javax.ws.rs.WebApplicationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDictionary {
    private static final Logger log = LoggerFactory.getLogger(EntityDictionary.class);
    protected final ConcurrentHashMap<String, Class<?>> bindJsonApiToEntity = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Class<?>, EntityBinding> entityBindings = new ConcurrentHashMap();
    protected final CopyOnWriteArrayList<Class<?>> bindEntityRoots = new CopyOnWriteArrayList();
    protected final ConcurrentHashMap<Class<?>, List<Class<?>>> subclassingEntities = new ConcurrentHashMap();
    protected final BiMap<String, Class<? extends Check>> checkNames;
    protected final Injector injector;
    public static final String REGULAR_ID_NAME = "id";
    private static final ConcurrentHashMap<Class, String> SIMPLE_NAMES = new ConcurrentHashMap();

    public EntityDictionary(Map<String, Class<? extends Check>> checks) {
        this(checks, null);
    }

    public EntityDictionary(Map<String, Class<? extends Check>> checks, Injector injector) {
        this.checkNames = Maps.synchronizedBiMap((BiMap)HashBiMap.create(checks));
        this.addPrefabCheck("Prefab.Role.All", Role.ALL.class);
        this.addPrefabCheck("Prefab.Role.None", Role.NONE.class);
        this.addPrefabCheck("Prefab.Collections.AppendOnly", Collections.AppendOnly.class);
        this.addPrefabCheck("Prefab.Collections.RemoveOnly", Collections.RemoveOnly.class);
        this.addPrefabCheck("Prefab.Common.UpdateOnCreate", Common.UpdateOnCreate.class);
        this.injector = injector;
    }

    private void addPrefabCheck(String alias, Class<? extends Check> checkClass) {
        if (this.checkNames.containsKey((Object)alias) || this.checkNames.inverse().containsKey(checkClass)) {
            return;
        }
        this.checkNames.put((Object)alias, checkClass);
    }

    private static Package getParentPackage(Package pkg) {
        String name = pkg.getName();
        int idx = name.lastIndexOf(46);
        return idx == -1 ? null : Package.getPackage(name.substring(0, idx));
    }

    public static String getSimpleName(Class<?> cls) {
        return SIMPLE_NAMES.computeIfAbsent(cls, key -> cls.getSimpleName());
    }

    public static Method findMethod(Class<?> entityClass, String name, Class<?> ... paramClass) throws NoSuchMethodException {
        Method m = entityClass.getMethod(name, paramClass);
        int modifiers = m.getModifiers();
        if (Modifier.isAbstract(modifiers) || m.isAnnotationPresent(Transient.class) && !m.isAnnotationPresent(ComputedAttribute.class) && !m.isAnnotationPresent(ComputedRelationship.class)) {
            throw new NoSuchMethodException(name);
        }
        return m;
    }

    protected EntityBinding getEntityBinding(Class<?> entityClass) {
        if (this.isMappedInterface(entityClass)) {
            return EntityBinding.EMPTY_BINDING;
        }
        EntityBinding binding = this.entityBindings.get(entityClass);
        if (binding != null) {
            return binding;
        }
        Class<?> declaredClass = this.lookupBoundClass(entityClass);
        if (declaredClass != null) {
            return this.entityBindings.get(declaredClass);
        }
        this.lookupEntityClass(entityClass);
        return EntityBinding.EMPTY_BINDING;
    }

    public boolean isMappedInterface(Class<?> interfaceClass) {
        return interfaceClass.isInterface() && interfaceClass.isAnnotationPresent(MappedInterface.class);
    }

    public Class<?> getEntityClass(String entityName) {
        return this.bindJsonApiToEntity.get(entityName);
    }

    public String getJsonAliasFor(Class<?> entityClass) {
        return this.getEntityBinding(entityClass).jsonApiType;
    }

    public String getEntityFor(Class<?> entityClass) {
        return this.getEntityBinding(entityClass).entityName;
    }

    public boolean entityHasChecksForPermission(Class<?> resourceClass, Class<? extends Annotation> annotationClass) {
        EntityBinding binding = this.getEntityBinding(resourceClass);
        return binding.entityPermissions.hasChecksForPermission(annotationClass);
    }

    public ParseTree getPermissionsForClass(Class<?> resourceClass, Class<? extends Annotation> annotationClass) {
        EntityBinding binding = this.getEntityBinding(resourceClass);
        return binding.entityPermissions.getClassChecksForPermission(annotationClass);
    }

    public ParseTree getPermissionsForField(Class<?> resourceClass, String field, Class<? extends Annotation> annotationClass) {
        EntityBinding binding = this.getEntityBinding(resourceClass);
        return binding.entityPermissions.getFieldChecksForPermission(field, annotationClass);
    }

    public Class<? extends Check> getCheck(String checkIdentifier) {
        return (Class)this.checkNames.computeIfAbsent((Object)checkIdentifier, cls -> {
            try {
                return Class.forName(checkIdentifier).asSubclass(Check.class);
            }
            catch (ClassCastException | ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not instantiate specified check '" + checkIdentifier + "'.", e);
            }
        });
    }

    public List<String> getSubclassingEntityNames(String entityName) {
        return this.getSubclassingEntityNames(this.getEntityClass(entityName));
    }

    public List<String> getSubclassingEntityNames(Class entityClass) {
        List<Class<?>> entities = this.getSubclassingEntities(entityClass);
        return entities.stream().map(this::getJsonAliasFor).collect(Collectors.toList());
    }

    public List<Class<?>> getSubclassingEntities(String entityName) {
        return this.getSubclassingEntities(this.getEntityClass(entityName));
    }

    public List<Class<?>> getSubclassingEntities(Class entityClass) {
        return this.subclassingEntities.computeIfAbsent(entityClass, unused -> this.entityBindings.keySet().stream().filter(c -> c != entityClass && entityClass.isAssignableFrom((Class<?>)c)).collect(Collectors.toList()));
    }

    public List<String> getSuperClassEntityNames(String entityName) {
        return this.getSuperClassEntityNames(this.getEntityClass(entityName));
    }

    public List<String> getSuperClassEntityNames(Class entityClass) {
        return this.getSuperClassEntities(entityClass).stream().map(this::getJsonAliasFor).collect(Collectors.toList());
    }

    public List<Class<?>> getSuperClassEntities(String entityName) {
        return this.getSuperClassEntities(this.getEntityClass(entityName));
    }

    public List<Class<?>> getSuperClassEntities(Class entityClass) {
        return this.getEntityBinding(entityClass).inheritedTypes.stream().filter(this.entityBindings::containsKey).collect(Collectors.toList());
    }

    public String getCheckIdentifier(Class<? extends Check> checkClass) {
        String identifier = (String)this.checkNames.inverse().get(checkClass);
        if (identifier == null) {
            return checkClass.getName();
        }
        return identifier;
    }

    public String getIdFieldName(Class<?> entityClass) {
        return this.getEntityBinding(entityClass).getIdFieldName();
    }

    public AccessType getAccessType(Class<?> entityClass) {
        return this.getEntityBinding(entityClass).getAccessType();
    }

    public Set<Class<?>> getBindings() {
        return this.entityBindings.keySet();
    }

    public Map<String, Class<? extends Check>> getCheckMappings() {
        return this.checkNames;
    }

    public List<String> getAttributes(Class<?> entityClass) {
        return this.getEntityBinding(entityClass).attributes;
    }

    public Injector getInjector() {
        return this.injector;
    }

    public List<String> getAttributes(Object entity) {
        return this.getAttributes(entity.getClass());
    }

    public List<String> getRelationships(Class<?> entityClass) {
        return this.getEntityBinding(entityClass).relationships;
    }

    public List<String> getRelationships(Object entity) {
        return this.getRelationships(entity.getClass());
    }

    public List<String> getElideBoundRelationships(Class<?> entityClass) {
        return this.getRelationships(entityClass).stream().filter(relationName -> this.getBindings().contains(this.getParameterizedType(entityClass, (String)relationName))).collect(Collectors.toList());
    }

    public List<String> getElideBoundRelationships(Object entity) {
        return this.getElideBoundRelationships(entity.getClass());
    }

    public boolean isMethodRequestScopeable(Object entity, Method method) {
        return this.isMethodRequestScopeable(entity.getClass(), method);
    }

    public boolean isMethodRequestScopeable(Class<?> entityClass, Method method) {
        return this.getEntityBinding(entityClass).requestScopeableMethods.getOrDefault(method, false);
    }

    public List<String> getAllFields(Class<?> entityClass) {
        ArrayList<String> fields = new ArrayList<String>();
        List<String> attrs = this.getAttributes(entityClass);
        List<String> rels = this.getRelationships(entityClass);
        if (attrs != null) {
            fields.addAll(attrs);
        }
        if (rels != null) {
            fields.addAll(rels);
        }
        return fields;
    }

    public List<String> getAllFields(Object entity) {
        return this.getAllFields(entity.getClass());
    }

    public RelationshipType getRelationshipType(Class<?> cls, String relation) {
        ConcurrentHashMap<String, RelationshipType> types = this.getEntityBinding(cls).relationshipTypes;
        if (types == null) {
            return RelationshipType.NONE;
        }
        RelationshipType type = types.get(relation);
        return type == null ? RelationshipType.NONE : type;
    }

    public String getRelationInverse(Class<?> cls, String relation) {
        String mapping;
        EntityBinding clsBinding = this.getEntityBinding(cls);
        ConcurrentHashMap<String, String> mappings = clsBinding.relationshipToInverse;
        if (mappings != null && (mapping = mappings.get(relation)) != null && !"".equals(mapping)) {
            return mapping;
        }
        Class<?> inverseType = this.getParameterizedType(cls, relation);
        ConcurrentHashMap<String, String> inverseMappings = this.getEntityBinding(inverseType).relationshipToInverse;
        for (Map.Entry<String, String> inverseMapping : inverseMappings.entrySet()) {
            String inverseRelationName = inverseMapping.getKey();
            String inverseMappedBy = inverseMapping.getValue();
            if (!relation.equals(inverseMappedBy) || !this.getParameterizedType(inverseType, inverseRelationName).equals(clsBinding.entityClass)) continue;
            return inverseRelationName;
        }
        return "";
    }

    public RelationshipType getRelationshipType(Object entity, String relation) {
        return this.getRelationshipType(entity.getClass(), relation);
    }

    public Class<?> getType(Class<?> entityClass, String identifier) {
        if (identifier.equals(REGULAR_ID_NAME)) {
            return this.getEntityBinding(entityClass).getIdType();
        }
        ConcurrentHashMap<String, Class<?>> fieldTypes = this.getEntityBinding(entityClass).fieldsToTypes;
        return fieldTypes == null ? null : fieldTypes.get(identifier);
    }

    public Class<?> getType(Object entity, String identifier) {
        return this.getType(entity.getClass(), identifier);
    }

    public Class<?> getParameterizedType(Class<?> entityClass, String identifier) {
        return this.getParameterizedType(entityClass, identifier, 0);
    }

    public Class<?> getParameterizedType(Class<?> entityClass, String identifier, int paramIndex) {
        ConcurrentHashMap<String, AccessibleObject> fieldOrMethods = this.getEntityBinding(entityClass).fieldsToValues;
        if (fieldOrMethods == null) {
            return null;
        }
        AccessibleObject fieldOrMethod = fieldOrMethods.get(identifier);
        if (fieldOrMethod == null) {
            return null;
        }
        return EntityBinding.getFieldType(entityClass, fieldOrMethod, Optional.of(paramIndex));
    }

    public Class<?> getParameterizedType(Object entity, String identifier) {
        return this.getParameterizedType(entity.getClass(), identifier);
    }

    public Class<?> getParameterizedType(Object entity, String identifier, int paramIndex) {
        return this.getParameterizedType(entity.getClass(), identifier, paramIndex);
    }

    public String getNameFromAlias(Class<?> entityClass, String alias) {
        ConcurrentHashMap<String, String> map = this.getEntityBinding(entityClass).aliasesToFields;
        if (map != null) {
            return map.get(alias);
        }
        return null;
    }

    public String getNameFromAlias(Object entity, String alias) {
        return this.getNameFromAlias(entity.getClass(), alias);
    }

    public <T> void initializeEntity(T entity) {
        if (entity != null) {
            Initializer initializer = this.getEntityBinding(entity.getClass()).getInitializer();
            if (initializer != null) {
                initializer.initialize(entity);
            } else if (this.injector != null) {
                this.injector.inject(entity);
            }
        }
    }

    public <T> void bindInitializer(Initializer<T> initializer, Class<T> cls) {
        this.bindIfUnbound(cls);
        this.getEntityBinding(cls).setInitializer(initializer);
    }

    public boolean isShareable(Class<?> entityClass) {
        return this.getAnnotation(entityClass, SharePermission.class) != null && this.getAnnotation(entityClass, SharePermission.class).sharable();
    }

    public void bindEntity(Class<?> cls) {
        Class<?> declaredClass = this.lookupIncludeClass(cls);
        if (declaredClass == null) {
            log.trace("Missing include or excluded class {}", (Object)cls.getName());
            return;
        }
        if (this.isClassBound(declaredClass)) {
            return;
        }
        Include include = (Include)EntityDictionary.getFirstAnnotation(declaredClass, Arrays.asList(Include.class));
        Entity entity = (Entity)EntityDictionary.getFirstAnnotation(declaredClass, Arrays.asList(Entity.class));
        String name = entity == null || "".equals(entity.name()) ? StringUtils.uncapitalize((String)cls.getSimpleName()) : entity.name();
        String type = "".equals(include.type()) ? name : include.type();
        this.bindJsonApiToEntity.put(type, declaredClass);
        this.entityBindings.put(declaredClass, new EntityBinding(this, declaredClass, type, name));
        if (include.rootLevel()) {
            this.bindEntityRoots.add(declaredClass);
        }
    }

    public <A extends Annotation> A getAnnotation(PersistentResource record, Class<A> annotationClass) {
        return this.getAnnotation(record.getResourceClass(), annotationClass);
    }

    public <A extends Annotation> A getAnnotation(Class<?> recordClass, Class<A> annotationClass) {
        return this.getEntityBinding(recordClass).getAnnotation(annotationClass);
    }

    public <A extends Annotation> A getMethodAnnotation(Class<?> recordClass, String method, Class<A> annotationClass) {
        return this.getEntityBinding(recordClass).getMethodAnnotation(annotationClass, method);
    }

    public <A extends Annotation> Collection<LifeCycleHook> getTriggers(Class<?> cls, Class<A> annotationClass, String fieldName) {
        return this.getEntityBinding(cls).getTriggers(annotationClass, fieldName);
    }

    public <A extends Annotation> Collection<LifeCycleHook> getTriggers(Class<?> cls, Class<A> annotationClass) {
        return this.getEntityBinding(cls).getTriggers(annotationClass);
    }

    public <A extends Annotation> A getAttributeOrRelationAnnotation(Class<?> entityClass, Class<A> annotationClass, String identifier) {
        AccessibleObject fieldOrMethod = this.getEntityBinding(entityClass).fieldsToValues.get(identifier);
        if (fieldOrMethod == null) {
            return null;
        }
        return fieldOrMethod.getAnnotation(annotationClass);
    }

    public <A extends Annotation> A[] getAttributeOrRelationAnnotations(Class<?> entityClass, Class<A> annotationClass, String identifier) {
        AccessibleObject fieldOrMethod = this.getEntityBinding(entityClass).fieldsToValues.get(identifier);
        if (fieldOrMethod == null) {
            return null;
        }
        return fieldOrMethod.getAnnotationsByType(annotationClass);
    }

    public static Annotation getFirstAnnotation(Class<?> entityClass, List<Class<? extends Annotation>> annotationClassList) {
        Class<? extends Annotation> annotationClass;
        Iterator<Class<? extends Annotation>> iterator;
        Annotation annotation = null;
        for (Class<?> cls = entityClass; annotation == null && cls != null; cls = cls.getSuperclass()) {
            iterator = annotationClassList.iterator();
            while (iterator.hasNext() && (annotation = cls.getDeclaredAnnotation(annotationClass = iterator.next())) == null) {
            }
        }
        Package pkg = entityClass.getPackage();
        while (annotation == null && pkg != null) {
            iterator = annotationClassList.iterator();
            while (iterator.hasNext() && (annotation = pkg.getDeclaredAnnotation(annotationClass = iterator.next())) == null) {
            }
            pkg = EntityDictionary.getParentPackage(pkg);
        }
        return annotation;
    }

    public boolean isRoot(Class<?> entityClass) {
        return this.bindEntityRoots.contains(entityClass);
    }

    public String getId(Object value) {
        if (value == null) {
            return null;
        }
        try {
            AccessibleObject idField = null;
            for (Class<?> cls = value.getClass(); idField == null && cls != null; cls = cls.getSuperclass()) {
                try {
                    idField = this.getEntityBinding(cls).getIdField();
                    continue;
                }
                catch (NullPointerException e) {
                    log.warn("Class: {} ID Field: {}", (Object)cls.getSimpleName(), (Object)idField);
                }
            }
            if (idField instanceof Field) {
                return String.valueOf(((Field)idField).get(value));
            }
            if (idField instanceof Method) {
                return String.valueOf(((Method)idField).invoke(value, (Object[])null));
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return null;
        }
    }

    public Class<?> getIdType(Class<?> entityClass) {
        return this.getEntityBinding(entityClass).getIdType();
    }

    public Collection<Annotation> getIdAnnotations(Object value) {
        if (value == null) {
            return null;
        }
        AccessibleObject idField = this.getEntityBinding(value.getClass()).getIdField();
        if (idField != null) {
            return Arrays.asList(idField.getDeclaredAnnotations());
        }
        return Collections.emptyList();
    }

    public Class<?> lookupEntityClass(Class<?> objClass) {
        Class<?> declaringClass = this.lookupAnnotationDeclarationClass(objClass, Entity.class);
        if (declaringClass != null) {
            return declaringClass;
        }
        throw new IllegalArgumentException("Unbound Entity " + objClass);
    }

    public Class<?> lookupIncludeClass(Class<?> objClass) {
        Annotation first = EntityDictionary.getFirstAnnotation(objClass, Arrays.asList(Exclude.class, Include.class));
        if (first instanceof Include) {
            return objClass;
        }
        return null;
    }

    public Class<?> lookupAnnotationDeclarationClass(Class<?> objClass, Class<? extends Annotation> annotationClass) {
        for (Class<?> cls = objClass; cls != null; cls = cls.getSuperclass()) {
            if (cls.getDeclaredAnnotation(annotationClass) == null) continue;
            return cls;
        }
        return null;
    }

    public Class<?> lookupBoundClass(Class<?> objClass) {
        EntityBinding binding = this.entityBindings.getOrDefault(objClass, EntityBinding.EMPTY_BINDING);
        if (binding != EntityBinding.EMPTY_BINDING) {
            return binding.entityClass;
        }
        Class<?> declaredClass = this.lookupIncludeClass(objClass);
        if (declaredClass == null) {
            return null;
        }
        binding = this.entityBindings.getOrDefault(declaredClass, EntityBinding.EMPTY_BINDING);
        if (binding != EntityBinding.EMPTY_BINDING) {
            return binding.entityClass;
        }
        try {
            return this.lookupEntityClass(declaredClass.getSuperclass());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private boolean isClassBound(Class<?> objClass) {
        return this.entityBindings.getOrDefault(objClass, EntityBinding.EMPTY_BINDING) != EntityBinding.EMPTY_BINDING;
    }

    public AccessibleObject getAccessibleObject(Object target, String fieldName) {
        return this.getAccessibleObject(target.getClass(), fieldName);
    }

    public boolean isComputed(Class<?> entityClass, String fieldName) {
        AccessibleObject fieldOrMethod = this.getAccessibleObject(entityClass, fieldName);
        if (fieldOrMethod == null) {
            return false;
        }
        return fieldOrMethod.isAnnotationPresent(ComputedAttribute.class) || fieldOrMethod.isAnnotationPresent(ComputedRelationship.class);
    }

    public AccessibleObject getAccessibleObject(Class<?> targetClass, String fieldName) {
        return this.getEntityBinding(targetClass).fieldsToValues.get(fieldName);
    }

    public Set<String> getFieldsOfType(Class<?> targetClass, Class<?> targetType) {
        HashSet<String> fields = new HashSet<String>();
        for (String field : this.getAllFields(targetClass)) {
            if (!this.getParameterizedType(targetClass, field).equals(targetType)) continue;
            fields.add(field);
        }
        return fields;
    }

    public boolean isRelation(Class<?> entityClass, String relationName) {
        return this.getEntityBinding(entityClass).relationships.contains(relationName);
    }

    public boolean isAttribute(Class<?> entityClass, String attributeName) {
        return this.getEntityBinding(entityClass).attributes.contains(attributeName);
    }

    public void scanForSecurityChecks() {
        for (Class<?> cls : ClassScanner.getAnnotatedClasses(SecurityCheck.class)) {
            if (Check.class.isAssignableFrom(cls)) {
                SecurityCheck securityCheckMeta = cls.getAnnotation(SecurityCheck.class);
                log.debug("Register Elide Check [{}] with expression [{}]", (Object)cls.getCanonicalName(), (Object)securityCheckMeta.value());
                this.checkNames.put((Object)securityCheckMeta.value(), cls.asSubclass(Check.class));
                continue;
            }
            throw new IllegalStateException("Class annotated with SecurityCheck is not a Check");
        }
    }

    public void bindTrigger(Class<?> entityClass, Class<? extends Annotation> annotationClass, String fieldOrMethodName, LifeCycleHook callback) {
        this.bindIfUnbound(entityClass);
        this.getEntityBinding(entityClass).bindTrigger(annotationClass, fieldOrMethodName, callback);
    }

    public void bindTrigger(Class<?> entityClass, Class<? extends Annotation> annotationClass, LifeCycleHook callback, boolean allowMultipleInvocations) {
        this.bindIfUnbound(entityClass);
        if (allowMultipleInvocations) {
            this.getEntityBinding(entityClass).bindTrigger(annotationClass, callback);
        } else {
            this.getEntityBinding(entityClass).bindTrigger(annotationClass, "", callback);
        }
    }

    public void bindTrigger(Class<?> entityClass, Class<? extends Annotation> annotationClass, LifeCycleHook callback) {
        this.bindTrigger(entityClass, annotationClass, callback, false);
    }

    public boolean cascadeDeletes(Class<?> targetClass, String fieldName) {
        CascadeType[] cascadeTypes;
        for (CascadeType cascadeType : cascadeTypes = this.getEntityBinding(targetClass).relationshipToCascadeTypes.getOrDefault(fieldName, new CascadeType[0])) {
            if (cascadeType != CascadeType.ALL && cascadeType != CascadeType.REMOVE) continue;
            return true;
        }
        return false;
    }

    public <T> List<T> walkEntityGraph(Set<Class<?>> entities, Function<Class<?>, T> transform) {
        ArrayList<T> results = new ArrayList<T>();
        ArrayDeque toVisit = new ArrayDeque(entities);
        HashSet<Class> visited = new HashSet<Class>();
        while (!toVisit.isEmpty()) {
            Class clazz = (Class)toVisit.remove();
            results.add(transform.apply(clazz));
            visited.add(clazz);
            for (String relationship : this.getElideBoundRelationships(clazz)) {
                Class<?> relationshipClass = this.getParameterizedType(clazz, relationship);
                if (this.lookupBoundClass(relationshipClass) == null || visited.contains(relationshipClass)) continue;
                toVisit.add(relationshipClass);
            }
        }
        return results;
    }

    public boolean hasBinding(Class<?> cls) {
        return this.bindJsonApiToEntity.contains(cls);
    }

    public Object getValue(Object target, String fieldName, RequestScope scope) {
        AccessibleObject accessor = this.getAccessibleObject(target, fieldName);
        try {
            if (accessor instanceof Method) {
                if (this.isMethodRequestScopeable(target, (Method)accessor)) {
                    return ((Method)accessor).invoke(target, scope);
                }
                return ((Method)accessor).invoke(target, new Object[0]);
            }
            if (accessor instanceof Field) {
                return ((Field)accessor).get(target);
            }
        }
        catch (IllegalAccessException e) {
            throw new InvalidAttributeException(fieldName, this.getJsonAliasFor(target.getClass()), e);
        }
        catch (InvocationTargetException e) {
            throw EntityDictionary.handleInvocationTargetException(e);
        }
        throw new InvalidAttributeException(fieldName, this.getJsonAliasFor(target.getClass()));
    }

    public void setValue(Object target, String fieldName, Object value) {
        Class<?> targetClass = target.getClass();
        String targetType = this.getJsonAliasFor(targetClass);
        String fieldAlias = fieldName;
        try {
            Class<?> fieldClass = this.getType(targetClass, fieldName);
            String realName = this.getNameFromAlias(target, fieldName);
            fieldAlias = realName != null ? realName : fieldName;
            String setMethod = "set" + StringUtils.capitalize((String)fieldAlias);
            Method method = EntityDictionary.findMethod(targetClass, setMethod, fieldClass);
            method.invoke(target, this.coerce(target, value, fieldAlias, fieldClass));
        }
        catch (IllegalAccessException e) {
            throw new InvalidAttributeException(fieldAlias, targetType, e);
        }
        catch (InvocationTargetException e) {
            throw EntityDictionary.handleInvocationTargetException(e);
        }
        catch (IllegalArgumentException | NoSuchMethodException noMethod) {
            AccessibleObject accessor = this.getAccessibleObject(target, fieldAlias);
            if (accessor != null && accessor instanceof Field) {
                Field field = (Field)accessor;
                try {
                    field.set(target, this.coerce(target, value, fieldAlias, field.getType()));
                }
                catch (IllegalAccessException noField) {
                    throw new InvalidAttributeException(fieldAlias, targetType, noField);
                }
            }
            throw new InvalidAttributeException(fieldAlias, targetType);
        }
    }

    private static RuntimeException handleInvocationTargetException(InvocationTargetException e) {
        Throwable exception = e.getTargetException();
        if (exception instanceof HttpStatusException || exception instanceof WebApplicationException) {
            return (RuntimeException)exception;
        }
        log.error("Caught an unexpected exception (rethrowing as internal server error)", (Throwable)e);
        return new InternalServerErrorException("Unexpected exception caught", e);
    }

    public Object coerce(Object target, Object value, String fieldName, Class<?> fieldClass) {
        if (fieldClass != null && Collection.class.isAssignableFrom(fieldClass) && value instanceof Collection) {
            return this.coerceCollection(target, (Collection)value, fieldName, fieldClass);
        }
        if (fieldClass != null && Map.class.isAssignableFrom(fieldClass) && value instanceof Map) {
            return this.coerceMap(target, (Map)value, fieldName);
        }
        return CoerceUtil.coerce(value, fieldClass);
    }

    private Collection coerceCollection(Object target, Collection<?> values, String fieldName, Class<?> fieldClass) {
        Class<?> providedType = this.getParameterizedType(target, fieldName);
        if (fieldClass.isAssignableFrom(values.getClass())) {
            boolean valid = true;
            for (Object member : values) {
                if (member == null || providedType.isAssignableFrom(member.getClass())) continue;
                valid = false;
                break;
            }
            if (valid) {
                return values;
            }
        }
        ArrayList list = new ArrayList(values.size());
        for (Object member : values) {
            list.add(CoerceUtil.coerce(member, providedType));
        }
        if (Set.class.isAssignableFrom(fieldClass)) {
            return new LinkedHashSet(list);
        }
        return list;
    }

    private Map coerceMap(Object target, Map<?, ?> values, String fieldName) {
        Class<?> valueType;
        Class<?> keyType = this.getParameterizedType(target, fieldName, 0);
        if (this.isValidParameterizedMap(values, keyType, valueType = this.getParameterizedType(target, fieldName, 1))) {
            return values;
        }
        LinkedHashMap result = new LinkedHashMap(values.size());
        for (Map.Entry<?, ?> entry : values.entrySet()) {
            result.put(CoerceUtil.coerce(entry.getKey(), keyType), CoerceUtil.coerce(entry.getValue(), valueType));
        }
        return result;
    }

    private boolean isValidParameterizedMap(Map<?, ?> values, Class<?> keyType, Class<?> valueType) {
        for (Map.Entry<?, ?> entry : values.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if ((key == null || keyType.isAssignableFrom(key.getClass())) && (value == null || valueType.isAssignableFrom(value.getClass()))) continue;
            return false;
        }
        return true;
    }

    private void bindIfUnbound(Class<?> entityClass) {
        if (!this.isClassBound(entityClass)) {
            this.bindEntity(entityClass);
        }
    }
}

