/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.yahoo.elide.core.CRUDEvent;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.functions.LifeCycleHook;
import com.yahoo.elide.security.RequestScope;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Optional;

public class LifecycleHookInvoker
implements Observer<CRUDEvent> {
    private EntityDictionary dictionary;
    private Class<? extends Annotation> annotation;
    private Optional<RuntimeException> exception;
    private boolean throwsExceptions;

    public LifecycleHookInvoker(EntityDictionary dictionary, Class<? extends Annotation> annotation, boolean throwExceptions) {
        this.dictionary = dictionary;
        this.annotation = annotation;
        this.exception = Optional.empty();
        this.throwsExceptions = throwExceptions;
    }

    public void onSubscribe(Disposable disposable) {
    }

    public void onNext(CRUDEvent event) {
        block3: {
            ArrayList<LifeCycleHook> hooks = new ArrayList<LifeCycleHook>();
            hooks.addAll(this.dictionary.getTriggers(event.getResource().getResourceClass(), this.annotation, event.getFieldName()));
            if (!event.getFieldName().isEmpty()) {
                hooks.addAll(this.dictionary.getTriggers(event.getResource().getResourceClass(), this.annotation));
            }
            try {
                hooks.forEach(hook -> hook.execute(event.getResource().getObject(), (RequestScope)event.getResource().getRequestScope(), event.getChanges()));
            }
            catch (RuntimeException e) {
                this.exception = Optional.of(e);
                if (!this.throwsExceptions) break block3;
                throw e;
            }
        }
    }

    public void onError(Throwable throwable) {
    }

    public void onComplete() {
    }

    public void throwOnError() {
        this.exception.ifPresent(e -> {
            throw e;
        });
    }
}

