/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RelationshipType;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.security.PermissionExecutor;
import com.yahoo.elide.security.permissions.ExpressionResult;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VerifyFieldAccessFilterExpressionVisitor
implements FilterExpressionVisitor<Boolean> {
    private PersistentResource<?> resource;

    public VerifyFieldAccessFilterExpressionVisitor(PersistentResource<?> resource) {
        this.resource = resource;
    }

    @Override
    public Boolean visitPredicate(FilterPredicate filterPredicate) {
        RequestScope requestScope = this.resource.getRequestScope();
        Set<PersistentResource<Object>> val = Collections.singleton(this.resource);
        PermissionExecutor permissionExecutor = requestScope.getPermissionExecutor();
        ExpressionResult result = permissionExecutor.evaluateFilterJoinUserChecks(this.resource, filterPredicate);
        if (result == ExpressionResult.UNEVALUATED) {
            result = this.evaluateUserChecks(filterPredicate, permissionExecutor);
        }
        if (result == ExpressionResult.PASS) {
            return true;
        }
        if (result == ExpressionResult.FAIL) {
            return false;
        }
        for (Path.PathElement element : filterPredicate.getPath().getPathElements()) {
            String fieldName = element.getFieldName();
            if ("this".equals(fieldName)) continue;
            try {
                val = val.stream().filter(Objects::nonNull).flatMap(x -> this.getValueChecked((PersistentResource<?>)x, fieldName, requestScope)).filter(Objects::nonNull).collect(Collectors.toSet());
            }
            catch (ForbiddenAccessException e) {
                result = permissionExecutor.handleFilterJoinReject(filterPredicate, element, e);
                if (result == ExpressionResult.DEFERRED) continue;
                return result == ExpressionResult.PASS;
            }
        }
        return true;
    }

    private Stream<PersistentResource> getValueChecked(PersistentResource<?> resource, String fieldName, RequestScope requestScope) {
        requestScope.getPermissionExecutor().checkSpecificFieldPermissions(resource, null, ReadPermission.class, fieldName);
        Object entity = resource.getObject();
        if (entity == null || resource.getDictionary().getRelationshipType(entity.getClass(), fieldName) == RelationshipType.NONE) {
            return Stream.empty();
        }
        return resource.getRelationChecked(fieldName, Optional.empty(), Optional.empty(), Optional.empty()).stream();
    }

    private ExpressionResult evaluateUserChecks(FilterPredicate filterPredicate, PermissionExecutor permissionExecutor) {
        PermissionExecutor executor = this.resource.getRequestScope().getPermissionExecutor();
        ExpressionResult ret = ExpressionResult.PASS;
        for (Path.PathElement element : filterPredicate.getPath().getPathElements()) {
            ExpressionResult result;
            try {
                result = executor.checkUserPermissions(element.getType(), ReadPermission.class, element.getFieldName());
            }
            catch (ForbiddenAccessException e) {
                result = permissionExecutor.handleFilterJoinReject(filterPredicate, element, e);
            }
            if (result == ExpressionResult.FAIL) {
                return ExpressionResult.FAIL;
            }
            if (result == ExpressionResult.PASS) continue;
            ret = ExpressionResult.DEFERRED;
        }
        return ret;
    }

    @Override
    public Boolean visitAndExpression(AndFilterExpression expression) {
        FilterExpression left = expression.getLeft();
        FilterExpression right = expression.getRight();
        return left.accept(this) != false && right.accept(this) != false;
    }

    @Override
    public Boolean visitOrExpression(OrFilterExpression expression) {
        FilterExpression left = expression.getLeft();
        FilterExpression right = expression.getRight();
        return left.accept(this) != false && right.accept(this) != false;
    }

    @Override
    public Boolean visitNotExpression(NotFilterExpression expression) {
        return expression.getNegated().accept(this);
    }
}

