/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.datastore.inmemory;

import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.inmemory.Operation;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.GeneratedValue;

public class HashMapStoreTransaction
implements DataStoreTransaction {
    private final Map<Class<?>, Map<String, Object>> dataStore;
    private final List<Operation> operations;
    private final EntityDictionary dictionary;
    private final Map<Class<?>, AtomicLong> typeIds;

    public HashMapStoreTransaction(Map<Class<?>, Map<String, Object>> dataStore, EntityDictionary dictionary, Map<Class<?>, AtomicLong> typeIds) {
        this.dataStore = dataStore;
        this.dictionary = dictionary;
        this.operations = new ArrayList<Operation>();
        this.typeIds = typeIds;
    }

    @Override
    public void flush(RequestScope requestScope) {
    }

    @Override
    public void save(Object object, RequestScope requestScope) {
        if (object == null) {
            return;
        }
        String id = this.dictionary.getId(object);
        if (id == null || "null".equals(id) || "0".equals(id)) {
            this.createObject(object, requestScope);
        }
        id = this.dictionary.getId(object);
        this.operations.add(new Operation(id, object, object.getClass(), Operation.OpType.UPDATE));
    }

    @Override
    public void delete(Object object, RequestScope requestScope) {
        if (object == null) {
            return;
        }
        String id = this.dictionary.getId(object);
        this.operations.add(new Operation(id, object, object.getClass(), Operation.OpType.DELETE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(RequestScope scope) {
        Map<Class<?>, Map<String, Object>> map = this.dataStore;
        synchronized (map) {
            this.operations.stream().filter(op -> op.getInstance() != null).forEach(op -> {
                Object instance = op.getInstance();
                String id = op.getId();
                Map<String, Object> data = this.dataStore.get(op.getType());
                if (op.getOpType() == Operation.OpType.DELETE) {
                    data.remove(id);
                } else {
                    if (op.getOpType() == Operation.OpType.CREATE && data.get(id) != null) {
                        throw new TransactionException(new IllegalStateException("Duplicate key"));
                    }
                    data.put(id, instance);
                }
            });
            this.operations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createObject(Object entity, RequestScope scope) {
        String id;
        Class<?> entityClass = entity.getClass();
        String idFieldName = this.dictionary.getIdFieldName(entityClass);
        if (this.containsObject(entity)) {
            throw new TransactionException(new IllegalStateException("Duplicate key"));
        }
        if (this.dictionary.getAttributeOrRelationAnnotation(entityClass, GeneratedValue.class, idFieldName) != null) {
            AtomicLong nextId;
            Map<Class<?>, Map<String, Object>> map = this.dataStore;
            synchronized (map) {
                nextId = this.typeIds.computeIfAbsent(entityClass, key -> {
                    long maxId = this.dataStore.get(key).keySet().stream().mapToLong(Long::parseLong).max().orElse(0L);
                    return new AtomicLong(maxId + 1L);
                });
            }
            id = String.valueOf(nextId.getAndIncrement());
            this.setId(entity, id);
        } else {
            id = this.dictionary.getId(entity);
        }
        this.operations.add(new Operation(id, entity, entity.getClass(), Operation.OpType.CREATE));
    }

    public void setId(Object value, String id) {
        this.dictionary.setValue(value, this.dictionary.getIdFieldName(value.getClass()), id);
    }

    @Override
    public Object getRelation(DataStoreTransaction relationTx, Object entity, String relationName, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope scope) {
        return this.dictionary.getValue(entity, relationName, scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Object> loadObjects(Class<?> entityClass, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope scope) {
        Map<Class<?>, Map<String, Object>> map = this.dataStore;
        synchronized (map) {
            Map<String, Object> data = this.dataStore.get(entityClass);
            return data.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object loadObject(Class<?> entityClass, Serializable id, Optional<FilterExpression> filterExpression, RequestScope scope) {
        Map<Class<?>, Map<String, Object>> map = this.dataStore;
        synchronized (map) {
            Map<String, Object> data = this.dataStore.get(entityClass);
            if (data == null) {
                return null;
            }
            return data.get(id.toString());
        }
    }

    @Override
    public void close() throws IOException {
        this.operations.clear();
    }

    @Override
    public DataStoreTransaction.FeatureSupport supportsFiltering(Class<?> entityClass, FilterExpression expression) {
        return DataStoreTransaction.FeatureSupport.NONE;
    }

    @Override
    public boolean supportsSorting(Class<?> entityClass, Sorting sorting) {
        return false;
    }

    @Override
    public boolean supportsPagination(Class<?> entityClass) {
        return false;
    }

    private boolean containsObject(Object obj) {
        return this.dataStore.get(obj.getClass()).containsValue(obj);
    }
}

