/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.datastore.inmemory;

import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterPredicatePushdownExtractor;
import com.yahoo.elide.core.filter.expression.InMemoryExecutionVerifier;
import com.yahoo.elide.core.filter.expression.InMemoryFilterExecutor;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import com.yahoo.elide.security.User;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;

public class InMemoryStoreTransaction
implements DataStoreTransaction {
    private static final Comparator<Object> NULL_SAFE_COMPARE = (a, b) -> {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Comparable) {
            return ((Comparable)a).compareTo(b);
        }
        throw new IllegalStateException("Trying to comparing non-comparable types!");
    };
    private DataStoreTransaction tx;

    public InMemoryStoreTransaction(DataStoreTransaction tx) {
        this.tx = tx;
    }

    @Override
    public void save(Object entity, RequestScope scope) {
        this.tx.save(entity, scope);
    }

    @Override
    public void delete(Object entity, RequestScope scope) {
        this.tx.delete(entity, scope);
    }

    @Override
    public User accessUser(Object opaqueUser) {
        return this.tx.accessUser(opaqueUser);
    }

    @Override
    public void preCommit() {
        this.tx.preCommit();
    }

    @Override
    public <T> T createNewObject(Class<T> entityClass) {
        return this.tx.createNewObject(entityClass);
    }

    @Override
    public Object getRelation(final DataStoreTransaction relationTx, final Object entity, final String relationName, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope scope) {
        Class<?> relationClass = scope.getDictionary().getParameterizedType(entity, relationName);
        DataFetcher fetcher = new DataFetcher(){

            @Override
            public Object fetch(Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope scope) {
                return InMemoryStoreTransaction.this.tx.getRelation(relationTx, entity, relationName, filterExpression, sorting, pagination, scope);
            }
        };
        boolean filterInMemory = scope.getNewPersistentResources().size() > 0;
        return this.fetchData(fetcher, relationClass, filterExpression, sorting, pagination, filterInMemory, scope);
    }

    @Override
    public void updateToManyRelation(DataStoreTransaction relationTx, Object entity, String relationName, Set<Object> newRelationships, Set<Object> deletedRelationships, RequestScope scope) {
        this.tx.updateToManyRelation(relationTx, entity, relationName, newRelationships, deletedRelationships, scope);
    }

    @Override
    public void updateToOneRelation(DataStoreTransaction relationTx, Object entity, String relationName, Object relationshipValue, RequestScope scope) {
        this.tx.updateToOneRelation(relationTx, entity, relationName, relationshipValue, scope);
    }

    @Override
    public Object getAttribute(Object entity, String attributeName, RequestScope scope) {
        return this.tx.getAttribute(entity, attributeName, scope);
    }

    @Override
    public void setAttribute(Object entity, String attributeName, Object attributeValue, RequestScope scope) {
        this.tx.setAttribute(entity, attributeName, attributeValue, scope);
    }

    @Override
    public void flush(RequestScope scope) {
        this.tx.flush(scope);
    }

    @Override
    public void commit(RequestScope scope) {
        this.tx.commit(scope);
    }

    @Override
    public void createObject(Object entity, RequestScope scope) {
        this.tx.createObject(entity, scope);
    }

    @Override
    public Object loadObject(Class<?> entityClass, Serializable id, Optional<FilterExpression> filterExpression, RequestScope scope) {
        if (!filterExpression.isPresent() || this.tx.supportsFiltering(entityClass, filterExpression.get()) == DataStoreTransaction.FeatureSupport.FULL) {
            return this.tx.loadObject(entityClass, id, filterExpression, scope);
        }
        return DataStoreTransaction.super.loadObject(entityClass, id, filterExpression, scope);
    }

    @Override
    public Iterable<Object> loadObjects(final Class<?> entityClass, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope scope) {
        DataFetcher fetcher = new DataFetcher(){

            @Override
            public Iterable<Object> fetch(Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope scope) {
                return InMemoryStoreTransaction.this.tx.loadObjects(entityClass, filterExpression, sorting, pagination, scope);
            }
        };
        return (Iterable)this.fetchData(fetcher, entityClass, filterExpression, sorting, pagination, false, scope);
    }

    @Override
    public void close() throws IOException {
        this.tx.close();
    }

    private Iterable<Object> filterLoadedData(Iterable<Object> loadedRecords, Optional<FilterExpression> filterExpression, RequestScope scope) {
        if (!filterExpression.isPresent()) {
            return loadedRecords;
        }
        Predicate predicate = filterExpression.get().accept(new InMemoryFilterExecutor(scope));
        return StreamSupport.stream(loadedRecords.spliterator(), false).filter(predicate::test).collect(Collectors.toList());
    }

    private Object fetchData(DataFetcher fetcher, Class<?> entityClass, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, boolean filterInMemory, RequestScope scope) {
        Pair<Optional<FilterExpression>, Optional<FilterExpression>> expressionSplit = this.splitFilterExpression(entityClass, filterExpression, filterInMemory, scope);
        Optional dataStoreFilter = (Optional)expressionSplit.getLeft();
        Optional inMemoryFilter = (Optional)expressionSplit.getRight();
        Pair<Optional<Sorting>, Optional<Sorting>> sortSplit = this.splitSorting(entityClass, sorting, inMemoryFilter.isPresent());
        Optional dataStoreSort = (Optional)sortSplit.getLeft();
        Optional inMemorySort = (Optional)sortSplit.getRight();
        Pair<Optional<Pagination>, Optional<Pagination>> paginationSplit = this.splitPagination(entityClass, pagination, inMemoryFilter.isPresent(), inMemorySort.isPresent());
        Optional dataStorePagination = (Optional)paginationSplit.getLeft();
        Optional inMemoryPagination = (Optional)paginationSplit.getRight();
        Object result = fetcher.fetch(dataStoreFilter, dataStoreSort, dataStorePagination, scope);
        if (!(result instanceof Iterable)) {
            return result;
        }
        Iterable<Object> loadedRecords = (Iterable<Object>)result;
        if (inMemoryFilter.isPresent()) {
            loadedRecords = this.filterLoadedData(loadedRecords, filterExpression, scope);
        }
        return this.sortAndPaginateLoadedData(loadedRecords, entityClass, inMemorySort, inMemoryPagination, scope);
    }

    private Iterable<Object> sortAndPaginateLoadedData(Iterable<Object> loadedRecords, Class<?> entityClass, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope scope) {
        if (!sorting.isPresent() && !pagination.isPresent()) {
            return loadedRecords;
        }
        EntityDictionary dictionary = scope.getDictionary();
        Map sortRules = sorting.map(s -> s.getValidSortingRules(entityClass, dictionary)).orElse(new HashMap());
        if (sortRules.isEmpty() && !pagination.isPresent()) {
            return loadedRecords;
        }
        List<Object> results = StreamSupport.stream(loadedRecords.spliterator(), false).collect(Collectors.toList());
        if (!sortRules.isEmpty()) {
            results = this.sortInMemory(results, sortRules, scope);
        }
        if (pagination.isPresent()) {
            results = this.paginateInMemory(results, pagination.get());
        }
        return results;
    }

    private List<Object> paginateInMemory(List<Object> records, Pagination pagination) {
        int offset = pagination.getOffset();
        int limit = pagination.getLimit();
        if (offset < 0 || offset >= records.size()) {
            return Collections.emptyList();
        }
        int endIdx = offset + limit;
        if (endIdx > records.size()) {
            endIdx = records.size();
        }
        if (pagination.isGenerateTotals()) {
            pagination.setPageTotals(records.size());
        }
        return records.subList(offset, endIdx);
    }

    private List<Object> sortInMemory(List<Object> records, Map<Path, Sorting.SortOrder> sortRules, RequestScope scope) {
        Comparator noSort = (left, right) -> 0;
        Comparator comp = sortRules.entrySet().stream().map(entry -> this.getComparator((Path)entry.getKey(), (Sorting.SortOrder)((Object)((Object)entry.getValue())), scope)).reduce(noSort, (comparator1, comparator2) -> (left, right) -> {
            int comparison = comparator1.compare(left, right);
            if (comparison == 0) {
                return comparator2.compare(left, right);
            }
            return comparison;
        });
        records.sort(comp);
        return records;
    }

    private Comparator<Object> getComparator(Path path, Sorting.SortOrder order, RequestScope requestScope) {
        return (left, right) -> {
            Object leftCompare = left;
            Object rightCompare = right;
            for (Path.PathElement pathElement : path.getPathElements()) {
                leftCompare = leftCompare == null ? null : PersistentResource.getValue(leftCompare, pathElement.getFieldName(), requestScope);
                rightCompare = rightCompare == null ? null : PersistentResource.getValue(rightCompare, pathElement.getFieldName(), requestScope);
            }
            if (order == Sorting.SortOrder.asc) {
                return NULL_SAFE_COMPARE.compare(leftCompare, rightCompare);
            }
            return NULL_SAFE_COMPARE.compare(rightCompare, leftCompare);
        };
    }

    private Pair<Optional<FilterExpression>, Optional<FilterExpression>> splitFilterExpression(Class<?> entityClass, Optional<FilterExpression> filterExpression, boolean filterInMemory, RequestScope scope) {
        Optional<FilterExpression> inStoreFilterExpression = filterExpression;
        Optional<Object> inMemoryFilterExpression = Optional.empty();
        boolean transactionNeedsInMemoryFiltering = filterInMemory;
        if (filterExpression.isPresent()) {
            DataStoreTransaction.FeatureSupport filterSupport = this.tx.supportsFiltering(entityClass, filterExpression.get());
            boolean storeNeedsInMemoryFiltering = filterSupport != DataStoreTransaction.FeatureSupport.FULL;
            inStoreFilterExpression = transactionNeedsInMemoryFiltering || filterSupport == DataStoreTransaction.FeatureSupport.NONE ? Optional.empty() : Optional.ofNullable(FilterPredicatePushdownExtractor.extractPushDownPredicate(scope.getDictionary(), filterExpression.get()));
            boolean expressionNeedsInMemoryFiltering = InMemoryExecutionVerifier.shouldExecuteInMemory(scope.getDictionary(), filterExpression.get());
            if (transactionNeedsInMemoryFiltering || storeNeedsInMemoryFiltering || expressionNeedsInMemoryFiltering) {
                inMemoryFilterExpression = filterExpression;
            }
        }
        return Pair.of(inStoreFilterExpression, inMemoryFilterExpression);
    }

    private Pair<Optional<Sorting>, Optional<Sorting>> splitSorting(Class<?> entityClass, Optional<Sorting> sorting, boolean filteredInMemory) {
        if (sorting.isPresent() && (!this.tx.supportsSorting(entityClass, sorting.get()) || filteredInMemory)) {
            return Pair.of(Optional.empty(), sorting);
        }
        return Pair.of(sorting, Optional.empty());
    }

    private Pair<Optional<Pagination>, Optional<Pagination>> splitPagination(Class<?> entityClass, Optional<Pagination> pagination, boolean filteredInMemory, boolean sortedInMemory) {
        if (!this.tx.supportsPagination(entityClass) || filteredInMemory || sortedInMemory) {
            return Pair.of(Optional.empty(), pagination);
        }
        if (pagination.isPresent() && pagination.get().isDefaultInstance()) {
            return Pair.of(pagination, pagination);
        }
        return Pair.of(pagination, Optional.empty());
    }

    @FunctionalInterface
    private static interface DataFetcher {
        public Object fetch(Optional<FilterExpression> var1, Optional<Sorting> var2, Optional<Pagination> var3, RequestScope var4);
    }
}

