/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.exceptions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.core.EntityDictionary;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpStatusException
extends RuntimeException {
    private static final Logger log = LoggerFactory.getLogger(HttpStatusException.class);
    private static final long serialVersionUID = 1L;
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected final int status;
    private final Optional<Supplier<String>> verboseMessageSupplier;

    public HttpStatusException(int status, String message) {
        this(status, message, null, null);
    }

    public HttpStatusException(int status, String message, Throwable cause, Supplier<String> verboseMessageSupplier) {
        super(message, cause, true, log.isTraceEnabled());
        this.status = status;
        this.verboseMessageSupplier = Optional.ofNullable(verboseMessageSupplier);
    }

    protected static String formatExceptionCause(Throwable e) {
        Throwable error = e.getCause() == null ? e : e.getCause();
        return error != null ? (String)StringUtils.defaultIfBlank((CharSequence)error.getMessage(), (CharSequence)error.toString()) : null;
    }

    public Pair<Integer, JsonNode> getErrorResponse() {
        return this.getErrorResponse(false);
    }

    public Pair<Integer, JsonNode> getErrorResponse(boolean encodeResponse) {
        String message = encodeResponse ? Encode.forHtml((String)this.toString()) : this.toString();
        Map<String, List<String>> errors = Collections.singletonMap("errors", Collections.singletonList(message));
        return this.buildResponse(errors);
    }

    public Pair<Integer, JsonNode> getVerboseErrorResponse() {
        return this.getVerboseErrorResponse(false);
    }

    public Pair<Integer, JsonNode> getVerboseErrorResponse(boolean encodeResponse) {
        String message = encodeResponse ? Encode.forHtml((String)this.getVerboseMessage()) : this.getVerboseMessage();
        Map<String, List<String>> errors = Collections.singletonMap("errors", Collections.singletonList(message));
        return this.buildResponse(errors);
    }

    private Pair<Integer, JsonNode> buildResponse(Map<String, List<String>> errors) {
        JsonNode responseBody = (JsonNode)OBJECT_MAPPER.convertValue(errors, JsonNode.class);
        return Pair.of((Object)this.getStatus(), (Object)responseBody);
    }

    public String getVerboseMessage() {
        return this.verboseMessageSupplier.map(Supplier::get).orElse(this.toString());
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        String message = this.getMessage();
        String className = EntityDictionary.getSimpleName(this.getClass());
        message = message == null ? className : className + ": " + message;
        return message;
    }
}

