/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.document.processors;

import com.google.common.collect.Lists;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.jsonapi.document.processors.DocumentProcessor;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;

public class IncludedProcessor
implements DocumentProcessor {
    private static final String RELATION_PATH_DELIMITER = "\\.";
    private static final String RELATION_PATH_SEPARATOR = ",";
    private static final String INCLUDE = "include";

    @Override
    public void execute(JsonApiDocument jsonApiDocument, PersistentResource resource, Optional<MultivaluedMap<String, String>> queryParams) {
        if (IncludedProcessor.isPresent(queryParams, INCLUDE)) {
            this.addIncludedResources(jsonApiDocument, resource, (List)queryParams.get().get((Object)INCLUDE));
        }
    }

    @Override
    public void execute(JsonApiDocument jsonApiDocument, Set<PersistentResource> resources, Optional<MultivaluedMap<String, String>> queryParams) {
        if (IncludedProcessor.isPresent(queryParams, INCLUDE)) {
            resources.forEach(resource -> this.addIncludedResources(jsonApiDocument, (PersistentResource)resource, (List)((MultivaluedMap)queryParams.get()).get((Object)INCLUDE)));
        }
    }

    private void addIncludedResources(JsonApiDocument jsonApiDocument, PersistentResource rec, List<String> requestedRelationPaths) {
        requestedRelationPaths.forEach(pathParam -> {
            List<String> pathList = Arrays.asList(pathParam.split(RELATION_PATH_SEPARATOR));
            pathList.forEach(requestedRelationPath -> {
                ArrayList relationPath = Lists.newArrayList((Object[])requestedRelationPath.split(RELATION_PATH_DELIMITER));
                this.addResourcesForPath(jsonApiDocument, rec, relationPath);
            });
        });
    }

    private void addResourcesForPath(JsonApiDocument jsonApiDocument, PersistentResource<?> rec, List<String> relationPath) {
        Set<PersistentResource> collection;
        String relation = relationPath.remove(0);
        Optional<FilterExpression> filterExpression = rec.getRequestScope().getExpressionForRelation(rec, relation);
        try {
            collection = rec.getRelationCheckedFiltered(relation, filterExpression, Optional.empty(), Optional.empty());
        }
        catch (ForbiddenAccessException e) {
            return;
        }
        collection.forEach(resource -> {
            jsonApiDocument.addIncluded(resource.toResource());
            if (!relationPath.isEmpty()) {
                this.addResourcesForPath(jsonApiDocument, (PersistentResource<?>)resource, (List<String>)new ArrayList<String>(relationPath));
            }
        });
    }

    private static boolean isPresent(Optional<MultivaluedMap<String, String>> queryParams, String key) {
        return queryParams.isPresent() && queryParams.get().get((Object)key) != null;
    }
}

