/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.parsers.expression;

import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.security.FilterExpressionCheck;
import com.yahoo.elide.security.RequestScope;

public class FilterExpressionCheckEvaluationVisitor
implements FilterExpressionVisitor<Boolean> {
    private final Object object;
    private final FilterExpressionCheck filterExpressionCheck;
    private final RequestScope requestScope;

    public FilterExpressionCheckEvaluationVisitor(Object object, FilterExpressionCheck filterExpressionCheck, RequestScope requestScope) {
        this.object = object;
        this.filterExpressionCheck = filterExpressionCheck;
        this.requestScope = requestScope;
    }

    @Override
    public Boolean visitPredicate(FilterPredicate filterPredicate) {
        return this.filterExpressionCheck.applyPredicateToObject(this.object, filterPredicate, this.requestScope);
    }

    @Override
    public Boolean visitAndExpression(AndFilterExpression expression) {
        FilterExpression left = expression.getLeft();
        FilterExpression right = expression.getRight();
        return left.accept(this) != false && right.accept(this) != false;
    }

    @Override
    public Boolean visitOrExpression(OrFilterExpression expression) {
        FilterExpression left = expression.getLeft();
        FilterExpression right = expression.getRight();
        return left.accept(this) != false || right.accept(this) != false;
    }

    @Override
    public Boolean visitNotExpression(NotFilterExpression expression) {
        FilterExpression negation = expression.getNegated();
        return negation.accept(this) == false;
    }
}

