/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.parsers.expression;

import com.yahoo.elide.core.CheckInstantiator;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.generated.parsers.ExpressionBaseVisitor;
import com.yahoo.elide.generated.parsers.ExpressionParser;
import com.yahoo.elide.security.FilterExpressionCheck;
import com.yahoo.elide.security.RequestScope;
import com.yahoo.elide.security.checks.Check;
import com.yahoo.elide.security.checks.UserCheck;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;

public class PermissionToFilterExpressionVisitor
extends ExpressionBaseVisitor<FilterExpression>
implements CheckInstantiator {
    private final EntityDictionary dictionary;
    private final Class entityClass;
    private final RequestScope requestScope;
    public static final FilterExpression NO_EVALUATION_EXPRESSION = new FilterExpression(){

        @Override
        public <T> T accept(FilterExpressionVisitor<T> visitor) {
            return (T)this;
        }

        public String toString() {
            return "NO_EVALUATION_EXPRESSION";
        }
    };
    public static final FilterExpression FALSE_USER_CHECK_EXPRESSION = new FilterExpression(){

        @Override
        public <T> T accept(FilterExpressionVisitor<T> visitor) {
            return (T)this;
        }

        public String toString() {
            return "FALSE_USER_CHECK_EXPRESSION";
        }
    };
    public static final FilterExpression TRUE_USER_CHECK_EXPRESSION = new FilterExpression(){

        @Override
        public <T> T accept(FilterExpressionVisitor<T> visitor) {
            return (T)this;
        }

        public String toString() {
            return "TRUE_USER_EXPRESSION";
        }
    };

    public PermissionToFilterExpressionVisitor(EntityDictionary dictionary, RequestScope requestScope, Class entityClass) {
        this.dictionary = dictionary;
        this.requestScope = requestScope;
        this.entityClass = entityClass;
    }

    @Override
    public FilterExpression visitNOT(ExpressionParser.NOTContext ctx) {
        FilterExpression expression = (FilterExpression)this.visit((ParseTree)ctx.expression());
        if (Objects.equals(expression, TRUE_USER_CHECK_EXPRESSION)) {
            return FALSE_USER_CHECK_EXPRESSION;
        }
        if (Objects.equals(expression, FALSE_USER_CHECK_EXPRESSION)) {
            return TRUE_USER_CHECK_EXPRESSION;
        }
        if (Objects.equals(expression, NO_EVALUATION_EXPRESSION)) {
            return NO_EVALUATION_EXPRESSION;
        }
        return new NotFilterExpression(expression);
    }

    @Override
    public FilterExpression visitOR(ExpressionParser.ORContext ctx) {
        FilterExpression left = (FilterExpression)this.visit((ParseTree)ctx.left);
        FilterExpression right = (FilterExpression)this.visit((ParseTree)ctx.right);
        if (this.expressionWillNotFilter(left)) {
            return left;
        }
        if (this.expressionWillNotFilter(right)) {
            return right;
        }
        boolean leftFails = this.expressionWillFail(left);
        boolean rightFails = this.expressionWillFail(right);
        if (leftFails && rightFails) {
            return FALSE_USER_CHECK_EXPRESSION;
        }
        if (leftFails) {
            return right;
        }
        if (rightFails) {
            return left;
        }
        return new OrFilterExpression(left, right);
    }

    @Override
    public FilterExpression visitAND(ExpressionParser.ANDContext ctx) {
        FilterExpression left = (FilterExpression)this.visit((ParseTree)ctx.left);
        FilterExpression right = (FilterExpression)this.visit((ParseTree)ctx.right);
        if (this.expressionWillFail(left) || this.expressionWillFail(right)) {
            return FALSE_USER_CHECK_EXPRESSION;
        }
        if (this.expressionWillNotFilter(left)) {
            return right;
        }
        if (this.expressionWillNotFilter(right)) {
            return left;
        }
        return new AndFilterExpression(left, right);
    }

    private boolean expressionWillFail(FilterExpression expression) {
        return Objects.equals(expression, FALSE_USER_CHECK_EXPRESSION) || this.operator(expression) == Operator.FALSE;
    }

    private boolean expressionWillNotFilter(FilterExpression expression) {
        return Objects.equals(expression, NO_EVALUATION_EXPRESSION) || Objects.equals(expression, TRUE_USER_CHECK_EXPRESSION) || this.operator(expression) == Operator.TRUE;
    }

    @Override
    public FilterExpression visitPermissionClass(ExpressionParser.PermissionClassContext ctx) {
        Check check = this.getCheck(this.dictionary, ctx.getText());
        if (check instanceof FilterExpressionCheck) {
            FilterExpressionCheck filterCheck = (FilterExpressionCheck)check;
            FilterExpression filterExpression = filterCheck.getFilterExpression(this.entityClass, this.requestScope);
            if (filterExpression == null) {
                throw new IllegalStateException("FilterCheck#getFilterExpression must not return null.");
            }
            return filterExpression;
        }
        if (check instanceof UserCheck) {
            boolean userCheckResult = check.ok(this.requestScope.getUser());
            return userCheckResult ? TRUE_USER_CHECK_EXPRESSION : FALSE_USER_CHECK_EXPRESSION;
        }
        return NO_EVALUATION_EXPRESSION;
    }

    private Operator operator(FilterExpression expression) {
        return expression instanceof FilterPredicate ? ((FilterPredicate)expression).getOperator() : null;
    }

    @Override
    public FilterExpression visitPAREN(ExpressionParser.PARENContext ctx) {
        return (FilterExpression)this.visit((ParseTree)ctx.expression());
    }
}

