/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.parsers.state;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.InternalServerErrorException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.exceptions.InvalidObjectIdentifierException;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.exceptions.UnknownEntityException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.document.processors.IncludedProcessor;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.models.Meta;
import com.yahoo.elide.jsonapi.models.Relationship;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.parsers.state.BaseState;
import com.yahoo.elide.parsers.state.StateContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CollectionTerminalState
extends BaseState {
    private final Optional<PersistentResource> parent;
    private final Optional<String> relationName;
    private final Class<?> entityClass;
    private PersistentResource newObject;

    public CollectionTerminalState(Class<?> entityClass, Optional<PersistentResource> parent, Optional<String> relationName) {
        this.parent = parent;
        this.relationName = relationName;
        this.entityClass = entityClass;
    }

    @Override
    public Supplier<Pair<Integer, JsonNode>> handleGet(StateContext state) {
        JsonApiDocument jsonApiDocument = new JsonApiDocument();
        RequestScope requestScope = state.getRequestScope();
        Optional<MultivaluedMap<String, String>> queryParams = requestScope.getQueryParams();
        Set<PersistentResource> collection = this.getResourceCollection(requestScope);
        jsonApiDocument.setData(this.getData(collection));
        IncludedProcessor includedProcessor = new IncludedProcessor();
        includedProcessor.execute(jsonApiDocument, collection, queryParams);
        Pagination pagination = requestScope.getPagination();
        if (!pagination.isEmpty()) {
            HashMap<String, Number> pageMetaData = new HashMap<String, Number>();
            pageMetaData.put("number", pagination.getOffset() / pagination.getLimit() + 1);
            pageMetaData.put("limit", pagination.getLimit());
            if (pagination.isGenerateTotals()) {
                Long totalRecords = pagination.getPageTotals();
                pageMetaData.put("totalPages", totalRecords / (long)pagination.getLimit() + (long)(totalRecords % (long)pagination.getLimit() > 0L ? 1 : 0));
                pageMetaData.put("totalRecords", totalRecords);
            }
            HashMap<String, Object> allMetaData = new HashMap<String, Object>();
            allMetaData.put("page", pageMetaData);
            Meta meta = new Meta(allMetaData);
            jsonApiDocument.setMeta(meta);
        }
        JsonNode responseBody = requestScope.getMapper().toJsonObject(jsonApiDocument);
        return () -> Pair.of((Object)200, (Object)responseBody);
    }

    @Override
    public Supplier<Pair<Integer, JsonNode>> handlePost(StateContext state) {
        RequestScope requestScope = state.getRequestScope();
        JsonApiMapper mapper = requestScope.getMapper();
        this.newObject = this.createObject(requestScope);
        this.parent.ifPresent(persistentResource -> persistentResource.addRelation(this.relationName.get(), this.newObject));
        return () -> {
            JsonApiDocument returnDoc = new JsonApiDocument();
            returnDoc.setData(new Data<Resource>(this.newObject.toResource()));
            JsonNode responseBody = (JsonNode)mapper.getObjectMapper().convertValue((Object)returnDoc, JsonNode.class);
            return Pair.of((Object)201, (Object)responseBody);
        };
    }

    private Set<PersistentResource> getResourceCollection(RequestScope requestScope) {
        Set<PersistentResource> collection;
        Optional<Pagination> pagination = Optional.ofNullable(requestScope.getPagination());
        Optional<Sorting> sorting = Optional.ofNullable(requestScope.getSorting());
        if (this.parent.isPresent()) {
            Optional<FilterExpression> filterExpression = requestScope.getExpressionForRelation(this.parent.get(), this.relationName.get());
            collection = this.parent.get().getRelationCheckedFiltered(this.relationName.get(), filterExpression, sorting, pagination);
        } else {
            Optional<FilterExpression> filterExpression = requestScope.getLoadFilterExpression(this.entityClass);
            collection = PersistentResource.loadRecords(this.entityClass, new ArrayList<String>(), filterExpression, sorting, pagination, requestScope);
        }
        return collection;
    }

    private Data getData(Set<PersistentResource> collection) {
        Preconditions.checkNotNull(collection);
        List resources = collection.stream().map(PersistentResource::toResource).collect(Collectors.toList());
        return new Data(resources);
    }

    private PersistentResource createObject(RequestScope requestScope) throws ForbiddenAccessException, InvalidObjectIdentifierException {
        Map<String, Relationship> relationships;
        Resource resource;
        JsonApiDocument doc = requestScope.getJsonApiDocument();
        JsonApiMapper mapper = requestScope.getMapper();
        Data<Resource> data = doc.getData();
        Collection<Resource> resources = data.get();
        Resource resource2 = resource = resources.size() == 1 ? (Resource)IterableUtils.first(resources) : null;
        if (resource == null) {
            try {
                throw new InvalidEntityBodyException(mapper.writeJsonApiDocument(doc));
            }
            catch (JsonProcessingException e) {
                throw new InternalServerErrorException(e);
            }
        }
        String id = resource.getId();
        Class<?> newObjectClass = requestScope.getDictionary().getEntityClass(resource.getType());
        if (newObjectClass == null) {
            throw new UnknownEntityException("Entity " + resource.getType() + " not found");
        }
        if (!this.entityClass.isAssignableFrom(newObjectClass)) {
            throw new InvalidValueException((Object)("Cannot assign value of type: " + resource.getType() + " to type: " + this.entityClass));
        }
        PersistentResource<?> pResource = PersistentResource.createObject(this.parent.orElse(null), newObjectClass, requestScope, Optional.ofNullable(id));
        Map<String, Object> attributes = resource.getAttributes();
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                String fieldName = entry.getKey();
                Object val = entry.getValue();
                pResource.updateAttribute(fieldName, val);
            }
        }
        if ((relationships = resource.getRelationships()) != null) {
            for (Map.Entry<String, Relationship> entry : relationships.entrySet()) {
                String fieldName = entry.getKey();
                Relationship relationship = entry.getValue();
                Set<PersistentResource> resourceSet = relationship == null ? null : relationship.toPersistentResources(requestScope);
                pResource.updateRelation(fieldName, resourceSet);
            }
        }
        return pResource;
    }

    public String toString() {
        return "CollectionTerminalState(parent=" + this.parent + ", relationName=" + this.relationName + ", entityClass=" + this.entityClass + ", newObject=" + this.newObject + ")";
    }
}

