/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.parsers.state;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.exceptions.InvalidAttributeException;
import com.yahoo.elide.core.exceptions.InvalidCollectionException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.generated.parsers.CoreParser;
import com.yahoo.elide.parsers.state.BaseState;
import com.yahoo.elide.parsers.state.CollectionTerminalState;
import com.yahoo.elide.parsers.state.RecordState;
import com.yahoo.elide.parsers.state.RecordTerminalState;
import com.yahoo.elide.parsers.state.RelationshipTerminalState;
import com.yahoo.elide.parsers.state.StateContext;
import java.util.Optional;

public class StartState
extends BaseState {
    @Override
    public void handle(StateContext state, CoreParser.RootCollectionLoadEntitiesContext ctx) {
        String entityName = ctx.term().getText();
        EntityDictionary dictionary = state.getRequestScope().getDictionary();
        Class<?> entityClass = dictionary.getEntityClass(entityName);
        if (entityClass == null || !dictionary.isRoot(entityClass)) {
            throw new InvalidCollectionException(entityName);
        }
        state.setState(new CollectionTerminalState(entityClass, Optional.empty(), Optional.empty()));
    }

    @Override
    public void handle(StateContext state, CoreParser.RootCollectionLoadEntityContext ctx) {
        PersistentResource<?> record = this.entityRecord(state, ctx.entity());
        state.setState(new RecordTerminalState(record));
    }

    @Override
    public void handle(StateContext state, CoreParser.RootCollectionSubCollectionContext ctx) {
        PersistentResource<?> record = this.entityRecord(state, ctx.entity());
        state.setState(new RecordState(record));
    }

    @Override
    public void handle(StateContext state, CoreParser.RootCollectionRelationshipContext ctx) {
        PersistentResource<?> record = this.entityRecord(state, ctx.entity());
        String relationName = ctx.relationship().term().getText();
        try {
            Optional<FilterExpression> filterExpression = state.getRequestScope().getExpressionForRelation(record, relationName);
            record.getRelationCheckedFiltered(relationName, filterExpression, Optional.empty(), Optional.empty());
        }
        catch (InvalidAttributeException e) {
            throw new InvalidCollectionException(relationName);
        }
        state.setState(new RelationshipTerminalState(record, relationName));
    }

    public String toString() {
        return this.getClass().getName();
    }

    private PersistentResource<?> entityRecord(StateContext state, CoreParser.EntityContext entity) {
        String entityName = entity.term().getText();
        String id = entity.id().getText();
        EntityDictionary dictionary = state.getRequestScope().getDictionary();
        Class<?> entityClass = dictionary.getEntityClass(entityName);
        if (entityClass == null || !dictionary.isRoot(entityClass)) {
            throw new InvalidCollectionException(entityName);
        }
        return PersistentResource.loadRecord(entityClass, id, state.getRequestScope());
    }
}

