/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.security.permissions;

import com.yahoo.elide.security.PersistentResource;
import com.yahoo.elide.security.checks.Check;
import com.yahoo.elide.security.permissions.ExpressionResult;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class ExpressionResultCache {
    private final Map<Class<? extends Check>, Map<PersistentResource, ExpressionResult>> computedResults = new HashMap<Class<? extends Check>, Map<PersistentResource, ExpressionResult>>();

    public boolean hasStoredResultFor(Class<? extends Check> checkClass, PersistentResource resource) {
        return this.computedResults.containsKey(checkClass) && this.computedResults.get(checkClass).containsKey(resource);
    }

    public void putResultFor(Class<? extends Check> checkClass, PersistentResource resource, ExpressionResult result) {
        Map cache = this.computedResults.computeIfAbsent(checkClass, unused -> new IdentityHashMap());
        cache.put(resource, result);
    }

    public ExpressionResult getResultFor(Class<? extends Check> checkClass, PersistentResource resource) {
        return this.computedResults.get(checkClass).get(resource);
    }
}

